package org.gcube.geoindexupdater.client.library.utils;

import static org.gcube.common.clients.stubs.jaxws.GCoreServiceBuilder.*;

import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.stubs.jaxws.GCoreService;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterFactoryStub;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterStub;

import javax.xml.namespace.QName;

public class GeoIndexUpdaterCLConstants {
	public static final int DEFAULT_TIMEOUT= (int) TimeUnit.SECONDS.toMillis(600000);

	public static final String NAMESPACE = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexUpdaterService";
	public static final String NAME = "gcube/indexmanagement/geoindexupdater/GeoIndexUpdater";
	public static final String FACTORYNAME = "gcube/indexmanagement/geoindexupdater/GeoIndexUpdaterFactory";
	public static final QName name = new QName("http://gcube-system.org/namespaces/indexmanagement/GeoIndexUpdaterService/service", "GeoIndexUpdaterService");
	public static final QName factoryname = new QName("http://gcube-system.org/namespaces/indexmanagement/GeoIndexUpdaterFactoryService/service", "GeoIndexUpdaterFactoryService");
	public static final String porttypeNS = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexUpdaterService";
	public static final String porttypeLN = "GeoIndexUpdaterPortType";
	public static final String factoryporttypeNS = "http://gcube-system.org/namespaces/indexmanagement/GeoIndexUpdaterFactoryService";
	public static final String factoryporttypeLN = "GeoIndexUpdaterFactoryPortType";
	
	public static final String gcubeClass = "Index";
	public static final String gcubeName = "GeoIndexUpdater";
	public static final GCoreService<GeoIndexUpdaterStub> giu = service().withName(name)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(GeoIndexUpdaterStub.class);

	public static final GCoreService<GeoIndexUpdaterFactoryStub> giuf = service().withName(factoryname)
            .coordinates(gcubeClass,gcubeName)
                .andInterface(GeoIndexUpdaterFactoryStub.class);

}