package org.gcube.geoindexupdater.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.geoindexupdater.client.library.plugins.GeoIndexUpdaterCLPlugin;
import org.gcube.geoindexupdater.client.library.stubs.GeoIndexUpdaterStub;
import org.gcube.geoindexupdater.client.library.utils.GeoIndexUpdaterCLConstants;

public class GeoIndexUpdaterDSL {
	
	public static final GeoIndexUpdaterCLPlugin giu_plugin = new GeoIndexUpdaterCLPlugin();
	
	
	public static StatefulQuery plugin(final String indexID) {
		
		StatefulQuery query = new StatefulQuery(giu_plugin);
		query.addNamespace("ns1",URI.create(GeoIndexUpdaterCLConstants.NAMESPACE))
		.addCondition("$resource/Data/ns1:IndexID/text() eq '"+indexID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(giu_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<GeoIndexUpdaterCLProxyI> getGeoIndexUpdaterProxyBuilder() {
		return new StatefulBuilderImpl<GeoIndexUpdaterStub,GeoIndexUpdaterCLProxyI>(giu_plugin);
	}
	
}
