package org.gcube.index.fulltextindexnode;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Map.Entry;

import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.indexmanagement.common.IndexType;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.sun.org.apache.bcel.internal.generic.StoreInstruction;

import elasticsearchindex.FullTextNode;

public class Resource extends IndexWSResource {

	
	private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    
    public enum SupportedRelations { adj, fuzzy, proximity, within };
    public static final String EQUALS = "=";
    
    /* Resource properties */
    public static final String RP_CONTENT_TYPE = "ContentType";
    public static final String RP_INDEX_FORMAT = "IndexFormat";
    public static final String RP_SUPPORTED_RELATIONS = "SupportedRelations";
    public static final String RP_CLUSTER_ID = "ClusterID";
    private static final String USE_CLUSTER_ID = "useClusterId";
    private String resourceKey = null;
    
    public String getResourceKey() {
    	return resourceKey;
    }
    
    
    protected static String[] RPNames = { 
    	RP_CONTENT_TYPE,
		RP_INDEX_FORMAT, 
	};
    
	@SuppressWarnings("unchecked")
	@Override
	protected void initialise(Object... args) throws Exception {
		if (args == null) throw new IllegalArgumentException();
		setIsInitializing(true);
		
		GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
		String indexID = (String)args[1];
		String clusterID = (String)args[6];
		logger.info("ClusterID : " + clusterID);
		if(indexID==null || indexID.trim().length()==0) {
        	logger.debug("No indexID given, assigning a new one: " + key.getValue().toString()); 
        	indexID = key.getValue().toString();
        }
		StatefulContext pctx = (StatefulContext) StatefulContext.getContext();
		boolean useClusterID = (Boolean) pctx.getProperty(USE_CLUSTER_ID);
		if(!useClusterID)
			clusterID = ServiceContext.getContext().getScope().toString();
		// if no clusterID given, assign indexID as clusterID
		if(clusterID==null)
			clusterID = indexID;		
	    
		// initializes index
		
		this.resourceKey = key.getValue().toString();
		logger.info("resource key : " + this.resourceKey);
		
		Map<String, Object> result = null;
		try {
			SearchResponse response = FullTextNodeClient.getInstance(clusterID, this.resourceKey).getClient(this.resourceKey).getIndexClient().prepareSearch(FullTextNode.META_INDEX).setQuery(QueryBuilders.matchAllQuery()).execute().actionGet();
			for (SearchHit hit : response.getHits().getHits()) {
				result = hit.getSource();
			}

		} catch (Exception e) {
			logger.warn("No meta-index yet");
		}
		ArrayList<String> collectionIdsToBeAdded;
		ArrayList<String> fieldsToBeAdded;
		if (result != null) {
			collectionIdsToBeAdded = (ArrayList<String>) result.get("collectionIDs");
			fieldsToBeAdded = (ArrayList<String>) result.get("fields");
		} else {
			collectionIdsToBeAdded = new ArrayList<String>();
			fieldsToBeAdded = new ArrayList<String>();
		}
		String[] collectionIds = collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]);
		
		super.initialise(StatefulContext.getContext().getNamespace(), indexID, null, collectionIds);
		// updating fields if necessary
		for (int i=0; i<fieldsToBeAdded.size(); i++)
    		this.getResourcePropertySet().get(RP_FIELDS).add(fieldsToBeAdded.get(i));
		
		// creating supported relations
		ArrayList<String> supportedRelations = new ArrayList<String>();
		for(Resource.SupportedRelations relation : Resource.SupportedRelations.values())
		{
			supportedRelations.add(relation.toString());
		}
		supportedRelations.add(Resource.EQUALS);
		createProperty(RP_SUPPORTED_RELATIONS);
		this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
		
		createProperty(RP_CLUSTER_ID);
		this.getResourcePropertySet().get(RP_CLUSTER_ID).add(clusterID);
		
	    logger.info("Initialized FullTextIndexNode Resource with key:" + key.getValue().toString());
	    
	    
        setIsInitializing(false);
        
        
        //super.store();
		
    }
     
 
    public void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
    	logger.info("Inside onLoad");
    	setIsInitializing(true);
    	
    	super.onLoad(ois, firstLoad);
    	
    	/* Load the values of the resource properties */
		
		this.createProperty(RP_CLUSTER_ID);
		this.getResourcePropertySet().get(RP_CLUSTER_ID).add((String) ois.readObject());
		
//    	this.createProperty(RP_CONTENT_TYPE);
//    	this.createProperty(RP_INDEX_FORMAT);
//    	setContentType((String) ois.readObject());
//    	setIndexFormat((String) ois.readObject());
    	
    	// initialize the node
		
		this.resourceKey = (String)this. getResourcePropertySet().get(IndexWSResource.RP_INDEX_ID).get(0);
		
		logger.info("resource key : " + this.resourceKey);
		
    	FullTextNodeClient.getInstance((String)this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0), this.resourceKey);
    	
    	//add the default virtual presentable fields for each collection and language
    	//we have only the snippet for now
    	String[] fields = this.getFields();
    	HashMap<String, HashSet<String>> defaultPresentFields = new HashMap<String, HashSet<String>>();
    	for(String field : fields) {
    		String[] params = field.split(IndexType.SEPERATOR_FIELD_INFO);
    		String collectionID = params[0];
    		String language = params[1];
    		HashSet<String> langs = defaultPresentFields.get(collectionID);
    		if(langs == null) {
    			langs = new HashSet<String>();
    			defaultPresentFields.put(collectionID, langs);
    		}
    		langs.add(language);
    	}
    	for(Entry<String, HashSet<String>> current : defaultPresentFields.entrySet()) {
    		String collectionID = current.getKey();
    		HashSet<String> langs = current.getValue();
    		for(String lang : langs) {
    			this.addField(collectionID + IndexType.SEPERATOR_FIELD_INFO 
    					+ lang + IndexType.SEPERATOR_FIELD_INFO 
    					+ IndexType.PRESENTABLE_TAG + IndexType.SEPERATOR_FIELD_INFO 
    					+ IndexType.SNIPPET);
    		}
    	}
    	
    	ArrayList<String> supportedRelations = new ArrayList<String>();
		for(Resource.SupportedRelations relation : Resource.SupportedRelations.values())
		{
			supportedRelations.add(relation.toString());
		}
		supportedRelations.add(Resource.EQUALS);
		createProperty(RP_SUPPORTED_RELATIONS);
		this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
    			
 		setIsInitializing(false);
    }
    
    
    
    public void onStore(ObjectOutputStream oos) throws Exception {
    	logger.info("Inside onStore");
    	super.onStore(oos);
    	
    	/* Store the values of the resource properties */
    	oos.writeObject((String) this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0));
    	
//    	oos.writeObject((String) this.getResourcePropertySet().get(RP_CONTENT_TYPE).get(0));
//    	oos.writeObject((String) this.getResourcePropertySet().get(RP_INDEX_FORMAT).get(0));
    }
    
    public synchronized void setSupportedRelations(String[] relations) throws Exception {
    	int size = relations.length;
    	this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
    	for (int i=0; i<size; i++)
    	{
    		logger.info("Adding Supported relation "+relations[i]);
    		this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add(relations[i]);
    	}
    		
    }
    
    public String getClusterID()
    {
    	return this.getResourcePropertySet().get(RP_CLUSTER_ID).toString();
    }
    
}