package org.gcube.index.forwardindexnode;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.couchbase.CouchBaseNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardNodeClient {
	private static final String NO_REPLICAS = "noReplicas";
	private static final String RAMQUOTA = "ramQuota";
	// private static final String NO_SHARDS = "noShards";
	// private static final String ELASTICSEARCH_PORT = "elasticSearchPort";
	private static final String USE_CLUSTER_ID = "useClusterId";
	// private static final String DATA_DIRECTORY = "dataDir";
	private static final String COUCHBASE_SERVER_IP = "couchbaseIP";
	private static final String COUCHBASE_SERVER_PORT = "couchbasePort";
	private static final String COUCHBASE_USERNAME = "couchbaseUsername";
	private static final String COUCHBASE_PASSWORD = "couchbasePassword";

	private static final Integer DEFAULT_PORT = 8091;

	// private static String scope;
	// private static String clusterName;
	// private static String dataDir;

	private CouchBaseNode ftn;

	private static final Logger logger = LoggerFactory
			.getLogger(ForwardNodeClient.class);

	public ForwardNodeClient(String clusterID, boolean isNew)
			throws ResourceRegistryException, InterruptedException {
		{
			try {
				StatefulContext pctx = (StatefulContext) StatefulContext
						.getContext();
				Integer noReplicas = (Integer) pctx.getProperty(NO_REPLICAS);
				Integer ramQuota = (Integer) pctx.getProperty(RAMQUOTA);
				// int noShards = (Integer) pctx.getProperty(NO_SHARDS);
				// int esPort = (Integer) pctx.getProperty(ELASTICSEARCH_PORT);
				boolean useClusterID = (Boolean) pctx
						.getProperty(USE_CLUSTER_ID);
				String couchbaseServerIP = (String) pctx
						.getProperty(COUCHBASE_SERVER_IP);
				String couchbaseServerPort = (String) pctx
						.getProperty(COUCHBASE_SERVER_PORT);

				String couchbaseUsername = (String) pctx
						.getProperty(COUCHBASE_USERNAME);
				String couchbasePassword = (String) pctx
						.getProperty(COUCHBASE_PASSWORD);

				// String dataDirectory = (String)
				// pctx.getProperty(DATA_DIRECTORY);

				logger.info("Data read from jndi");
				logger.info("noReplicas          : " + noReplicas);
				logger.info("ramQuota            : " + ramQuota);
				// logger.info("noShards            : " + noShards);
				logger.info("useClusterID        : " + useClusterID);
				logger.info("couchbaseServerIP   : " + couchbaseServerIP);
				logger.info("couchbaseServerPort : " + couchbaseServerPort);
				logger.info("couchbaseUsername   : " + couchbaseUsername);
				logger.info("couchbasePassword   : " + couchbasePassword);

				// logger.info("dataDirectory  : " + dataDirectory);

				/*
				 * String dataDir = null;
				 * 
				 * if (dataDirectory != null) { dataDir = dataDirectory; } else
				 * { dataDir =
				 * ServiceContext.getContext().getPersistenceRoot().getAbsolutePath
				 * () + "/indexData/elasticsearch/"; }
				 */

				String scope = ServiceContext.getContext().getScope()
						.toString();
				logger.info("Setting index scope to " + scope);

				String clusterName = "couchbase-cluster-service-";
				if (!useClusterID)
					clusterID = scope;

				clusterName += clusterID;

				clusterName = clusterName.replace("/", "_");
				
				String hostname = GHNContext.getContext().getHostname();
				logger.info("hostname :  "+ hostname);

				this.ftn = new CouchBaseNode(hostname, couchbaseServerIP,
						couchbaseServerPort, couchbaseUsername,
						couchbasePassword, clusterName, noReplicas, ramQuota,
						scope);
				HashMap<String, Set<String>> endpoints = ForwardIndexNode
						.discover(ForwardIndexNode.SERVICE_NAME,
								ForwardIndexNode.SERVICE_CLASS,
								Arrays.asList(scope), clusterID);

				logger.info("endpoints discovers : " + endpoints);
				Map<String, String> knownNodes = new HashMap<String, String>();

				for (String key : endpoints.keySet()) {
					knownNodes.put(getIPAddress(extractDomain(key)),
							String.valueOf(DEFAULT_PORT));// TODO: the port
															// should be taken
															// from the generic
															// resource..
				}

				logger.info("knownNodes discovers : " + knownNodes);

				if (knownNodes.size() > 0) {
					this.ftn.joinCluster(knownNodes);
				} else {
					this.ftn.createCluster(isNew);
				}
				// ftn.addMetaIndex();
				// ftn.refreshIndexTypesOfIndex();
			} catch (ResourceRegistryException e) {
				logger.error("Caught Exception", e);
				throw e;
			} catch (InterruptedException e) {
				logger.error("Caught Exception", e);
				throw e;
			} catch (Exception e) {
				logger.error("Caught Exception", e);
			}
		}
	}

	public CouchBaseNode getForwardNode() {
		return this.ftn;
	}

	public String getScope() {
		return this.ftn.getScope();
	}

	public String getClusterName() {
		return this.ftn.getBucketName();
	}

	private static String extractDomain(String endpoint) {
		endpoint = endpoint.substring(endpoint.indexOf("://") + 3);
		endpoint = endpoint.substring(0, endpoint.indexOf(":"));
		return endpoint;
	}

	private static String getIPAddress(String hostname)
			throws UnknownHostException {
		String address = null;
		try {
			address = InetAddress.getByName(hostname).getHostAddress();
		} catch (Exception e) {
			address = hostname;
		}
		return address;
	}

}