/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.index.forwardindexnode;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gcube.common.core.state.GCUBEWSResourceKey;
import org.gcube.couchbase.CouchBaseNode;
import org.gcube.index.forwardindexnode.ForwardNodeClient;
import org.gcube.index.forwardindexnode.ServiceContext;
import org.gcube.index.forwardindexnode.StatefulContext;
import org.gcube.index.forwardindexnode.stubs.KeyDescriptionType;
import org.gcube.indexmanagement.common.IndexWSResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource
extends IndexWSResource {
    private static final Logger logger = LoggerFactory.getLogger(Resource.class);
    public static final String EQUALS = "==";
    public static final String RP_CONTENT_TYPE = "ContentType";
    public static final String RP_INDEX_FORMAT = "IndexFormat";
    public static final String RP_SUPPORTED_RELATIONS = "SupportedRelations";
    public static final String RP_CLUSTER_ID = "ClusterID";
    public static final String RP_KEY_DESCRIPTION = "KeyDescription";
    private static final String USE_CLUSTER_ID = "useClusterId";
    private String resourceKey = null;
    private ForwardNodeClient ftnClient;
    protected static String[] RPNames = new String[]{"ContentType", "IndexFormat"};

    public ForwardNodeClient getForwardNodeClient() {
        return this.ftnClient;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    protected void initialise(Object ... args) throws Exception {
        StatefulContext pctx;
        boolean useClusterID;
        if (args == null) {
            throw new IllegalArgumentException();
        }
        this.setIsInitializing(true);
        GCUBEWSResourceKey key = (GCUBEWSResourceKey)args[0];
        String indexID = (String)args[1];
        String clusterID = (String)args[5];
        KeyDescriptionType[] keyDescription = (KeyDescriptionType[])args[3];
        if (keyDescription != null) {
            for (int i = 0; i < keyDescription.length; ++i) {
                logger.debug(" type-" + keyDescription[i].getIndexTypeID() + " name-" + keyDescription[i].getKeyName());
            }
        }
        String contentType = (String)args[4];
        logger.info("ClusterID : " + clusterID);
        if (indexID == null || indexID.trim().length() == 0) {
            logger.debug("No indexID given, assigning a new one: " + key.getValue().toString());
            indexID = key.getValue().toString();
        }
        if (!(useClusterID = ((Boolean)(pctx = (StatefulContext)StatefulContext.getContext()).getProperty(USE_CLUSTER_ID, new boolean[0])).booleanValue())) {
            clusterID = ServiceContext.getContext().getScope().toString();
        }
        if (clusterID == null) {
            clusterID = indexID;
        }
        this.createProperty(RP_CONTENT_TYPE);
        this.setContentType(contentType);
        this.resourceKey = key.getValue().toString();
        logger.info("resource key : " + this.resourceKey);
        if (this.ftnClient != null) {
            logger.error("ForwardNodeClient already exists in that gHN");
            this.setIsInitializing(false);
            return;
        }
        try {
            this.ftnClient = new ForwardNodeClient(clusterID, true);
        }
        catch (Exception e) {
            logger.error("Error. ForwardNodeClient cannot be created. Check if another client has been created in the same gHN");
            this.setIsInitializing(false);
            return;
        }
        CouchBaseNode forwardNode = this.ftnClient.getForwardNode();
        forwardNode.loadMetaFromDatabase();
        Map<String, String> keys = null;
        boolean newKeys = false;
        if (forwardNode.getMetaIndex().getIndexKeys().size() > 0) {
            logger.info("Found keys in metaindex in the cluster. Will use them instead of given (if given)");
            logger.info("Keys : " + forwardNode.getMetaIndex().getIndexKeys());
            keys = forwardNode.getMetaIndex().getIndexKeys();
        } else {
            keys = new HashMap();
            if (keyDescription != null) {
                for (KeyDescriptionType kdt : keyDescription) {
                    keys.put(kdt.getKeyName(), kdt.getIndexTypeID());
                }
            }
            logger.info("Not found keys in metaindex in the cluster. Will use the given (if given)");
            newKeys = true;
        }
        keyDescription = new KeyDescriptionType[keys.size()];
        int j = 0;
        for (Map.Entry e : keys.entrySet()) {
            keyDescription[j] = new KeyDescriptionType();
            keyDescription[j].setIndexTypeID((String)e.getKey());
            keyDescription[j].setIndexTypeID((String)e.getValue());
            ++j;
        }
        this.createProperty(RP_KEY_DESCRIPTION);
        this.setKeyDescription(keyDescription);
        if (newKeys) {
            logger.info("New keys found. Will commit the meta index");
            this.ftnClient.getForwardNode().addIndexTypes(keys);
            forwardNode.commitMetaIndexToDatabase();
        } else {
            this.ftnClient.getForwardNode().loadKeysFromMetaIndex();
        }
        ArrayList collectionIdsToBeAdded = new ArrayList(forwardNode.getMetaIndex().getCollections());
        ArrayList fieldsToBeAdded = new ArrayList(forwardNode.getMetaIndex().getFields());
        String[] collectionIds = collectionIdsToBeAdded.toArray(new String[collectionIdsToBeAdded.size()]);
        super.initialise(StatefulContext.getContext().getNamespace(), indexID, null, collectionIds);
        for (int i = 0; i < fieldsToBeAdded.size(); ++i) {
            this.getResourcePropertySet().get("Fields").add(fieldsToBeAdded.get(i));
        }
        ArrayList<String> supportedRelations = new ArrayList<String>();
        for (SupportedRelations relation : SupportedRelations.values()) {
            supportedRelations.add(relation.toString());
        }
        supportedRelations.add(EQUALS);
        this.createProperty(RP_SUPPORTED_RELATIONS);
        this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
        this.createProperty(RP_CLUSTER_ID);
        this.getResourcePropertySet().get(RP_CLUSTER_ID).add((Object)clusterID);
        logger.info("Initialized ForwardIndexNode Resource with key:" + key.getValue().toString());
        this.setIsInitializing(false);
    }

    public void onLoad(ObjectInputStream ois, boolean firstLoad) throws Exception {
        CouchBaseNode forwardNode;
        logger.info("Inside onLoad");
        this.setIsInitializing(true);
        super.onLoad(ois, firstLoad);
        this.createProperty(RP_CLUSTER_ID);
        this.getResourcePropertySet().get(RP_CLUSTER_ID).add((Object)((String)ois.readObject()));
        this.createProperty(RP_CONTENT_TYPE);
        String contentType = (String)ois.readObject();
        this.setContentType(contentType);
        Map<String, String> keys = new HashMap<String, String>();
        this.createProperty(RP_KEY_DESCRIPTION);
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            keys.put((String)ois.readObject(), (String)ois.readObject());
        }
        this.resourceKey = (String)this.getResourcePropertySet().get("IndexID").get(0);
        logger.info("resource key : " + this.resourceKey);
        if (this.ftnClient != null) {
            logger.error("ForwardNodeClient already exists in that gHN");
            this.setIsInitializing(false);
            return;
        }
        try {
            this.ftnClient = new ForwardNodeClient((String)this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0), false);
            logger.info("Loading meta from db...");
            forwardNode = this.ftnClient.getForwardNode();
            forwardNode.loadMetaFromDatabase();
            logger.info("Loading meta from db...OK");
        }
        catch (Exception e) {
            logger.error("Error. ForwardNodeClient cannot be created. Check if another client has been created in the same gHN");
            this.setIsInitializing(false);
            return;
        }
        forwardNode = this.ftnClient.getForwardNode();
        forwardNode.loadMetaFromDatabase();
        boolean newKeys = false;
        if (forwardNode.getMetaIndex().getIndexKeys().size() > 0) {
            logger.info("Found keys in metaindex in the cluster. Will use them instead of given (if given)");
            logger.info("Keys : " + forwardNode.getMetaIndex().getIndexKeys());
            keys = forwardNode.getMetaIndex().getIndexKeys();
        } else {
            logger.info("Not found keys in metaindex in the cluster. Will use the given (if given)");
            newKeys = true;
        }
        KeyDescriptionType[] keyDescription = new KeyDescriptionType[keys.size()];
        int j = 0;
        for (Map.Entry e : keys.entrySet()) {
            keyDescription[j] = new KeyDescriptionType();
            keyDescription[j].setIndexTypeID((String)e.getKey());
            keyDescription[j].setIndexTypeID((String)e.getValue());
            ++j;
        }
        this.createProperty(RP_KEY_DESCRIPTION);
        this.setKeyDescription(keyDescription);
        if (newKeys) {
            logger.info("New keys found. Will commit the meta index");
            this.ftnClient.getForwardNode().addIndexTypes(keys);
            forwardNode.commitMetaIndexToDatabase();
        } else {
            this.ftnClient.getForwardNode().loadKeysFromMetaIndex();
        }
        String[] fields = this.getFields();
        HashMap<String, HashSet<String>> defaultPresentFields = new HashMap<String, HashSet<String>>();
        for (String field : fields) {
            String[] params = field.split(":");
            String collectionID = params[0];
            String language = params[1];
            HashSet<String> langs = (HashSet<String>)defaultPresentFields.get(collectionID);
            if (langs == null) {
                langs = new HashSet<String>();
                defaultPresentFields.put(collectionID, langs);
            }
            langs.add(language);
        }
        for (Map.Entry current : defaultPresentFields.entrySet()) {
            String collectionID = (String)current.getKey();
            HashSet langs = (HashSet)current.getValue();
            for (String lang : langs) {
                this.addField(collectionID + ":" + lang + ":" + "p" + ":" + "S");
            }
        }
        Set collectionIdsToBeAdded = forwardNode.getMetaIndex().getCollections();
        Set fieldsToBeAdded = forwardNode.getMetaIndex().getFields();
        this.createProperty("CollectionID");
        this.getResourcePropertySet().get("CollectionID").clear();
        for (String collectionId : collectionIdsToBeAdded) {
            this.getResourcePropertySet().get("CollectionID").add((Object)collectionId);
        }
        this.createProperty("Fields");
        this.getResourcePropertySet().get("Fields").clear();
        for (String field : fieldsToBeAdded) {
            this.getResourcePropertySet().get("Fields").add((Object)field);
        }
        logger.info("adding relations...");
        ArrayList<String> supportedRelations = new ArrayList<String>();
        for (SupportedRelations relation : SupportedRelations.values()) {
            logger.info("adding relation : " + relation.toString());
            supportedRelations.add(relation.toString());
        }
        supportedRelations.add(EQUALS);
        this.createProperty(RP_SUPPORTED_RELATIONS);
        this.setSupportedRelations(supportedRelations.toArray(new String[supportedRelations.size()]));
        super.store();
        this.setIsInitializing(false);
    }

    public void onStore(ObjectOutputStream oos) throws Exception {
        logger.info("Inside onStore");
        super.onStore(oos);
        oos.writeObject((String)this.getResourcePropertySet().get(RP_CLUSTER_ID).get(0));
        oos.writeObject((String)this.getResourcePropertySet().get(RP_CONTENT_TYPE).get(0));
        int size = this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).size();
        oos.writeInt(size);
        for (int i = 0; i < size; ++i) {
            oos.writeObject(((KeyDescriptionType)this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).get(i)).getIndexTypeID());
            oos.writeObject(((KeyDescriptionType)this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).get(i)).getKeyName());
        }
    }

    public synchronized void setSupportedRelations(String[] relations) throws Exception {
        int size = relations.length;
        this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).clear();
        for (int i = 0; i < size; ++i) {
            logger.info("Adding Supported relation " + relations[i]);
            this.getResourcePropertySet().get(RP_SUPPORTED_RELATIONS).add((Object)relations[i]);
        }
    }

    public String getClusterID() {
        return this.getResourcePropertySet().get(RP_CLUSTER_ID).toString();
    }

    public String getContentType() {
        return (String)this.getResourcePropertySet().get(RP_CONTENT_TYPE).get(0);
    }

    public KeyDescriptionType[] getKeyDescription() {
        int size = this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).size();
        KeyDescriptionType[] keyDescription = new KeyDescriptionType[size];
        for (int i = 0; i < size; ++i) {
            keyDescription[i] = (KeyDescriptionType)this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).get(i);
        }
        return keyDescription;
    }

    public synchronized void setKeyDescription(KeyDescriptionType[] keyDescription) {
        if (keyDescription == null) {
            return;
        }
        int size = keyDescription.length;
        this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).clear();
        for (int i = 0; i < size; ++i) {
            this.getResourcePropertySet().get(RP_KEY_DESCRIPTION).add((Object)keyDescription[i]);
        }
    }

    private void setContentType(String contentType) {
        this.getResourcePropertySet().get(RP_CONTENT_TYPE).clear();
        this.getResourcePropertySet().get(RP_CONTENT_TYPE).add((Object)contentType);
    }

    public static enum SupportedRelations {

    }
}

