
if [ $# -lt 1 ]
then
    echo "Usage : $0 HOSTNAME [PORT] [USERNAME] [PASSWORD] [RAMSIZE] [DATA_PATH]";
    exit 0
fi



if [[ -n "$1" ]] 
then
    HOSTNAME=$1
else
    HOSTNAME=`hostname`
fi


#IP_ADDRESS=`dig +short $HOSTNAME` || `host $HOSTNAME | grep address | cut -d ' ' -f 4`
IP_ADDRESS=`host $HOSTNAME | grep address | cut -d ' ' -f 4`

if [[ -n "$2" ]]
then
    PORT=$2
else
    PORT=8091
fi



if [[ -n "$3" ]]
then
    USERNAME=$3
else
    USERNAME="Administrator"
fi

if [[ -n "$4" ]]
then
    PASSWORD=$4
else
    PASSWORD="mycouchbase"
fi

if [[ -n "$5" ]]
then
    RAM_SIZE=$5
else
    RAM_SIZE=512
fi

if [[ -n "$6" ]]
then
    DATA_PATH=$6
else
    DATA_PATH="."
fi

echo "HOSTNAME   : $HOSTNAME"
echo "IP_ADDRESS : $IP_ADDRESS"
echo "PORT       : $PORT"
echo "USERNAME   : $USERNAME"
echo "PASSWORD   : $PASSWORD"
echo "RAM_SIZE   : $RAM_SIZE"
echo "DATA_PATH  : $DATA_PATH"


echo "initializing cluster..."
couchbase-cli cluster-init -c $HOSTNAME:$PORT -u $USERNAME -p $PASSWORD --cluster-init-ramsize=$RAM_SIZE --cluster-init-port=$PORT --node-init-data-path=$DATA_PATH
echo "initializing cluster...OK"
