
if [ $# -lt 1 ]
then
    echo "Usage : $0 BUCKETNAME HOSTNAME [PORT] [USERNAME] [PASSWORD]";
    exit 0
fi


BUCKET_NAME=$1

if [[ -n "$2" ]] 
then
    HOSTNAME=$2
else
    HOSTNAME=`hostname`
fi


#IP_ADDRESS=`dig +short $HOSTNAME` || `host $HOSTNAME | grep address | cut -d ' ' -f 4`
IP_ADDRESS=`host $HOSTNAME | grep address | cut -d ' ' -f 4`

if [[ -n "$3" ]]
then
    PORT=$3
else
    PORT=8091
fi



if [[ -n "$4" ]]
then
    USERNAME=$4
else
    USERNAME="Administrator"
fi

if [[ -n "$5" ]]
then
    PASSWORD=$5
else
    PASSWORD="mycouchbase"
fi

echo "HOSTNAME   : $HOSTNAME"
echo "IP_ADDRESS : $IP_ADDRESS"
echo "PORT       : $PORT"
echo "USERNAME   : $USERNAME"
echo "PASSWORD   : $PASSWORD"
echo "BUCKET     : $BUCKET_NAME"


echo "deleting bucket..."
couchbase-cli bucket-delete -c $IP_ADDRESS:$PORT -u $USERNAME -p $PASSWORD --bucket=$BUCKET_NAME
echo "deleting bucket...OK"

