package org.gcube.forwardindexnode.client.library.proxies;

import org.gcube.forwardindexnode.client.library.beans.Types.GetIndexInformationResponse;
import org.gcube.forwardindexnode.client.library.beans.Types.KeyDescriptionArray;
import org.gcube.forwardindexnode.client.library.exceptions.ForwardIndexNodeException;


public interface ForwardIndexNodeCLProxyI {
	
public Boolean feedLocator(final String feedLocator) throws ForwardIndexNodeException;
	
	public String query(final String query) throws ForwardIndexNodeException;
	
	public boolean shutdown(final String shutdown) throws ForwardIndexNodeException;
	
	public boolean deleteCollection(final String collectionID) throws ForwardIndexNodeException;

	public boolean destroyNode() throws ForwardIndexNodeException;

	public boolean refresh() throws ForwardIndexNodeException;
	
	public boolean rebuildMetaIndex() throws ForwardIndexNodeException;
	
	public GetIndexInformationResponse getIndexInformation() throws ForwardIndexNodeException;
	
	public boolean setCollections(final String[] collections) throws ForwardIndexNodeException;
	
	public boolean setFields(final String[] fields) throws ForwardIndexNodeException;
	
	public boolean addKeyDescription(final KeyDescriptionArray keyDescriptionArray) throws ForwardIndexNodeException;
	
	public boolean setKeyDescription(final KeyDescriptionArray keyDescriptionArray) throws ForwardIndexNodeException;
	
	public void destroy() throws ForwardIndexNodeException;
	
}
