package org.gcube.forwardindexnode.client.library.proxies;

import java.net.URI;

import org.gcube.common.clients.fw.builders.StatefulBuilder;
import org.gcube.common.clients.fw.builders.StatefulBuilderImpl;
import org.gcube.common.clients.fw.queries.StatefulQuery;
import org.gcube.forwardindexnode.client.library.plugins.ForwardIndexNodeCLPlugin;
import org.gcube.forwardindexnode.client.library.stubs.ForwardIndexNodeStub;
import org.gcube.forwardindexnode.client.library.utils.ForwardIndexNodeCLConstants;

public class ForwardIndexNodeDSL {
	
	public static final ForwardIndexNodeCLPlugin fin_plugin = new ForwardIndexNodeCLPlugin();
	
	
	public static StatefulQuery plugin(final String indexID) {
		
		StatefulQuery query = new StatefulQuery(fin_plugin);
		query.addNamespace("ns1",URI.create(ForwardIndexNodeCLConstants.NAMESPACE))
		.addCondition("$resource/Data/ns1:IndexID/text() eq '"+indexID+"'");
		return query;
	}
	
	public static SourceQueryBuilder getSource() {

		StatefulQuery query = new StatefulQuery(fin_plugin);
		return new SourceQueryBuilder(query);
		
	}
	
	public static StatefulBuilder<ForwardIndexNodeCLProxyI> getForwardIndexNodeProxyBuilder() {
		return new StatefulBuilderImpl<ForwardIndexNodeStub,ForwardIndexNodeCLProxyI>(fin_plugin);
	}
	
}
