/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.events.KeyValueEvent;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.carrot2.elasticsearch.ClusteringAction;
import org.carrot2.elasticsearch.DocumentGroup;
import org.carrot2.elasticsearch.ListAlgorithmsAction;
import org.carrot2.elasticsearch.LogicalField;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.client.Client;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.search.SearchHit;
import org.gcube.elasticsearch.FTNodeCache;
import org.gcube.elasticsearch.FullTextNode;
import org.gcube.elasticsearch.entities.ClusterResponse;
import org.gcube.elasticsearch.helpers.ElasticSearchHelper;
import org.gcube.elasticsearch.helpers.QueryParser;
import org.gcube.elasticsearch.parser.ElasticSearchParser;
import org.gcube.indexmanagement.common.IndexException;
import org.gcube.indexmanagement.resourceregistry.RRadaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullTextNodeHelpers
implements Serializable {
    private static final long serialVersionUID = 1L;
    static final Logger logger = LoggerFactory.getLogger(FullTextNodeHelpers.class);
    private static final long RSTIMEOUT = 30L;

    public static String query(Client indexClient, String queryString, Integer from, Integer maxHits, Set<String> securityIdentifiers, FTNodeCache cache, Integer defaultMaxResults, final Integer maxFragmentCnt, Integer maxFragmentSize, RRadaptor rradaptor, String indexName, ExecutorService executorService) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("securityIdentifiers  : " + securityIdentifiers);
        logger.info("maxHits              : " + maxHits);
        final long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        long starttime_part_t = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(queryString, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        long endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to create the ElasticSearchParser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        ArrayList<String> projections = parsedQueryContainer.getProjects();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> projections : " + projections);
        logger.info(" ~> time to get the projections from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        QueryBuilder qb = parsedQueryContainer.parse();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> query builder : " + qb);
        logger.info(" ~> time to parse the query in the parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("query after parse : " + qb.toString());
        starttime_part_t = System.currentTimeMillis();
        ArrayList<AbstractMap.SimpleEntry<String, String>> sortBys = parsedQueryContainer.getSortBys();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> sortbys : " + sortBys);
        logger.info(" ~> time to get the sortbys from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        final boolean distinct = parsedQueryContainer.getDistincts().size() > 0;
        logger.info(" ~> distinct : " + distinct);
        logger.info(" ~> time to get distinct from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        Set<String> collIDs = parsedQueryContainer.getCollections();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the collection from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("collectionID of query : " + collIDs);
        starttime_part_t = System.currentTimeMillis();
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(cache.indexTypesByCollIDs, collIDs, indexClient, indexName);
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the indexTypes from cache : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + cache);
        logger.info("cache indextypes    by coll id    : " + cache.indexTypesByCollIDs);
        logger.info("cache presentables    by idx type : " + cache.presentableFieldsPerIndexType);
        logger.info("cache searchables     by idx type : " + cache.searchableFieldsPerIndexType);
        logger.info("cache highlightables  by idx type : " + cache.highlightableFieldsPerIndexType);
        List<String> presentables = QueryParser.createPresentableForIndexTypes(cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        List<String> highlightables = QueryParser.createHighlightablesForIndexTypes(cache.highlightableFieldsPerIndexType, indexTypes);
        logger.info("highlightables for index types : " + highlightables);
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        if (projectedFields.contains("ObjectID")) {
            projectedFields.remove("ObjectID");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        if (maxHits < 0 && defaultMaxResults != null) {
            logger.trace("max results for query not given. will use global maxResults : " + defaultMaxResults);
            maxHits = defaultMaxResults;
        } else if (maxHits > 0 && defaultMaxResults != null) {
            logger.trace("max results for query given." + maxHits + " global maxResults : " + defaultMaxResults);
            maxHits = Math.min(maxHits, defaultMaxResults);
        }
        starttime_part = System.currentTimeMillis();
        final SearchHit[] hits = projections.contains("S") ? ElasticSearchHelper.queryElasticSearch(indexClient, indexName, qb, maxHits, highlightables, projectedFields, maxFragmentSize, maxFragmentCnt, from, sortBys) : ElasticSearchHelper.queryElasticSearch(indexClient, indexName, qb, maxHits, from, projectedFields, sortBys);
        endtime_part = System.currentTimeMillis();
        logger.info("elasticsearch query time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        logger.info("Number of hits returned by index : " + hits.length);
        System.out.println("Number of hits returned by index : " + hits.length);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + hits.length);
        final List<String> returnFields = projections.contains("*") ? presentables : projections;
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(returnFields, rradaptor);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(hits.length)));
        final HashSet recHashes = new HashSet();
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    for (SearchHit hit : hits) {
                        if (distinct) {
                            int recHash = hit.getSourceAsString().hashCode();
                            if (recHashes.contains(recHash)) {
                                logger.info("duplicate found. skipping..");
                                continue;
                            }
                            recHashes.add(hit.getSourceAsString().hashCode());
                        }
                        if (!QueryParser.writeSearchHitInResultSet(hit, (RecordWriter<GenericRecord>)rsWriter, returnFields, maxFragmentCnt, 30L)) break;
                    }
                    if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                        rsWriter.close();
                    }
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
                logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
            }
        };
        executorService.execute(writerRun);
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    public static String queryStream(final Client indexClient, String queryString, Integer maxHits, FTNodeCache cache, Set<String> securityIdentifiers, Integer defaultMaxResults, final Integer maxFragmentCnt, final Integer maxFragmentSize, RRadaptor rradaptor, final String indexName, ExecutorService executorService) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("maxHits              : " + maxHits);
        final long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(queryString, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        final ArrayList<String> projections = parsedQueryContainer.getProjects();
        final QueryBuilder qb = parsedQueryContainer.parse();
        logger.info("query after parse : " + qb.toString());
        final ArrayList<AbstractMap.SimpleEntry<String, String>> sortBys = parsedQueryContainer.getSortBys();
        boolean distinct = parsedQueryContainer.getDistincts().size() > 0;
        Set<String> collIDs = parsedQueryContainer.getCollections();
        logger.info("collectionID of query : " + collIDs);
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(cache.indexTypesByCollIDs, collIDs, indexClient, indexName);
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + cache);
        logger.info("cache indextypes    by coll id    : " + cache.indexTypesByCollIDs);
        logger.info("cache presentables    by idx type : " + cache.presentableFieldsPerIndexType);
        logger.info("cache searchables     by idx type : " + cache.searchableFieldsPerIndexType);
        logger.info("cache highlightables  by idx type : " + cache.highlightableFieldsPerIndexType);
        List<String> presentables = QueryParser.createPresentableForIndexTypes(cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        final List<String> highlightables = QueryParser.createHighlightablesForIndexTypes(cache.highlightableFieldsPerIndexType, indexTypes);
        logger.info("highlightables for index types : " + highlightables);
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        if (maxHits < 0 && defaultMaxResults != null) {
            logger.trace("max results for query not given. will use global maxResults : " + defaultMaxResults);
            maxHits = defaultMaxResults;
        } else if (maxHits > 0 && defaultMaxResults != null) {
            logger.trace("max results for query given." + maxHits + " global maxResults : " + defaultMaxResults);
            maxHits = Math.min(maxHits, defaultMaxResults);
        }
        long numberOfHits = ElasticSearchHelper.queryCountElasticSearch(indexClient, indexName, qb);
        if (maxHits > 0 && numberOfHits > (long)maxHits.intValue()) {
            numberOfHits = maxHits.intValue();
        }
        logger.info("Number of hits returned by index : " + numberOfHits);
        final List<String> returnFields = projections.contains("*") ? presentables : projections;
        final RecordWriter<GenericRecord> rsWriter = QueryParser.initRSWriterForSearchHits(returnFields, rradaptor);
        logger.info("emitting key value event with key : resultsNumberFinal and value : " + numberOfHits);
        rsWriter.emit((BufferEvent)new KeyValueEvent("resultsNumberFinal", String.valueOf(numberOfHits)));
        final List<String> projectedFieldsList = projectedFields;
        final int fHits = maxHits;
        Runnable writerRun = new Runnable(){

            @Override
            public void run() {
                try {
                    SearchResponse scrollResp = projections.contains("S") ? ElasticSearchHelper.queryElasticSearchScroll(indexClient, indexName, qb, fHits, highlightables, projectedFieldsList, maxFragmentSize, maxFragmentCnt, sortBys) : ElasticSearchHelper.queryElasticSearchScroll(indexClient, indexName, qb, fHits, projectedFieldsList, sortBys);
                    int hits = 0;
                    do {
                        SearchHit hit;
                        scrollResp = ElasticSearchHelper.getNextSearchResponse(indexClient, scrollResp);
                        logger.info("hits from scroll : " + scrollResp.getHits().getHits().length);
                        Iterator i$ = scrollResp.getHits().iterator();
                        while (i$.hasNext() && QueryParser.writeSearchHitInResultSet(hit = (SearchHit)i$.next(), (RecordWriter<GenericRecord>)rsWriter, returnFields, maxFragmentCnt, 30L)) {
                        }
                        if (rsWriter.getStatus() == IBuffer.Status.Dispose) continue;
                        rsWriter.close();
                    } while (scrollResp.getHits().getHits().length != 0 && ++hits <= fHits);
                }
                catch (Exception e) {
                    logger.error("Error during search.", (Throwable)e);
                    try {
                        if (rsWriter.getStatus() != IBuffer.Status.Dispose) {
                            rsWriter.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error("Error while closing RS writer.", (Throwable)ex);
                    }
                }
                logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
            }
        };
        executorService.execute(writerRun);
        logger.info("results locator : " + rsWriter.getLocator());
        return rsWriter.getLocator().toString();
    }

    private static Set<String> filterSecurityIdentifiers(Set<String> sids) {
        if (sids == null) {
            return Sets.newHashSet();
        }
        Predicate<String> predicate = new Predicate<String>(){

            public boolean apply(String input) {
                boolean ret = !Strings.isNullOrEmpty((String)input);
                return ret;
            }
        };
        return Sets.newHashSet((Iterable)Iterables.filter(sids, (Predicate)predicate));
    }

    public static Map<String, Integer> frequentTerms(Client indexClient, String queryString, Integer maxTerms, Set<String> securityIdentifiers, FTNodeCache cache, RRadaptor rradaptor, String indexName) throws GRS2WriterException, IndexException {
        logger.info("queryString received : " + queryString);
        logger.info("securityIdentifiers  : " + securityIdentifiers);
        logger.info("maxTerms             : " + maxTerms);
        long starttime = System.currentTimeMillis();
        long starttime_part = System.currentTimeMillis();
        long starttime_part_t = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(queryString, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        long endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to create the ElasticSearchParser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        ArrayList<String> projections = parsedQueryContainer.getProjects();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> projections : " + projections);
        logger.info(" ~> time to get the projections from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        QueryBuilder qb = parsedQueryContainer.parse();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> query builder : " + qb);
        logger.info(" ~> time to parse the query in the parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("query after parse : " + qb.toString());
        starttime_part_t = System.currentTimeMillis();
        ArrayList<AbstractMap.SimpleEntry<String, String>> sortBys = parsedQueryContainer.getSortBys();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> sortbys : " + sortBys);
        logger.info(" ~> time to get the sortbys from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        boolean distinct = parsedQueryContainer.getDistincts().size() > 0;
        logger.info(" ~> distinct : " + distinct);
        logger.info(" ~> time to get distinct from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        Set<String> collIDs = parsedQueryContainer.getCollections();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the collection from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("collectionID of query : " + collIDs);
        starttime_part_t = System.currentTimeMillis();
        Set<String> indexTypes = QueryParser.getIndexTypesByCollectionIDs(cache.indexTypesByCollIDs, collIDs, indexClient, indexName);
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to get the indexTypes from cache : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        logger.info("indexTypes for collectionIDs : " + indexTypes);
        logger.info("cache : " + cache);
        logger.info("cache indextypes    by coll id    : " + cache.indexTypesByCollIDs);
        logger.info("cache presentables    by idx type : " + cache.presentableFieldsPerIndexType);
        logger.info("cache searchables     by idx type : " + cache.searchableFieldsPerIndexType);
        logger.info("cache highlightables  by idx type : " + cache.highlightableFieldsPerIndexType);
        List<String> presentables = QueryParser.createPresentableForIndexTypes(cache.presentableFieldsPerIndexType, indexTypes);
        logger.info("presentables for index types : " + presentables);
        List<String> searchables = QueryParser.createSearchablesForIndexTypes(cache.searchableFieldsPerIndexType, indexTypes);
        logger.info("searchables for index types : " + searchables);
        List<String> highlightables = QueryParser.createHighlightablesForIndexTypes(cache.highlightableFieldsPerIndexType, indexTypes);
        logger.info("highlightables for index types : " + highlightables);
        List<String> projectedFields = new ArrayList<String>(projections);
        if (projectedFields.contains("*")) {
            projectedFields = presentables;
        }
        if (projectedFields.contains("S")) {
            projectedFields.remove("S");
        }
        if (projectedFields.contains("ObjectID")) {
            projectedFields.remove("ObjectID");
        }
        long endtime_part = System.currentTimeMillis();
        logger.info("parsing time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        starttime_part = System.currentTimeMillis();
        Map<String, Integer> hits = ElasticSearchHelper.termsFacetElasticSearch(indexClient, indexName, qb, maxTerms, projectedFields);
        endtime_part = System.currentTimeMillis();
        logger.info("elasticsearch query time : " + (double)(endtime_part - starttime_part) / 1000.0 + " secs");
        logger.info("Number of hits returned by index : " + hits.size());
        logger.info("total query time : " + (double)(System.currentTimeMillis() - starttime) / 1000.0 + " secs");
        return hits;
    }

    public static List<ClusterResponse> clustering(Client indexClient, String query, String queryHint, Integer clustersCount, String urlField, List<String> titleFields, List<String> contentFields, List<String> languageFields, RRadaptor rradaptor, Set<String> securityIdentifiers, String algorithm, Integer searchHits) {
        HashMap<String, LogicalField> fieldsMap = new HashMap<String, LogicalField>();
        fieldsMap.put(urlField, LogicalField.URL);
        if (titleFields != null && titleFields.size() > 0) {
            for (String field : titleFields) {
                fieldsMap.put(field, LogicalField.TITLE);
            }
        }
        if (contentFields != null && contentFields.size() > 0) {
            for (String field : contentFields) {
                fieldsMap.put(field, LogicalField.CONTENT);
            }
        }
        if (languageFields != null && languageFields.size() > 0) {
            for (String field : languageFields) {
                fieldsMap.put(field, LogicalField.LANGUAGE);
            }
        }
        if (searchHits == null) {
            searchHits = clustersCount * 50;
        }
        ListAlgorithmsAction.ListAlgorithmsActionResponse ral = (ListAlgorithmsAction.ListAlgorithmsActionResponse)ListAlgorithmsAction.INSTANCE.newRequestBuilder(indexClient).get();
        logger.info("algorithms : " + ral.getAlgorithms());
        if (!ral.getAlgorithms().contains(algorithm)) {
            throw new IllegalArgumentException("algorithm : " + algorithm + " not in : " + ral.getAlgorithms());
        }
        long starttime_part_t = System.currentTimeMillis();
        ElasticSearchParser parsedQueryContainer = new ElasticSearchParser(query, rradaptor, FullTextNodeHelpers.filterSecurityIdentifiers(securityIdentifiers));
        long endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> time to create the ElasticSearchParser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        ArrayList<String> projections = parsedQueryContainer.getProjects();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> projections : " + projections);
        logger.info(" ~> time to get the projections from parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        starttime_part_t = System.currentTimeMillis();
        QueryBuilder qb = parsedQueryContainer.parse();
        endtime_part_t = System.currentTimeMillis();
        logger.info(" ~> query builder : " + qb);
        logger.info(" ~> time to parse the query in the parser : " + (double)(endtime_part_t - starttime_part_t) / 1000.0 + " secs");
        SearchRequestBuilder srb = indexClient.prepareSearch(new String[]{FullTextNode.ACTIVE_INDEX}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setSize(searchHits.intValue()).setQuery(qb);
        for (String field : fieldsMap.keySet()) {
            srb = srb.addField(field);
        }
        logger.info("search request : " + srb.toString());
        ClusteringAction.ClusteringActionRequestBuilder ca = ClusteringAction.INSTANCE.newRequestBuilder(indexClient).setAlgorithm(algorithm).setQueryHint(queryHint).setMaxHits(0).setSearchRequest(srb.request()).addAttribute("LingoClusteringAlgorithm.desiredClusterCountBase", (Object)clustersCount);
        for (Map.Entry e : fieldsMap.entrySet()) {
            ca = ca.addFieldMapping((String)e.getKey(), (LogicalField)e.getValue());
        }
        logger.info("clustering request : " + ca.toString());
        ClusteringAction.ClusteringActionResponse car = (ClusteringAction.ClusteringActionResponse)ca.get();
        logger.info("clustering response : " + car.toString());
        DocumentGroup[] groups = car.getDocumentGroups();
        logger.info("number of clusters found : " + groups.length);
        ArrayList response = Lists.newArrayList();
        ArrayList allFields = Lists.newArrayList(titleFields);
        allFields.addAll(contentFields);
        for (DocumentGroup group : groups) {
            logger.info("cluster name : " + group.getLabel() + ", score : " + group.getScore());
            Double score = group.getScore();
            String clusterName = group.getLabel();
            List<MultiGetItemResponse> documents = ElasticSearchHelper.getMultipleDocumentsOfAlias(indexClient, FullTextNode.ACTIVE_INDEX, Arrays.asList(group.getDocumentReferences()));
            ArrayList docs = Lists.newArrayListWithCapacity((int)documents.size());
            logger.info("cluster contains " + documents.size() + " documents");
            for (MultiGetItemResponse mgir : documents) {
                logger.info("\t" + mgir.getResponse().getSourceAsString());
                String doc = FullTextNodeHelpers.extractValues(allFields, mgir.getResponse().getSource());
                docs.add(doc);
            }
            response.add(new ClusterResponse(clusterName, score, docs));
        }
        return response;
    }

    public static String extractValues(List<String> fields, Map<String, Object> map) {
        ArrayList values = Lists.newArrayList();
        for (String field : fields) {
            if (!map.containsKey(field)) continue;
            values.add(map.get(field).toString());
        }
        return Joiner.on((String)", ").join((Iterable)values);
    }

    public static void main(String[] args) {
        HashSet mysids = null;
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet();
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet((Object[])new String[]{""});
        mysids.add("sid1");
        mysids.add("");
        mysids.add("sid2");
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
        mysids = Sets.newHashSet((Object[])new String[]{"", ""});
        System.out.println(FullTextNodeHelpers.filterSecurityIdentifiers(mysids));
    }
}

