/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.elasticsearch.helpers;

import edu.emory.mathcs.backport.java.util.Collections;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetsHelper {
    private static final Logger logger = LoggerFactory.getLogger(SnippetsHelper.class);
    private static final SnippetsComparator snippetsComparator = new SnippetsComparator();
    private static final String SNIPPET_TOKEN = "...";

    public static String createSnippetString(SearchHit hit, int maxSnippetCount) {
        int snippetsCnt = 0;
        ArrayList<String> snippets = new ArrayList<String>();
        logger.info("Creating snippets for hit : " + hit);
        for (Map.Entry snippet : hit.getHighlightFields().entrySet()) {
            if (snippet.getValue() == null || ((HighlightField)snippet.getValue()).getFragments() == null) continue;
            for (Text text : ((HighlightField)snippet.getValue()).getFragments()) {
                snippets.add(text.string());
            }
        }
        logger.info("snippets found : " + snippets);
        Collections.sort(snippets, (Comparator)snippetsComparator);
        StringBuilder strb = new StringBuilder();
        for (String s : snippets) {
            strb.append(s);
            strb.append(SNIPPET_TOKEN);
            if (++snippetsCnt < maxSnippetCount) continue;
            return strb.toString();
        }
        logger.info("snippets string : " + strb.toString());
        return strb.toString();
    }

    private static class SnippetsComparator
    implements Comparator<String> {
        private SnippetsComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            return o1.length() - o2.length();
        }
    }
}

