package org.gcube.couchbase.helpers;

import java.util.Comparator;
import java.util.Map;

import org.gcube.couchbase.helpers.CouchBaseDataTypesHelper.DataType;

public class RecordComparator implements Comparator<Map<String, String>>{

	String key = null;
	DataType datatype = null;
	
	public RecordComparator(String key, DataType datatype) {
		this.key = key;
		this.datatype = datatype;
	}
	
	@Override
	public int compare(Map<String, String> o1, Map<String, String> o2) {
		if (o1 == null && o2 == null)
			return 0;
		if (o1 != null && o2 == null)
			return 1;
		if (o1 == null && o2 != null)
			return -1;
		
		if (o1.get(key) == null && o2.get(key) == null)
			return 0;
		
		if (o1.get(key) != null && o2.get(key) == null)
			return 1;
		
		if (o1.get(key) == null && o2.get(key) != null)
			return -1;
		
		if (this.datatype == null) {
			String obj1 = String.valueOf(o1.get(key));
			String obj2 = String.valueOf(o2.get(key));
				
			return obj1.compareTo(obj2);
		}
		if (this.datatype.equals(DataType.INTEGER)) {
			Integer obj1 = Integer.valueOf(o1.get(key));
			Integer obj2 = Integer.valueOf(o2.get(key));
			
			return obj1.compareTo(obj2);
		} 
		if (this.datatype.equals(DataType.DATE)) {
			Long obj1 = Long.valueOf(o1.get(key));
			Long obj2 = Long.valueOf(o2.get(key));
			
			return obj1.compareTo(obj2);
		}
		
		if (this.datatype.equals(DataType.FLOAT)) {
			Float obj1 = Float.valueOf(o1.get(key));
			Float obj2 = Float.valueOf(o2.get(key));
			
			return obj1.compareTo(obj2);
		}
		
		String obj1 = String.valueOf(o1.get(key));
		String obj2 = String.valueOf(o2.get(key));
			
		return obj1.compareTo(obj2);
		
	}

}
