/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import org.gcube.service.idm.controller.AuthController;
import org.gcube.service.idm.controller.JWTController;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.service.utils.beans.ResponseBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="jwt")
public class JwtAPI {
    private static final Logger logger = LoggerFactory.getLogger(JwtAPI.class);

    @GET
    @Path(value="/decode")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="decode the token"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getDecodedJwtToken(@QueryParam(value="token") String token) {
        ResponseBean responseBean = new ResponseBean();
        try {
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            Map decoded = JWTController.decodeJwtToken((String)token);
            responseBean.setResult((Object)decoded);
            responseBean.setSuccess(true);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="/auth")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="The user's email is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getDecodedJwtAuth() {
        ResponseBean responseBean = new ResponseBean();
        String token = AuthController.getAccessToken();
        try {
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            HashMap<String, Map> response = new HashMap<String, Map>();
            response.put("auth_token", JWTController.decodeJwtToken((String)token));
            responseBean.setResult(response);
            responseBean.setSuccess(true);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

