/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.webcohesion.enunciate.metadata.rs.RequestHeader;
import com.webcohesion.enunciate.metadata.rs.RequestHeaders;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.controller.AdminKeycloakController;
import org.gcube.service.idm.controller.AuthController;
import org.gcube.service.idm.controller.KCClientsController;
import org.gcube.service.idm.controller.KCGroupsController;
import org.gcube.service.idm.controller.KCRolesController;
import org.gcube.service.idm.controller.KCUserController;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.gcube.service.idm.rest.ClientsAPI;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.service.utils.beans.ResponseBean;
import org.gcube.service.utils.beans.ResponseBeanMap;
import org.gcube.smartgears.annotations.ManagedBy;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=IdMManager.class)
@RequestHeaders(value={@RequestHeader(name="Authorization", description="Bearer token, see https://dev.d4science.org/how-to-access-resources"), @RequestHeader(name="Content-Type", description="application/json")})
@Path(value="clients")
public class ClientsAPI {
    private static final Logger logger = LoggerFactory.getLogger(ClientsAPI.class);

    @GET
    @Path(value="members")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response clientMembers(@QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format_users") @DefaultValue(value="username") KCUserController.REPR format_users, @QueryParam(value="role") @DefaultValue(value="Member") String role_name, @QueryParam(value="client_id") String clientId) {
        ResponseBean responseBean = new ResponseBean();
        if (clientId != null) {
            AuthController.checkIsRealmAdmin((String)"The parameter can be used only by realm administrators: client_id");
        }
        List user_members = KCClientsController.getContextUsersByRole((String)clientId, (String)role_name, (Integer)firstResult, (Integer)maxResults);
        Object result = KCUserController.formatList((List)user_members, (KCUserController.REPR)format_users);
        responseBean.setResult(result);
        try {
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="users")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response clientUsers(@QueryParam(value="first") @DefaultValue(value="0") int firstResult, @QueryParam(value="max") @DefaultValue(value="100") int maxResults, @QueryParam(value="format_users") @DefaultValue(value="username") KCUserController.REPR format_users, @QueryParam(value="client_id") String clientId) {
        ResponseBean responseBean = new ResponseBean();
        if (clientId != null) {
            AuthController.checkIsRealmAdmin((String)"The parameter can be used only by realm administrators: client_id");
        }
        List user_members = KCClientsController.getMemberGroupUsers((String)clientId, (Integer)firstResult, (Integer)maxResults);
        Object result = KCUserController.formatList((List)user_members, (KCUserController.REPR)format_users);
        responseBean.setResult(result);
        try {
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @GET
    @Path(value="info")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response client(@QueryParam(value="format_client") @DefaultValue(value="compact") KCClientsController.REPR format_client, @QueryParam(value="format_users") @DefaultValue(value="username") KCUserController.REPR format_users, @QueryParam(value="format_roles") @DefaultValue(value="compact") KCRolesController.REPR format_roles, @QueryParam(value="format_groups") @DefaultValue(value="name") KCGroupsController.REPR format_group, @QueryParam(value="role") @DefaultValue(value="Member") List<String> roles, @QueryParam(value="client_id") String clientId) {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        if (clientId != null) {
            AuthController.checkIsRealmAdmin((String)"The parameter can be used only by realm administrators: client_id");
        }
        boolean show_groups = !format_group.equals((Object)KCGroupsController.REPR.none);
        boolean show_client = !format_client.equals((Object)KCClientsController.REPR.none);
        boolean show_users = !format_users.equals((Object)KCUserController.REPR.none);
        boolean show_roles = !format_roles.equals((Object)KCRolesController.REPR.none);
        RealmResource realmResource = KkClientFactory.getSingleton().getKKRealm();
        ClientResource clientResource = null;
        ClientRepresentation client = null;
        if (clientId == null) {
            clientResource = KkClientFactory.getSingleton().getKKClient();
            client = clientResource.toRepresentation();
        } else {
            List clients = realmResource.clients().findByClientId(clientId);
            if (clients.size() == 0) {
                throw new NotFoundException();
            }
            String id = ((ClientRepresentation)clients.get(0)).getId();
            clientResource = realmResource.clients().get(id);
            client = clientResource.toRepresentation();
        }
        if (show_client) {
            responseBean.putResult("client", KCClientsController.formatRepr((ClientRepresentation)client, (KCClientsController.REPR)format_client));
        }
        if (format_client.equals((Object)KCClientsController.REPR.full)) {
            UserRepresentation service_account_user = clientResource.getServiceAccountUser();
            responseBean.putResult("service_account_user", KCUserController.formatRepr((UserRepresentation)service_account_user, (KCUserController.REPR)format_users));
        }
        HashMap roles_dict = new HashMap();
        responseBean.putResult("roles", roles_dict);
        RolesResource roles_resource = clientResource.roles();
        ArrayList<RoleRepresentation> roles_list = null;
        if (roles == null || roles.isEmpty() || roles.contains("__all__")) {
            roles_list = roles_resource.list();
        } else {
            roles_list = new ArrayList<RoleRepresentation>();
            for (String role_name : roles) {
                try {
                    RoleResource role_resource = roles_resource.get(role_name);
                    RoleRepresentation role_repr = role_resource.toRepresentation();
                    roles_list.add(role_repr);
                }
                catch (Exception exception) {
                    roles_dict.put(role_name, null);
                }
            }
        }
        for (RoleRepresentation role_repr : roles_list) {
            String role_name = role_repr.getName();
            RoleResource role_resource = roles_resource.get(role_name);
            HashMap<String, Object> role_dict = new HashMap<String, Object>();
            roles_dict.put(role_name, role_dict);
            if (show_roles) {
                role_dict.put("role", KCRolesController.formatRepr((RoleRepresentation)role_repr, (KCRolesController.REPR)format_roles));
            }
            if (show_users) {
                List user_members = role_resource.getUserMembers();
                role_dict.put("members", KCUserController.formatList((List)user_members, (KCUserController.REPR)format_users));
            }
            if (!show_groups) continue;
            HashMap groups_hash = new HashMap();
            role_dict.put("groups", groups_hash);
            Set groups_members = clientResource.roles().get(role_name).getRoleGroupMembers();
            for (GroupRepresentation g_repr : groups_members) {
                HashMap<String, Object> group_dict = new HashMap<String, Object>();
                groups_hash.put(g_repr.getPath(), group_dict);
                group_dict.put("group", KCGroupsController.formatRepr((GroupRepresentation)g_repr, (KCGroupsController.REPR)format_group));
                if (!show_users) continue;
                GroupResource g = realmResource.groups().group(g_repr.getId());
                List members = g.members();
                group_dict.put("members", KCUserController.formatList((List)members, (KCUserController.REPR)format_users));
            }
        }
        try {
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @POST
    @Path(value="fromTemplate/{name}")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response createClientFromTemplate(@PathParam(value="name") String template_name, ClientFromTemplateParams params) {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        try {
            RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
            List clients = realm.clients().findByClientId(template_name);
            if (clients.size() == 0) {
                throw new NotFoundException();
            }
            String id = ((ClientRepresentation)clients.get(0)).getId();
            ClientResource clientResource = realm.clients().get(id);
            ClientRepresentation client = clientResource.toRepresentation();
            UserRepresentation template_account_user = clientResource.getServiceAccountUser();
            client.setId(params.client_id);
            client.setName(params.client_name);
            responseBean.putResult("client", (Object)client);
            responseBean.putResult("service_account_user", (Object)template_account_user);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response createClientFromTemplate(ClientRepresentation client) {
        logger.info("received client {}", (Object)client);
        ResponseBeanMap responseBean = new ResponseBeanMap();
        try {
            logger.info("received client {}", (Object)client);
            ClientRepresentation newClient = AdminKeycloakController.createClient((ClientRepresentation)client);
            responseBean.putResult("input", (Object)client);
            responseBean.putResult("created", (Object)newClient);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    @POST
    @Path(value="/")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response createClient(ClientRepresentation client) {
        ResponseBeanMap responseBean = new ResponseBeanMap();
        try {
            logger.info("received client {}", (Object)client);
            ClientRepresentation newClient = AdminKeycloakController.createClient((ClientRepresentation)client);
            responseBean.putResult("input", (Object)client);
            responseBean.putResult("created", (Object)newClient);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            throw new InternalServerErrorException((Throwable)e);
        }
    }
}

