/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.controller;

import jakarta.ws.rs.NotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gcube.service.idm.controller.KCClientsController;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.GroupResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KCClientsController {
    private static final Logger logger = LoggerFactory.getLogger(KCClientsController.class);

    public static Object formatRepr(ClientRepresentation client, REPR format) {
        if (client == null || format.equals((Object)REPR.none)) {
            return null;
        }
        if (format.equals((Object)REPR.name)) {
            return client.getName();
        }
        if (format.equals((Object)REPR.id)) {
            return client.getId();
        }
        if (format.equals((Object)REPR.client_id)) {
            return client.getClientId();
        }
        if (format.equals((Object)REPR.compact)) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("id", client.getId());
            result.put("clientId", client.getClientId());
            result.put("name", client.getName());
            result.put("description", client.getDescription());
            return result;
        }
        return client;
    }

    public static List<Object> formatList(List<ClientRepresentation> clients, REPR format) {
        return clients.stream().map(x -> KCClientsController.formatRepr((ClientRepresentation)x, (REPR)format)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<RoleRepresentation> getRolesCurrent() {
        logger.info("Searching users for context");
        ClientResource client = KkClientFactory.getSingleton().getKKClient();
        RolesResource roles_resource = client.roles();
        List roles = roles_resource.list();
        return roles;
    }

    public static RoleRepresentation getRoleByNameCurrent(String name) {
        return KCClientsController.getRoleByName(null, (String)name);
    }

    public static RoleRepresentation getRoleByName(String clientId, String name) {
        logger.info("Searching users for context");
        ClientResource clientResource = KkClientFactory.getSingleton().getKKClientById(clientId);
        RolesResource roles_resource = clientResource.roles();
        RoleResource role = roles_resource.get(name);
        if (role == null) {
            throw new NotFoundException("cannot retrieve role " + name);
        }
        return role.toRepresentation();
    }

    public static List<UserRepresentation> getContextUsersByRoleCurrent(String role_name) {
        return KCClientsController.getContextUsersByRoleCurrent((String)role_name, null, null);
    }

    public static List<UserRepresentation> getContextUsersByRoleCurrent(String role_name, Integer firstResult, Integer maxResults) {
        return KCClientsController.getContextUsersByRole(null, (String)role_name, (Integer)firstResult, (Integer)maxResults);
    }

    public static List<UserRepresentation> getContextUsersByRole(String clientId, String role_name, Integer firstResult, Integer maxResults) {
        ClientResource clientResource = KkClientFactory.getSingleton().getKKClientById(clientId);
        RolesResource roles_resource = clientResource.roles();
        RoleResource r = roles_resource.get(role_name);
        List users = r.getUserMembers(firstResult, maxResults);
        return users;
    }

    public static List<UserRepresentation> getMemberGroupUsersCurrent() {
        return KCClientsController.getMemberGroupUsers(null, null, null);
    }

    public static List<UserRepresentation> getMemberGroupUsers(String clientId, Integer firstResult, Integer maxResults) {
        RealmResource realmResource = KkClientFactory.getSingleton().getKKRealm();
        ClientResource clientResource = KkClientFactory.getSingleton().getKKClientById(clientId);
        ClientRepresentation client = clientResource.toRepresentation();
        GroupRepresentation g_repr = realmResource.getGroupByPath(client.getName());
        GroupResource group = realmResource.groups().group(g_repr.getId());
        List user_members = group.members(firstResult, maxResults);
        return user_members;
    }
}

