/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.controller;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.HashMap;
import java.util.Map;
import org.gcube.service.idm.serializers.IdmObjectSerializator;

public class JWTController {
    public static Map<String, Object> decodeJwtToken(String token) throws JsonMappingException, JsonProcessingException {
        DecodedJWT decodedJWT = JWT.decode((String)token);
        String headerJson = IdmObjectSerializator.decodeBase64String((String)decodedJWT.getHeader());
        String payloadJson = IdmObjectSerializator.decodeBase64String((String)decodedJWT.getPayload());
        HashMap<String, Object> decoded = new HashMap<String, Object>();
        decoded.put("jwt_token", token);
        decoded.put("token", decodedJWT.getToken());
        decoded.put("header", IdmObjectSerializator.jsonStringToHasmap((String)headerJson));
        decoded.put("payload", IdmObjectSerializator.jsonStringToHasmap((String)payloadJson));
        decoded.put("jwt_decoded", decodedJWT);
        return decoded;
    }
}

