/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.webcohesion.enunciate.metadata.rs.ResponseCode;
import com.webcohesion.enunciate.metadata.rs.StatusCodes;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;
import org.gcube.service.idm.IdMManager;
import org.gcube.service.idm.controller.AuthController;
import org.gcube.service.idm.controller.KCUserController;
import org.gcube.service.idm.controller.LiferayProfileClient;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.gcube.service.idm.serializers.IdmObjectSerializator;
import org.gcube.service.utils.beans.ResponseBean;
import org.gcube.smartgears.annotations.ManagedBy;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedBy(value=IdMManager.class)
@Path(value="2/users")
public class SocialUsersAPI {
    private static final Logger logger = LoggerFactory.getLogger(SocialUsersAPI.class);

    @GET
    @Path(value="get-profile")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="The user's profile is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getUserProfile() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Secret secret = SecretManagerProvider.get();
            Owner owner = secret.getOwner();
            String username = owner.getId();
            GCubeUser profile = LiferayProfileClient.getUserProfileByUsername((String)username);
            responseBean.setResult((Object)profile);
            responseBean.setResult((Object)profile);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = new ObjectMapper().setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's profile", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }

    @GET
    @Path(value="/get-email")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getCurrentEmail() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        try {
            Secret secret = SecretManagerProvider.get();
            Owner owner = secret.getOwner();
            String email = owner.getEmail();
            responseBean.setResult((Object)email);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve user's email", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="get-fullname")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="The user's fullname is reported in the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getUserFullname() {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        String username = owner.getId();
        String fullName = null;
        if (owner.isApplication()) {
            logger.warn("Trying to access users method via a token different than USER is not allowed");
            throw new ForbiddenException("User's information can only be retrieved through a user token (not qualified)");
        }
        try {
            GCubeUser profile = LiferayProfileClient.getUserProfileByUsername((String)username);
            fullName = profile.getFullname();
            logger.info("Found fullname " + fullName + " for user " + username);
            responseBean.setResult((Object)fullName);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve attribute for user.", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="/get-all-usernames")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getUsernamesByRole(@QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="100") int max, @QueryParam(value="firstResult") @DefaultValue(value="0") int firstResult, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults) {
        if (firstResult > 0) {
            first = firstResult;
        }
        if (maxResults != 100) {
            max = maxResults;
        }
        Response.Status status = Response.Status.OK;
        ResponseBean responseBean = new ResponseBean();
        try {
            List users = KCUserController.contextUsers((Integer)first, (Integer)max);
            Object result = KCUserController.formatList((List)users, (KCUserController.REPR)KCUserController.REPR.compact);
            responseBean.setResult(result);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve users with the requested role", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }

    @GET
    @Path(value="/get-all-fullnames-and-usernames")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getAllUsernamesFullnames(@QueryParam(value="emailVerified") Boolean emailVerified, @QueryParam(value="enabled") Boolean enabled, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="100") int max, @QueryParam(value="firstResult") @DefaultValue(value="0") int firstResult, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults) {
        if (firstResult > 0) {
            first = firstResult;
        }
        if (maxResults != 100) {
            max = maxResults;
        }
        Response.Status status = Response.Status.OK;
        ResponseBean responseBean = new ResponseBean();
        try {
            UsersResource users_resource = KCUserController.realmUsersResource();
            List users = users_resource.search(emailVerified, Integer.valueOf(first), Integer.valueOf(max), enabled, Boolean.valueOf(true));
            HashMap usernamesAndFullnames = new HashMap();
            users.forEach(user -> {
                String string = usernamesAndFullnames.put(user.getUsername(), user.getEmail());
            });
            responseBean.setResult(usernamesAndFullnames);
            responseBean.setSuccess(true);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve users", (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="/get-usernames-by-role")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getUsernamesByRole(@QueryParam(value="role-name") String roleName, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="100") int max, @QueryParam(value="firstResult") @DefaultValue(value="0") int firstResult, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults) {
        if (firstResult > 0) {
            first = firstResult;
        }
        if (maxResults != 100) {
            max = maxResults;
        }
        Response.Status status = Response.Status.OK;
        ResponseBean responseBean = new ResponseBean();
        ArrayList<String> usernames = new ArrayList<String>();
        try {
            List users = KCUserController.searchUsersByRole((String)roleName, (Integer)first, (Integer)max);
            if (users != null) {
                for (UserRepresentation user : users) {
                    usernames.add(user.getUsername());
                }
            }
            responseBean.setResult(usernames);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        catch (Exception e) {
            logger.error("Unable to retrieve users with the requested role", (Throwable)e);
            responseBean.setMessage(e.getMessage());
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }

    @GET
    @Path(value="/user-exists")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response checkUserExists(@QueryParam(value="username") String username) {
        Response.Status status = Response.Status.OK;
        ResponseBean responseBean = new ResponseBean();
        try {
            UserRepresentation user = KCUserController.getUserByUsername((String)username);
            boolean user_exists = user != null;
            responseBean.setResult((Object)user_exists);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        catch (Exception e) {
            logger.error("Unable to check if user exists with username " + username, (Throwable)e);
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }

    @GET
    @Path(value="get-custom-attribute")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successful read of the attribute, reported in the 'result' field of the returned object"), @ResponseCode(code=404, condition="Such an attribute doesn't exist"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response readCustomAttr(@QueryParam(value="username") String username, @QueryParam(value="attribute") @NotNull(message="attribute name is missing") @NotNull(message="attribute name is missing") String attributeKey) throws ValidationException {
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        if (username == null || username.equals("me")) {
            if (owner.isApplication()) {
                logger.warn("Trying to access users method via a token different than USER is not allowed");
                throw new ForbiddenException("User's information can only be retrieved through a user token (not qualified)");
            }
            username = owner.getId();
        }
        if (!AuthController.checkAnyRole((List)AuthController.ACCESS_READ_ROLES) && !username.equals(owner.getId())) {
            throw new ForbiddenException("User is not authorized to access private data");
        }
        UserRepresentation user = KCUserController.getUserByUsername((String)username);
        Map attributes = user.getAttributes();
        if (attributes.containsKey(attributeKey)) {
            responseBean.setResult(attributes.get(attributeKey));
            responseBean.setSuccess(true);
        } else {
            responseBean.setSuccess(false);
            String msg = String.format("Unable to retrieve attribute %s for user %s", attributeKey, user.getUsername());
            responseBean.setMessage(msg);
            logger.error(msg);
            status = Response.Status.NOT_FOUND;
        }
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }

    @GET
    @Path(value="/get-oauth-profile")
    @Produces(value={"application/json;charset=UTF-8", "application/vnd.api+json"})
    public Response getCurrentOAuthProfile() {
        Response.Status status = Response.Status.OK;
        ResponseBean responseBean = new ResponseBean();
        try {
            Secret secret = SecretManagerProvider.get();
            Owner owner = secret.getOwner();
            UserRepresentation user = KCUserController.getUserByUsername((String)owner.getId());
            responseBean.setResult((Object)user);
            responseBean.setSuccess(true);
            ObjectMapper objectMapper = IdmObjectSerializator.getSerializer();
            String jsonData = objectMapper.writeValueAsString((Object)responseBean);
            return Response.ok((Object)jsonData).build();
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return Response.serverError().build();
        }
        catch (Exception exception) {
            logger.error("Unable to retrieve user profile");
            status = Response.Status.INTERNAL_SERVER_ERROR;
            return Response.status((Response.Status)status).entity((Object)responseBean).build();
        }
    }

    @GET
    @Path(value="get-usernames-by-global-role")
    @Produces(value={"application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="The list is put into the 'result' field of the returned object"), @ResponseCode(code=500, condition="The error is reported into the 'message' field of the returned object")})
    public Response getUsernamesByGlobalRole(@QueryParam(value="role-name") String role_name, @QueryParam(value="first") @DefaultValue(value="0") int first, @QueryParam(value="max") @DefaultValue(value="100") int max, @QueryParam(value="firstResult") @DefaultValue(value="0") int firstResult, @QueryParam(value="maxResults") @DefaultValue(value="100") int maxResults) {
        if (firstResult > 0) {
            first = firstResult;
        }
        if (maxResults != 100) {
            max = maxResults;
        }
        ResponseBean responseBean = new ResponseBean();
        Response.Status status = Response.Status.OK;
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        if (!owner.isApplication()) {
            logger.warn("User's information can only be retrieved through a user token (not qualified)");
            throw new ForbiddenException("This method can only be called with an infrastructure token");
        }
        RealmResource realmResource = KkClientFactory.getSingleton().getKKRealm();
        RolesResource roles_resource = realmResource.roles();
        RoleResource r = roles_resource.get(role_name);
        List users = r.getUserMembers(Integer.valueOf(first), Integer.valueOf(max));
        responseBean.setResult(KCUserController.formatList((List)users, (KCUserController.REPR)KCUserController.REPR.username));
        responseBean.setSuccess(true);
        return Response.status((Response.Status)status).entity((Object)responseBean).build();
    }
}

