/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.controller;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.service.idm.controller.KCUserController;
import org.gcube.service.idm.keycloack.KeycloackApiClient;
import org.gcube.service.idm.keycloack.KkClientFactory;
import org.keycloak.admin.client.resource.ClientResource;
import org.keycloak.admin.client.resource.RealmResource;
import org.keycloak.admin.client.resource.RoleResource;
import org.keycloak.admin.client.resource.RolesResource;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class KCUserController {
    public static String MEMBER_ROLE_NAME = "Member";
    private static final Logger logger = LoggerFactory.getLogger(KCUserController.class);

    public static UsersResource realmUsersResource() {
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        UsersResource users = realm.users();
        return users;
    }

    public static List<UserRepresentation> realmUser(Integer firstResult, Integer maxResults) {
        UsersResource uresource = KCUserController.realmUsersResource();
        List users = uresource.list(firstResult, maxResults);
        return users;
    }

    public static List<UserRepresentation> contextUsers(Integer firstResult, Integer maxResults) {
        ClientResource client = KkClientFactory.getSingleton().getKKClient();
        RolesResource roles_resource = client.roles();
        RoleResource r = roles_resource.get(MEMBER_ROLE_NAME);
        List users = r.getUserMembers(firstResult, maxResults);
        return users;
    }

    public static Object formatRepr(UserRepresentation user, REPR format) {
        if (user == null || format.equals((Object)REPR.none)) {
            return null;
        }
        if (format.equals((Object)REPR.username)) {
            return user.getUsername();
        }
        if (format.equals((Object)REPR.email) || format.equals((Object)REPR.username_email)) {
            return user.getEmail();
        }
        if (format.equals((Object)REPR.id)) {
            return user.getId();
        }
        if (format.equals((Object)REPR.fullname)) {
            return String.valueOf(user.getFirstName()) + " " + user.getLastName();
        }
        return user;
    }

    public static Object formatList(List<UserRepresentation> users, REPR format) {
        if (format.equals((Object)REPR.username_email) || format.equals((Object)REPR.username_user)) {
            HashMap usernamesAndFullnames = new HashMap();
            users.forEach(user -> {
                Object object = usernamesAndFullnames.put(user.getUsername(), KCUserController.formatRepr((UserRepresentation)user, (REPR)format));
            });
            return usernamesAndFullnames;
        }
        return users.stream().map(x -> KCUserController.formatRepr((UserRepresentation)x, (REPR)format)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<UserRepresentation> search(String username, String firstName, String lastName, String email, Boolean emailVerified, String idpAlias, String idpUserId, Integer firstResult, Integer maxResults, Boolean enabled, Boolean briefRepresentation) {
        logger.info("Searching users with params");
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        List users = realm.users().search(username, firstName, lastName, email, emailVerified, idpAlias, idpUserId, firstResult, maxResults, enabled, briefRepresentation);
        return users;
    }

    public static UserRepresentation getUserByEmail(String email) {
        logger.info("Searching user by email: {}", (Object)email);
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        UserRepresentation user = realm.users().searchByEmail(email, Boolean.valueOf(true)).stream().findFirst().orElse(null);
        if (user == null) {
            throw new NotFoundException("cannot retrieve user for email" + email);
        }
        return user;
    }

    public static UserRepresentation getUserById(String username) {
        logger.info("Searching user by username: {}", (Object)username);
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        UserRepresentation user = realm.users().search(username).stream().findFirst().orElse(null);
        if (user == null) {
            throw new NotFoundException("cannot retrieve user " + username);
        }
        return user;
    }

    public static UserRepresentation getUserByUsername(String username) {
        logger.info("Searching user by username: {}", (Object)username);
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        UsersResource users = realm.users();
        List search_user = users.search(username, Boolean.valueOf(true));
        UserRepresentation user = search_user.stream().findFirst().orElse(null);
        if (user == null) {
            throw new NotFoundException("cannot retrieve user " + username);
        }
        return user;
    }

    public static UserResource getUserResourceByUsername(String username) {
        logger.info("Searching user by username: {}", (Object)username);
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        UserRepresentation user = realm.users().search(username, Boolean.valueOf(true)).stream().findFirst().orElse(null);
        if (user == null) {
            throw new NotFoundException("cannot retrieve user " + username);
        }
        UserResource userRes = realm.users().get(user.getId());
        if (userRes == null) {
            throw new NotFoundException("cannot retrieve user " + username);
        }
        return userRes;
    }

    public static List<UserRepresentation> searchUsersByRole(String roleName, Integer firstResult, Integer maxResults) {
        logger.info("Searching users by role: {}", (Object)roleName);
        ClientResource client = KkClientFactory.getSingleton().getKKClient();
        List users = client.roles().get(roleName).getUserMembers(firstResult, maxResults);
        return users;
    }

    public static List<ClientRepresentation> clients() {
        RealmResource realm = KkClientFactory.getSingleton().getKKRealm();
        String ctx = SecretManagerProvider.get().getContext();
        KeycloackApiClient keycloackApiClient = KkClientFactory.getSingleton().createtKeycloakInstance(ctx);
        List clients = realm.clients().findByClientId(keycloackApiClient.clientIdContext);
        return clients;
    }

    public static Object getUserParameter(String username, String parameter) {
        UserRepresentation user = KCUserController.getUserByUsername((String)username);
        if (user == null) {
            throw new NotFoundException("cannot retrieve user " + username);
        }
        if (parameter == null) {
            return user;
        }
        if (parameter.equals("email")) {
            return user.getEmail();
        }
        if (parameter.equals("roles_realm")) {
            return user.getRealmRoles();
        }
        if (parameter.equals("roles_clients")) {
            return user.getClientRoles();
        }
        if (parameter.equals("groups")) {
            return user.getGroups();
        }
        if (parameter.equals("id")) {
            return user.getId();
        }
        if (parameter.equals("username")) {
            return user.getUsername();
        }
        if (parameter.equals("name")) {
            return String.valueOf(user.getFirstName()) + " " + user.getLastName();
        }
        if (parameter.equals("attributes")) {
            return user.getAttributes();
        }
        throw new BadRequestException("unknow parameter " + parameter);
    }
}

