/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.service.idm.controller;

import java.util.List;
import java.util.Map;
import javax.ws.rs.ForbiddenException;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.security.Owner;
import org.gcube.common.security.providers.SecretManagerProvider;
import org.gcube.common.security.secrets.Secret;

/*
 * Exception performing whole class analysis ignored.
 */
public class AuthController {
    public static final String IDM_SERVICE_READ = "idm-service-read";
    public static final String IDM_SERVICE_ADMIN = "idm-service-admin";
    public static final String IDM_SERVICE_REALM = "idm-service-realm";
    public static final List<String> ACCESS_READ_ROLES = List.of("idm-service-read", "idm-service-admin", "idm-service-realm");
    public static final List<String> ACCESS_ADMIN_ROLES = List.of("idm-service-admin", "idm-service-realm");
    public static final List<String> ACCESS_ADMIN_REALM_ROLES = List.of("idm-service-realm");

    public static String getAccessToken() {
        Map authorizations = SecretManagerProvider.get().getHTTPAuthorizationHeaders();
        String access_token = ((String)authorizations.get("Authorization")).replace("Bearer", "").trim();
        return access_token;
    }

    public static Owner getOwner() {
        Secret secret = SecretManagerProvider.get();
        Owner owner = secret.getOwner();
        return owner;
    }

    public static boolean checkRealmRole(String realm_role) {
        String access_token = AuthController.getAccessToken();
        return AuthController.checkRealmRole((String)realm_role, (String)access_token);
    }

    public static boolean checkRealmRole(String realm_role, String access_token) {
        try {
            return ModelUtils.getAccessTokenFrom((String)access_token).getRealmAccess().getRoles().contains(realm_role);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean checkContextRole(String context_role) {
        Owner owner = AuthController.getOwner();
        return AuthController.checkContextRole((String)context_role, (Owner)owner);
    }

    public static boolean checkContextRole(String context_role, Owner owner) {
        return owner.getRoles().contains(context_role);
    }

    public static boolean checkRole(String role) {
        return AuthController.checkContextRole((String)role) || AuthController.checkRealmRole((String)role);
    }

    public static boolean checkAnyRole(List<String> roles) {
        String access_token = AuthController.getAccessToken();
        Owner owner = AuthController.getOwner();
        for (String role : roles) {
            if (!AuthController.checkContextRole((String)role, (Owner)owner) && !AuthController.checkRealmRole((String)role, (String)access_token)) continue;
            return true;
        }
        return false;
    }

    public static boolean userIsMe(String username) {
        Owner owner = AuthController.getOwner();
        return AuthController.userIsMe((String)username, (Owner)owner);
    }

    public static boolean userIsMe(String username, Owner owner) {
        return !owner.isApplication() && owner.getId().equals(username);
    }

    public static void checkIsRealmAdmin(String message) throws ForbiddenException {
        if (!AuthController.checkAnyRole((List)ACCESS_ADMIN_ROLES)) {
            throw new ForbiddenException(message);
        }
    }

    public static void checkIsContextmAdmin(String message) throws ForbiddenException {
        if (!AuthController.checkAnyRole((List)ACCESS_ADMIN_REALM_ROLES)) {
            throw new ForbiddenException(message);
        }
    }
}

