/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.idm.client.clients;

import jakarta.ws.rs.BadRequestException;
import jakarta.ws.rs.NotAuthorizedException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.common.gxhttp.util.ContentUtils;
import org.gcube.common.gxrest.request.GXHTTPStringRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.idm.client.beans.ResponseBean;
import org.gcube.idm.client.model.util.JsonUtilsCustom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdmRestClient {
    protected static Logger logger = LoggerFactory.getLogger(IdmRestClient.class);
    protected static final String AUTHORIZATION_HEADER = "Authorization";
    protected URI BASE_URL = null;

    public URI getBASE_URL() {
        return this.BASE_URL;
    }

    public void setBASE_URL(URI bASE_URL) {
        this.BASE_URL = bASE_URL;
    }

    public IdmRestClient(String base_url) throws URISyntaxException {
        if (!((String)base_url).endsWith("/")) {
            base_url = (String)base_url + "/";
        }
        this.BASE_URL = new URI((String)base_url);
    }

    public IdmRestClient(URI base_url) {
        this.BASE_URL = base_url;
    }

    public URL getUrl(String extraPath) throws URISyntaxException, MalformedURLException {
        if (extraPath.startsWith("/")) {
            extraPath = extraPath.substring(1);
        }
        return this.BASE_URL.resolve(extraPath).toURL();
    }

    public URI getUri(String extraPath) throws URISyntaxException, MalformedURLException {
        return this.BASE_URL.resolve(extraPath);
    }

    public static String bearerAuth(String token) {
        return "Bearer " + token;
    }

    public static HashMap<String, String> getHeadersWithAuth(String auth_token, HashMap<String, String> headers) {
        if (headers == null) {
            headers = new HashMap();
        }
        if (auth_token != null) {
            headers.put(AUTHORIZATION_HEADER, IdmRestClient.bearerAuth(auth_token));
        }
        return headers;
    }

    public <T> ResponseBean<T> performGetRequest(String relativeUrl, String auth_token, Class<T> classtype) {
        JavaType objectsType = JsonUtilsCustom.getObjectJT(classtype);
        return this.performGetRequest(relativeUrl, auth_token, objectsType);
    }

    public <T> ResponseBean<T> performGetRequest(String relativeUrl, Map<String, String> headers, Map<String, String> params, Class<T> classtype) throws NotAuthorizedException, BadRequestException {
        JavaType jt = JsonUtilsCustom.getObjectJT(classtype);
        return this.performGetRequest(relativeUrl, headers, params, jt);
    }

    public <T> ResponseBean<T> performGetRequest(String relativeUrl, String auth_token, JavaType objectsType) throws NotAuthorizedException, BadRequestException {
        HashMap<String, String> headers = IdmRestClient.getHeadersWithAuth(auth_token, null);
        return this.performGetRequest(relativeUrl, headers, null, objectsType);
    }

    public <T> ResponseBean<T> performGetRequest(String relativeUrl, Map<String, String> headers, Map<String, String> params, JavaType objectsType) throws NotAuthorizedException, BadRequestException {
        GXInboundResponse response;
        if (relativeUrl == null) {
            throw new BadRequestException("relativeUrl URL must be not null");
        }
        URL url = null;
        try {
            url = this.getUrl(relativeUrl);
        }
        catch (Exception e) {
            throw new BadRequestException("Url not acceptable", (Throwable)e);
        }
        GXHTTPStringRequest request = IdmRestClient.prepareGetRequest(url, headers, params);
        try {
            response = request.get();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException("Cannot send request correctly", (Throwable)e);
        }
        try {
            if (response.isSuccessResponse()) {
                JavaType rb_type = JsonUtilsCustom.getResponseBeanOfObjectsType(objectsType);
                return (ResponseBean)IdmRestClient.tryConvertStreamedContentFromJson(response, rb_type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException("Cannot send request correctly", (Throwable)e);
        }
        if (response.getHTTPCode() == 401) {
            throw new NotAuthorizedException((Object)"token invalid", new Object[0]);
        }
        throw new BadRequestException("Cannot send request correctly");
    }

    public <T> ResponseBean<T> performPostRequest(String relativeUrl, Map<String, String> headers, Map<String, List<String>> params, Class<T> classtype) throws NotAuthorizedException, BadRequestException {
        GXInboundResponse response;
        if (relativeUrl == null) {
            throw new BadRequestException("relativeUrl URL must be not null");
        }
        URL url = null;
        try {
            url = this.getUrl(relativeUrl);
        }
        catch (Exception e) {
            throw new BadRequestException("Url not acceptable", (Throwable)e);
        }
        GXHTTPStringRequest request = IdmRestClient.preparePostRequest(url, headers, params);
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new BadRequestException("Cannot send request correctly", (Throwable)e);
        }
        try {
            if (response.isSuccessResponse()) {
                JavaType rb_type = JsonUtilsCustom.getResponseBeansObjectJT(classtype);
                return (ResponseBean)IdmRestClient.tryConvertStreamedContentFromJson(response, rb_type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException("Cannot send request correctly", (Throwable)e);
        }
        throw new BadRequestException("Cannot send request correctly");
    }

    public static void safeSetAsExternalCallForOldAPI(GXHTTPStringRequest request) {
        try {
            logger.trace("Looking for the 'isExternalCall' method in the 'GXHTTPStringRequest' class");
            Method isExetnalCallMethod = request.getClass().getMethod("isExternalCall", Boolean.TYPE);
            logger.trace("Method found, is the old gxJRS API. Invoking it with 'true' argument");
            isExetnalCallMethod.invoke((Object)request, true);
        }
        catch (NoSuchMethodException e) {
            logger.trace("Method not found, is the new gxJRS API");
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            logger.warn("Cannot invoke 'isExternalCall' method via reflection on 'GXHTTPStringRequest' class", (Throwable)e);
        }
    }

    public static String getStreamedContentAsString(HttpURLConnection response) throws IOException {
        String body = ContentUtils.toString((byte[])ContentUtils.toByteArray((InputStream)response.getInputStream()));
        return body;
    }

    public static <T> T tryConvertStreamedContentFromJson(HttpURLConnection response, Class<T> classtype) throws IOException, Exception {
        return JsonUtilsCustom.fromJson(IdmRestClient.getStreamedContentAsString(response), classtype);
    }

    public static <T> T tryConvertStreamedContentFromJson(HttpURLConnection response, JavaType objectType) throws IOException, Exception {
        return JsonUtilsCustom.fromJson(ContentUtils.toByteArray((InputStream)response.getInputStream()), objectType);
    }

    public static <T> T tryConvertStreamedContentFromJson(GXInboundResponse response, JavaType objectType) throws IOException, Exception {
        String body = response.getStreamedContentAsString();
        return JsonUtilsCustom.fromJson(body, objectType);
    }

    public static <T> T tryConvertStreamedContentFromJson(GXInboundResponse response, Class<T> classtype) throws IOException, Exception {
        return JsonUtilsCustom.fromJson(response.getStreamedContentAsString(), classtype);
    }

    public static GXHTTPStringRequest preparePostRequest(URL url, Map<String, String> headers, Map<String, List<String>> params) throws BadRequestException {
        GXHTTPStringRequest request;
        try {
            String queryString = null;
            if (params != null) {
                queryString = params.entrySet().stream().flatMap(p -> ((List)p.getValue()).stream().map(v -> (String)p.getKey() + "=" + v)).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            }
            logger.trace("Query string is {}", queryString);
            request = GXHTTPStringRequest.newRequest((String)url.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            IdmRestClient.safeSetAsExternalCallForOldAPI(request);
            logger.trace("Adding provided headers: {}", headers);
            for (String headerName : headers.keySet()) {
                request.header(headerName, headers.get(headerName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException("Cannot construct the request object correctly", (Throwable)e);
        }
        return request;
    }

    public static GXHTTPStringRequest prepareGetRequest(URL url, Map<String, String> headers, Map<String, String> params) throws BadRequestException {
        GXHTTPStringRequest request;
        try {
            Object queryString = null;
            logger.trace("Query string is {}", queryString);
            request = GXHTTPStringRequest.newRequest((String)url.toString());
            if (params != null) {
                request.queryParams(params);
            }
            IdmRestClient.safeSetAsExternalCallForOldAPI(request);
            logger.trace("Adding provided headers: {}", headers);
            for (String headerName : headers.keySet()) {
                request.header(headerName, headers.get(headerName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadRequestException("Cannot construct the request object correctly", (Throwable)e);
        }
        return request;
    }
}

