/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.idm.client.model.util;

import java.util.List;
import java.util.Map;
import org.gcube.com.fasterxml.jackson.databind.DeserializationFeature;
import org.gcube.com.fasterxml.jackson.databind.JavaType;
import org.gcube.com.fasterxml.jackson.databind.ObjectMapper;
import org.gcube.com.fasterxml.jackson.databind.type.TypeFactory;
import org.gcube.idm.client.beans.ResponseBean;

public class JsonUtilsCustom {
    private static TypeFactory _tf = null;
    private static ObjectMapper _om = null;

    private static ObjectMapper getObjectMapper() {
        if (_om == null) {
            _om = new ObjectMapper();
        }
        return _om;
    }

    private static TypeFactory getTypeFactory() {
        if (_tf == null) {
            ObjectMapper om = JsonUtilsCustom.getObjectMapper();
            _tf = om.getTypeFactory();
        }
        return _tf;
    }

    public static JavaType getObjectJT(Class<?> classType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType objectsType = tf.constructType(classType);
        return objectsType;
    }

    public static JavaType getResponseBeansObjectJT(Class<?> classType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType objectsType = tf.constructType(classType);
        return JsonUtilsCustom.getResponseBeanOfObjectsType(objectsType);
    }

    public static JavaType getResponseBeanOfObjectsType(JavaType objectsType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType beansType = tf.constructParametrizedType(ResponseBean.class, ResponseBean.class, new JavaType[]{objectsType});
        return beansType;
    }

    public static JavaType geListOfObjectsType(Class<?> classType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType objectsType = tf.constructType(classType);
        return JsonUtilsCustom.geListOfObjectsType(objectsType);
    }

    public static JavaType geListOfObjectsType(JavaType objectsType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType listOfObject = tf.constructParametrizedType(List.class, List.class, new JavaType[]{objectsType});
        return listOfObject;
    }

    public static JavaType geMapOfObjectsType(Class<?> keyClass, Class<?> valueClass) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType keyType = tf.constructType(keyClass);
        JavaType valueType = tf.constructType(valueClass);
        return JsonUtilsCustom.geMapOfObjectsType(keyType, valueType);
    }

    public static JavaType geMapOfObjectsType(JavaType keyType, JavaType valueType) {
        TypeFactory tf = JsonUtilsCustom.getTypeFactory();
        JavaType mapOfObject = tf.constructParametrizedType(Map.class, Map.class, new JavaType[]{keyType, valueType});
        return mapOfObject;
    }

    public static JavaType getResponseBeanOfListOfObjectsType(Class<?> classType) {
        JavaType listOfObjectType = JsonUtilsCustom.geListOfObjectsType(classType);
        return JsonUtilsCustom.getResponseBeanOfListOfObjectsType(listOfObjectType);
    }

    public static JavaType getResponseBeanOfListOfObjectsType(JavaType listOfObjectType) {
        JavaType beansType = JsonUtilsCustom.getResponseBeanOfObjectsType(listOfObjectType);
        return beansType;
    }

    public static <T> T fromJson(byte[] bytes, JavaType type) throws Exception {
        try {
            return (T)JsonUtilsCustom.getObjectMapper().readValue(bytes, type);
        }
        catch (Exception e) {
            throw new Exception("Cannot deserialize to the object.", e);
        }
    }

    public static <T> T responseBeanFromJson(byte[] bytes, JavaType type) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (T)objectMapper.readValue(bytes, type);
        }
        catch (Exception e) {
            throw new Exception("Cannot deserialize to the object.", e);
        }
    }

    public static <T> T fromJson(byte[] bytes, Class<T> raw) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (T)objectMapper.readValue(bytes, raw);
        }
        catch (Exception e) {
            throw new Exception("Cannot deserialize to the object.", e);
        }
    }

    public static <T> T fromJson(String json, Class<T> raw) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            return (T)objectMapper.readValue(json, raw);
        }
        catch (Exception e) {
            throw new Exception("Cannot deserialize to the object.", e);
        }
    }

    public static <T> T fromJson(String json, JavaType objectType) throws Exception {
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return (T)objectMapper.readValue(json, objectType);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Cannot deserialize to the object.", e);
        }
    }
}

