/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.protocol.oidc.mapper;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.rar.AuthorizationDetails;
import org.keycloak.representations.AccessToken;
import org.keycloak.representations.IDToken;

public class D4ScienceDynamicScopeContextMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper {
    private static final Logger logger = Logger.getLogger(D4ScienceDynamicScopeContextMapper.class);
    public static final String DYNAMIC_SCOPE_NAME = "d4scm.dynamic-scope-name";
    public static final String OVERWRITE_AUD = "d4scm.overwrite-aud";
    public static final String NARROW_RESOURCE_ACCESS = "d4scm.narrow-ra";
    private static final Map<String, ProviderConfigProperty> CONFIG_PROPERTIES_MAP = new HashMap<String, ProviderConfigProperty>();
    private static final int PRIORITY = Integer.MAX_VALUE;
    private static final String DISPLAY_TYPE = "OIDC D4Science Dynamic Scope Context Mapper";
    private static final String PROVIDER_ID = "oidc-d4science-dynamic-scope-context-mapper";
    public static final String DEFAULT_DYNAMIC_SCOPE_NAME = "d4s-context";
    public static final String DEFAULT_TOKEN_CLAIM = "d4s-context";
    public static final String AUD_TOKEN_CLAIM = "aud";
    public static final ProtocolMapperModel audProtocolMapperModel = OIDCAttributeMapperHelper.createClaimMapper(null, null, (String)"aud", (String)"String", (boolean)true, (boolean)true, (boolean)true, null);

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public String getDisplayType() {
        return DISPLAY_TYPE;
    }

    public String getHelpText() {
        return "Maps the D4Science context audience by reading the configured header's value and sets it as the configured token claim, if it is in scope";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new ArrayList<ProviderConfigProperty>(CONFIG_PROPERTIES_MAP.values());
    }

    public String getId() {
        return PROVIDER_ID;
    }

    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        if (token instanceof AccessToken) {
            AccessToken accessToken = (AccessToken)token;
            String dynamicScopeName = (String)mappingModel.getConfig().get(DYNAMIC_SCOPE_NAME);
            Optional<AuthorizationDetails> authorizationDetailsOptional = clientSessionCtx.getAuthorizationRequestContext().getAuthorizationDetailEntries().stream().filter(details -> details.isDynamicScope() && details.getClientScope().getName().equals(dynamicScopeName)).findFirst();
            if (authorizationDetailsOptional.isPresent()) {
                String requestedD4SContext = authorizationDetailsOptional.get().getDynamicScopeParam();
                if (requestedD4SContext.startsWith("/")) {
                    try {
                        logger.debugf("Requested context as decoded string, urlencoding it: %s", (Object)clientSessionCtx);
                        requestedD4SContext = URLEncoder.encode(requestedD4SContext, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        logger.error((Object)("Cannot encode context: " + requestedD4SContext), (Throwable)e);
                    }
                }
                if (requestedD4SContext != null && !"".equals(requestedD4SContext)) {
                    logger.debugf("Checking resource access for the requested context: %s", (Object)requestedD4SContext);
                    AccessToken.Access contextAccessInResourceAccess = accessToken.getResourceAccess(requestedD4SContext);
                    if (accessToken.getResourceAccess().isEmpty() || contextAccessInResourceAccess != null) {
                        logger.infof("Mapping context %s as the configured claim: %s", (Object)requestedD4SContext, mappingModel.getConfig().get("claim.name"));
                        OIDCAttributeMapperHelper.mapClaim((IDToken)token, (ProtocolMapperModel)mappingModel, (Object)requestedD4SContext);
                        if (Boolean.parseBoolean((String)mappingModel.getConfig().get(OVERWRITE_AUD))) {
                            logger.infof("Adding/overwriting `aud` claim with %s", (Object)requestedD4SContext);
                            OIDCAttributeMapperHelper.mapClaim((IDToken)token, (ProtocolMapperModel)audProtocolMapperModel, (Object)requestedD4SContext);
                        }
                        if (Boolean.parseBoolean((String)mappingModel.getConfig().get(NARROW_RESOURCE_ACCESS))) {
                            logger.infof("Removing all access details but the requested context: %s", (Object)requestedD4SContext);
                            accessToken.getResourceAccess().clear();
                            accessToken.getResourceAccess().put(requestedD4SContext, contextAccessInResourceAccess);
                        }
                    } else {
                        logger.warnf("Requested context '%s' is not accessible to the client: %s", (Object)requestedD4SContext, (Object)clientSessionCtx.getClientSession().getClient().getName());
                    }
                } else {
                    logger.tracef("Authorization detail for '%s' dynamic scope not found in request", (Object)dynamicScopeName);
                }
            }
        }
    }

    static {
        ArrayList<ProviderConfigProperty> providerConfigProperties = new ArrayList<ProviderConfigProperty>();
        OIDCAttributeMapperHelper.addTokenClaimNameConfig(providerConfigProperties);
        providerConfigProperties.forEach(conf -> {
            if ("claim.name".equals(conf.getName())) {
                conf.setDefaultValue((Object)"d4s-context");
            }
            conf.setReadOnly(true);
        });
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(providerConfigProperties, D4ScienceDynamicScopeContextMapper.class);
        ProviderConfigProperty dynamicScopeProperty = new ProviderConfigProperty();
        dynamicScopeProperty.setName(DYNAMIC_SCOPE_NAME);
        dynamicScopeProperty.setLabel("Dynamic scope name with the requested context");
        dynamicScopeProperty.setHelpText("The HTTP header that contains the requested context to be mapped in the configured claim");
        dynamicScopeProperty.setType("String");
        dynamicScopeProperty.setDefaultValue((Object)"d4s-context");
        dynamicScopeProperty.setReadOnly(true);
        dynamicScopeProperty.setRequired(true);
        providerConfigProperties.add(dynamicScopeProperty);
        ProviderConfigProperty overwriteProperty = new ProviderConfigProperty();
        overwriteProperty.setName(OVERWRITE_AUD);
        overwriteProperty.setLabel("Add/overwrite `aud` claim?");
        overwriteProperty.setType("boolean");
        overwriteProperty.setHelpText("Overwrite the `aud` claim to the requested context entry");
        dynamicScopeProperty.setDefaultValue((Object)"true");
        providerConfigProperties.add(overwriteProperty);
        ProviderConfigProperty narrowProperty = new ProviderConfigProperty();
        narrowProperty.setName(NARROW_RESOURCE_ACCESS);
        narrowProperty.setLabel("Narrow down resource access array?");
        narrowProperty.setType("boolean");
        narrowProperty.setHelpText("Narrow down resource access claim to contain only the requested context entry");
        dynamicScopeProperty.setDefaultValue((Object)"true");
        providerConfigProperties.add(narrowProperty);
        providerConfigProperties.forEach(conf -> CONFIG_PROPERTIES_MAP.put(conf.getName(), (ProviderConfigProperty)conf));
    }
}

