/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar;

import io.netty.handler.codec.http.multipart.FileUpload;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotAuthorizedException;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.gcube.keycloak.avatar.AbstractAvatarResource;
import org.gcube.keycloak.avatar.AvatarAdminResource;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakUriInfo;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.resources.RealmsResource;
import org.keycloak.utils.KeycloakSessionUtil;

public class AvatarResource
extends AbstractAvatarResource {
    public AvatarResource(KeycloakSession session) {
        super(session);
    }

    @Path(value="/admin")
    public AvatarAdminResource admin() {
        AvatarAdminResource service = new AvatarAdminResource(this.session);
        service.init();
        return service;
    }

    @OPTIONS
    public Response handleCorsPreflight() {
        logger.info((Object)"Received CORS preflight request for ext/user");
        return Cors.builder().preflight().allowAllOrigins().allowedMethods(new String[]{"GET", "POST", "DELETE"}).exposedHeaders(new String[]{"Location"}).auth().add(Response.ok());
    }

    @GET
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response downloadCurrentUserAvatarImage() {
        if (this.auth == null) {
            logger.debug((Object)"Unhautorized call to get avatar");
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        logger.debugf("Getting avatar for user %s in realm %s", (Object)this.auth.getUser(), (Object)this.auth.getSession().getRealm());
        return Cors.builder().allowAllOrigins().allowedMethods(new String[]{"GET", "POST", "DELETE"}).exposedHeaders(new String[]{"Location"}).auth().add(Response.fromResponse((Response)this.fetchAndCreateResponse(this.auth.getSession().getRealm(), this.auth.getUser())));
    }

    @POST
    @Consumes(value={"multipart/form-data"})
    public Response uploadCurrentUserAvatarImage(@FormParam(value="image") FileUpload image) {
        if (this.auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        logger.debugf("Uploading new avatar for user %s in realm %s", (Object)this.auth.getUser(), (Object)this.auth.getSession().getRealm());
        KeycloakSession session = KeycloakSessionUtil.getKeycloakSession();
        KeycloakUriInfo uriInfo = session.getContext().getUri();
        Response response = null;
        try {
            this.saveUserImage(this.auth.getSession().getRealm(), this.auth.getUser(), Files.newInputStream(image.getFile().toPath(), new OpenOption[0]));
            if (uriInfo.getQueryParameters().containsKey((Object)"account")) {
                UriBuilder uriBuilder = RealmsResource.accountUrl((UriBuilder)session.getContext().getUri().getBaseUriBuilder());
                for (String parameterName : uriInfo.getQueryParameters().keySet()) {
                    List parameterValues = (List)uriInfo.getQueryParameters().get((Object)parameterName);
                    for (String parameterValue : parameterValues) {
                        uriBuilder.queryParam(parameterName, new Object[]{parameterValue});
                    }
                }
                response = Response.seeOther((URI)uriBuilder.build(new Object[]{this.auth.getSession().getRealm().getName()})).build();
            } else {
                response = Response.noContent().build();
            }
        }
        catch (Exception ex) {
            response = Response.serverError().build();
        }
        return response;
    }
}

