/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar;

import java.io.InputStream;
import javax.ws.rs.Consumes;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.gcube.keycloak.avatar.AbstractAvatarResource;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.jboss.resteasy.plugins.providers.multipart.MultipartFormDataInput;
import org.keycloak.common.ClientConnection;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class AvatarAdminResource
extends AbstractAvatarResource {
    @Context
    private AvatarStorageProvider avatarStorageProvider;
    @Context
    private HttpHeaders httpHeaders;
    @Context
    private ClientConnection clientConnection;

    public AvatarAdminResource(KeycloakSession session) {
        super(session);
    }

    public void init() {
        this.checkRealmAdmin();
    }

    @GET
    @Path(value="/{user_id}")
    @Produces(value={"image/png", "image/jpeg", "image/gif"})
    public Response downloadUserAvatarImage(@PathParam(value="user_id") String userId) {
        try {
            UserModel user = this.session.users().getUserById(this.session.getContext().getRealm(), userId);
            return this.fetchAndCreateResponse(this.session.getContext().getRealm(), user);
        }
        catch (ForbiddenException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.error((Object)"error getting user avatar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @NoCache
    @Path(value="/{user_id}")
    @Consumes(value={"multipart/form-data"})
    public Response uploadUserAvatarImage(@PathParam(value="user_id") String userId, MultipartFormDataInput input) {
        try {
            if (this.auth == null) {
                return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            }
            RealmModel realm = this.session.getContext().getRealm();
            UserModel user = this.session.users().getUserById(this.session.getContext().getRealm(), userId);
            InputStream imageInputStream = (InputStream)input.getFormDataPart("image", InputStream.class, null);
            this.saveUserImage(realm, user, imageInputStream);
        }
        catch (ForbiddenException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)e.getMessage()).build();
        }
        catch (Exception e) {
            logger.error((Object)"error saving user avatar", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
        return Response.ok().build();
    }

    private void checkRealmAdmin() {
        if (this.auth == null) {
            throw new NotAuthorizedException((Object)"Bearer", new Object[0]);
        }
        if (this.auth.getToken().getRealmAccess() == null || !this.auth.getToken().getRealmAccess().isUserInRole("admin")) {
            throw new ForbiddenException("Does not have realm admin role");
        }
    }
}

