/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.keycloak.avatar.storage.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gcube.keycloak.avatar.storage.AvatarStorageProvider;
import org.gcube.keycloak.avatar.storage.file.FileAvatarStorageProviderFactory;
import org.jboss.logging.Logger;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class FileAvatarStorageProvider
implements AvatarStorageProvider {
    private static final Logger logger = Logger.getLogger(FileAvatarStorageProvider.class);
    private final File avatarFolder;
    private final Boolean useEmailAsFilename;

    public FileAvatarStorageProvider() {
        this(FileAvatarStorageProviderFactory.DEFAULT_AVATAR_FOLDER, FileAvatarStorageProviderFactory.USE_EMAIL_AS_FILENAME_DEFAULT);
    }

    public FileAvatarStorageProvider(String avatarFolder, Boolean useEmailAsFilename) {
        this.avatarFolder = new File(avatarFolder);
        this.useEmailAsFilename = useEmailAsFilename;
        if (!this.avatarFolder.exists()) {
            logger.infof("Creating avatar folder: %s", (Object)this.avatarFolder.getAbsolutePath());
            this.avatarFolder.mkdir();
        }
    }

    public void saveAvatarImage(RealmModel realm, UserModel user, InputStream input) {
        this.checkRealmFolderExistence(realm.getName());
        File avatarFile = this.getAvatarFile(realm, user);
        logger.debugf("Saving new avatar file for user %s, file path is: %s", (Object)user.getUsername(), (Object)avatarFile.getAbsolutePath());
        if (!avatarFile.exists()) {
            try {
                avatarFile.createNewFile();
            }
            catch (IOException e) {
                logger.error((Object)"Cannot create new avater file", (Throwable)e);
            }
        }
        try (FileOutputStream fos = new FileOutputStream(avatarFile);){
            IOUtils.copy((InputStream)input, (OutputStream)fos);
        }
        catch (IOException e) {
            logger.error((Object)"Cannot save avatar stream into file", (Throwable)e);
        }
    }

    private void checkRealmFolderExistence(String realmName) {
        File realmFile = new File(this.avatarFolder, realmName);
        if (!realmFile.exists()) {
            logger.infof("Creating avatar folder for realm '%s' in %s", (Object)realmName, (Object)realmFile.getAbsolutePath());
            realmFile.mkdir();
        }
    }

    public InputStream loadAvatarImage(RealmModel realm, UserModel user) {
        this.checkRealmFolderExistence(realm.getName());
        File avatarFile = this.getAvatarFile(realm, user);
        if (avatarFile.exists()) {
            logger.debugf("Loading avatar file for user %s, file path is: %s", (Object)user.getUsername(), (Object)avatarFile.getAbsolutePath());
        } else {
            logger.debugf("Avatar file not found for user %s", (Object)user.getUsername());
        }
        try {
            return new FileInputStream(avatarFile);
        }
        catch (FileNotFoundException e) {
            logger.debugf("Avatar file not found for user '%s' in realm '%s'", (Object)user.getUsername(), (Object)realm.getName());
            return null;
        }
    }

    private File getAvatarFile(RealmModel realm, UserModel user) {
        return new File(new File(this.avatarFolder, realm.getName()), this.useEmailAsFilename != false ? user.getEmail() : user.getUsername());
    }

    public void deleteAvatarImage(RealmModel realm, UserModel user) {
        this.checkRealmFolderExistence(realm.getName());
        File avatarFile = this.getAvatarFile(realm, user);
        if (avatarFile.exists()) {
            logger.debugf("Deleting avatar file for user %s, file path is: %s", (Object)user.getUsername(), (Object)avatarFile.getAbsolutePath());
            avatarFile.delete();
        } else {
            logger.debugf("Avatar file to delete not found for user %s", (Object)user.getUsername());
        }
    }

    public void close() {
    }
}

