/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.test;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.workflow.adaptor.WorkflowJDLAdaptor;
import gr.uoa.di.madgik.workflow.adaptor.utils.IOutputResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AdaptorJDLResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AttachedJDLResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.OutputSandboxJDLResource;
import gr.uoa.di.madgik.workflow.test.FileInfo;
import gr.uoa.di.madgik.workflow.test.TestAdaptorBase;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import java.util.UUID;
import java.util.logging.Level;

public class TestJDLAdaptor
extends TestAdaptorBase
implements Observer {
    private static HashMap<String, String> ParseResourceFile(String file) throws Exception {
        String line;
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("Specified resource file (" + file + ") not found");
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        HashMap<String, String> res = new HashMap<String, String>();
        while ((line = r.readLine()) != null) {
            String[] parts = line.trim().split("\\s:\\s");
            if (parts.length != 2) continue;
            res.put(parts[0].trim(), parts[1].trim());
        }
        return res;
    }

    private static HashMap<String, FileInfo> ParseFileResourceFile(String file) throws Exception {
        String line;
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("Specified resource file (" + file + ") not found");
        }
        BufferedReader r = new BufferedReader(new FileReader(f));
        HashMap<String, FileInfo> res = new HashMap<String, FileInfo>();
        while ((line = r.readLine()) != null) {
            String[] parts = line.trim().split("\\s:\\s");
            if (parts.length != 3) continue;
            FileInfo nfo = new FileInfo();
            nfo.TypeOfLocation = FileInfo.LocationType.valueOf(parts[1].trim().toLowerCase());
            nfo.Value = parts[2];
            res.put(parts[0].trim(), nfo);
        }
        return res;
    }

    private static FileInfo ParseGlobalOutputStoreMode(String file) throws Exception {
        String line;
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("Specified resource file (" + file + ") not found");
        }
        FileInfo nfo = null;
        BufferedReader r = new BufferedReader(new FileReader(f));
        while ((line = r.readLine()) != null) {
            String[] parts = line.trim().split("\\s:\\s");
            if (parts.length != 2 && parts.length != 5 || !parts[0].trim().equalsIgnoreCase("outputStoreMode")) continue;
            nfo = new FileInfo();
            if (parts.length == 2 && parts[1].trim().equals((Object)FileInfo.LocationType.ss)) {
                nfo.TypeOfLocation = FileInfo.LocationType.ss;
                continue;
            }
            nfo.TypeOfLocation = FileInfo.LocationType.valueOf(parts[3].trim());
            if (!nfo.TypeOfLocation.equals((Object)FileInfo.LocationType.url)) continue;
            if (parts.length == 4) {
                nfo.Value = parts[3].trim();
                continue;
            }
            if (!parts[3].trim().startsWith("ftp://")) continue;
            nfo.Value = "ftp://" + parts[4].trim() + ":" + parts[5].trim() + "@" + parts[3].trim();
        }
        if (nfo == null) {
            nfo = new FileInfo();
            nfo.TypeOfLocation = FileInfo.LocationType.ss;
        }
        return nfo;
    }

    private static HashMap<String, FileInfo> ParseInData(String file) throws Exception {
        String line;
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("Specified resource file (" + file + ") not found");
        }
        HashMap<String, FileInfo> resource = new HashMap<String, FileInfo>();
        BufferedReader r = new BufferedReader(new FileReader(f));
        while ((line = r.readLine()) != null) {
            String[] parts = line.trim().split("\\s:\\s");
            if (parts.length != 4) continue;
            FileInfo nfo = new FileInfo();
            nfo.TypeOfLocation = FileInfo.LocationType.valueOf(parts[3].trim());
            nfo.Value = parts[2].trim();
            if (!parts[0].trim().equalsIgnoreCase("inData")) continue;
            resource.put(parts[1].trim(), nfo);
        }
        return resource;
    }

    private static HashMap<String, FileInfo> ParseOutData(String file, FileInfo globalOutputStoreMode) throws Exception {
        String line;
        File f = new File(file);
        if (!f.exists() || !f.isFile()) {
            throw new Exception("Specified resource file (" + file + ") not found");
        }
        HashMap<String, FileInfo> resource = new HashMap<String, FileInfo>();
        BufferedReader r = new BufferedReader(new FileReader(f));
        while ((line = r.readLine()) != null) {
            String[] parts = line.trim().split("\\s:\\s");
            if (parts.length < 2) continue;
            FileInfo nfo = null;
            if (parts.length == 2 && globalOutputStoreMode != null) {
                nfo = new FileInfo();
                nfo.TypeOfLocation = globalOutputStoreMode.TypeOfLocation;
                nfo.Value = globalOutputStoreMode.Value;
            }
            if (parts.length == 3 && parts[2].equals((Object)FileInfo.LocationType.ss)) {
                nfo = new FileInfo();
                nfo.TypeOfLocation = FileInfo.LocationType.ss;
            } else if (parts.length > 3) {
                nfo = new FileInfo();
                nfo.TypeOfLocation = FileInfo.LocationType.valueOf(parts[3].trim());
            }
            if (nfo.TypeOfLocation.equals((Object)FileInfo.LocationType.url)) {
                if (parts.length != 4 && parts.length != 6) continue;
                if (parts.length == 4) {
                    nfo.Value = parts[3].trim();
                } else if (parts[3].trim().startsWith("ftp://")) {
                    nfo.Value = "ftp://" + parts[4].trim() + ":" + parts[5].trim() + "@" + parts[3].trim().substring("ftp://".length());
                }
            }
            if (!parts[0].trim().equalsIgnoreCase("outData")) continue;
            resource.put(parts[1].trim(), nfo);
        }
        ArrayList defaultInfo = new ArrayList();
        for (Map.Entry outData : resource.entrySet()) {
            if (outData.getValue() != null) continue;
            defaultInfo.add(outData.getKey());
        }
        for (String d : defaultInfo) {
            FileInfo nfo = new FileInfo();
            nfo.TypeOfLocation = FileInfo.LocationType.ss;
            resource.put(d, nfo);
        }
        return resource;
    }

    private static void PrintHelp() {
        StringBuilder buf = new StringBuilder();
        buf.append("Usage:\n");
        buf.append("Four arguments are needed\n");
        buf.append("1) first the hostname of the machine that is running this code through which it can be reached\n");
        buf.append("2) a port that can be used by the tcp server or <=0 to use a random one\n");
        buf.append("3) the path of the resource file. The syntax of the resource file is the following:\n");
        buf.append("\tscope : <the scope to use in case of a gcube environment>\n");
        buf.append("\tjdl : <path to the jdl file>\n");
        buf.append("\tchokeProgressEvents : <true | false> (depending on whether you want to omit progress reporting)\n");
        buf.append("\tchokePerformanceEvents : <true | false> (depending on whether you want to omit performance reporting)\n");
        buf.append("\tstorePlans : <true | false> (depending on whether you want the plan created and the final one to be stored for inspection)\n");
        buf.append("\t<name of resource as mentioned in jdl> : <the path where this resource is stored in the local filesystem>\n");
        buf.append("\t<name of resource as mentioned in jdl> : <the path where this resource is stored in the local filesystem>\n");
        buf.append("\t[...]");
        buf.append("4) <ftp | gcube> depending on the targeted infrastructure\n");
        System.out.println(buf.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Object type;
        if (args.length != 4) {
            TestJDLAdaptor.PrintHelp();
            return;
        }
        String hostName = args[0];
        int port = Integer.parseInt(args[1]);
        TestJDLAdaptor.Init(hostName, port, args[3]);
        HashMap<String, String> resources = TestJDLAdaptor.ParseResourceFile(args[2]);
        FileInfo globalOutputStoreMode = TestJDLAdaptor.ParseGlobalOutputStoreMode(args[2]);
        HashMap<String, FileInfo> inDataResources = TestJDLAdaptor.ParseInData(args[2]);
        HashMap<String, FileInfo> outDataResources = TestJDLAdaptor.ParseOutData(args[2], globalOutputStoreMode);
        AdaptorJDLResources attachedResources = new AdaptorJDLResources();
        for (Map.Entry<String, String> entry : resources.entrySet()) {
            if (!entry.getKey().equals("jdl") && !entry.getKey().equals("chokeProgressEvents") && !entry.getKey().equals("chokePerformanceEvents") && !entry.getKey().equals("storePlans") && !entry.getKey().equals("scope")) continue;
        }
        if (!resources.containsKey("jdl")) {
            throw new Exception("no jdl attribute specified");
        }
        if (!resources.containsKey("chokeProgressEvents")) {
            throw new Exception("no chokeProgressEvents attribute specified");
        }
        if (!resources.containsKey("chokePerformanceEvents")) {
            throw new Exception("no chokePerformanceEvents attribute specified");
        }
        if (!resources.containsKey("storePlans")) {
            throw new Exception("no chokePerformanceEvents attribute specified");
        }
        for (Map.Entry<String, Object> entry : inDataResources.entrySet()) {
            type = null;
            switch (((FileInfo)entry.getValue()).TypeOfLocation) {
                case local: {
                    type = AttachedJDLResource.AttachedResourceType.LocalFile;
                    break;
                }
                case ss: {
                    type = AttachedJDLResource.AttachedResourceType.CMSReference;
                    break;
                }
                case url: {
                    type = AttachedJDLResource.AttachedResourceType.Reference;
                }
            }
            attachedResources.Resources.add(new AttachedJDLResource(entry.getKey(), AttachedJDLResource.ResourceType.InData, ((FileInfo)entry.getValue()).Value, (AttachedJDLResource.AttachedResourceType)((Object)type)));
        }
        for (Map.Entry<String, Object> entry : outDataResources.entrySet()) {
            type = null;
            switch (((FileInfo)entry.getValue()).TypeOfLocation) {
                case ss: {
                    type = AttachedJDLResource.AttachedResourceType.CMSReference;
                    break;
                }
                case url: {
                    type = AttachedJDLResource.AttachedResourceType.Reference;
                }
            }
            attachedResources.Resources.add(new AttachedJDLResource(entry.getKey(), AttachedJDLResource.ResourceType.OutData, ((FileInfo)entry.getValue()).Value, (AttachedJDLResource.AttachedResourceType)((Object)type)));
        }
        WorkflowJDLAdaptor adaptor = new WorkflowJDLAdaptor();
        if (resources.containsKey("scope")) {
            adaptor.ConstructEnvironmentHints(resources.get("scope"));
        }
        adaptor.SetAdaptorResources(attachedResources);
        adaptor.SetJDL(new File(resources.get("jdl")));
        adaptor.CreatePlan();
        adaptor.GetCreatedPlan().Config.ChokeProgressReporting = Boolean.parseBoolean(resources.get("chokeProgressEvents"));
        adaptor.GetCreatedPlan().Config.ChokePerformanceReporting = Boolean.parseBoolean(resources.get("chokePerformanceEvents"));
        if (Boolean.parseBoolean(resources.get("storePlans"))) {
            File file = File.createTempFile(UUID.randomUUID().toString(), ".test.jdl.adaptor.original.plan.xml");
            XMLUtils.Serialize((String)file.toString(), (String)adaptor.GetCreatedPlan().Serialize());
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Initial plan is stored at " + file.toString());
            }
        }
        Handle = ExecutionEngine.Submit((ExecutionPlan)adaptor.GetCreatedPlan());
        TestJDLAdaptor testJDLAdaptor = new TestJDLAdaptor();
        Handle.RegisterObserver((Observer)testJDLAdaptor);
        type = synchCompletion;
        synchronized (type) {
            ExecutionEngine.Execute((ExecutionHandle)Handle);
            try {
                synchCompletion.wait();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (Boolean.parseBoolean(resources.get("storePlans"))) {
            File tmp = File.createTempFile(UUID.randomUUID().toString(), ".test.jdl.adaptor.final.plan.xml");
            XMLUtils.Serialize((String)tmp.toString(), (String)adaptor.GetCreatedPlan().Serialize());
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Final plan is stored at " + tmp.toString());
            }
        }
        TestJDLAdaptor.EvaluateResult();
        for (IOutputResource res : adaptor.GetOutput()) {
            if (!(res instanceof OutputSandboxJDLResource)) {
                throw new Exception("Different type found");
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "Output file of node " + ((OutputSandboxJDLResource)res).NodeName + " with jdl name : " + ((OutputSandboxJDLResource)res).SandboxName + " is stored at " + TestJDLAdaptor.GetStoredFilePayload(((OutputSandboxJDLResource)res).VariableID, "jdl"));
        }
    }
}

