/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.workflow.adaptor;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPServerNozzleConfig;
import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import gr.uoa.di.madgik.commons.infra.nodeselection.lru.LRUNodeSelector;
import gr.uoa.di.madgik.environment.exception.EnvironmentInformationSystemException;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.environment.infra.NodeInfo2HostingNodeAdapter;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.execution.datatype.DataTypeString;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.plan.ExecutionPlan;
import gr.uoa.di.madgik.execution.plan.PlanConfig;
import gr.uoa.di.madgik.execution.plan.element.BagPlanElement;
import gr.uoa.di.madgik.execution.plan.element.BoundaryPlanElement;
import gr.uoa.di.madgik.execution.plan.element.FileTransferPlanElement;
import gr.uoa.di.madgik.execution.plan.element.FlowPlanElement;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.SequencePlanElement;
import gr.uoa.di.madgik.execution.plan.element.ShellPlanElement;
import gr.uoa.di.madgik.execution.plan.element.TryCatchFinallyPlanElement;
import gr.uoa.di.madgik.execution.plan.element.condition.BagConditionalElement;
import gr.uoa.di.madgik.execution.plan.element.condition.BagElementDependencyPlanCondition;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTree;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTreeLeaf;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyReactionRetry;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.invocable.BoundaryConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.simple.AttributedInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleInOutParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleInParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.SimpleOutParameter;
import gr.uoa.di.madgik.execution.plan.trycatchfinally.CatchElement;
import gr.uoa.di.madgik.execution.utils.BoundaryIsolationInfo;
import gr.uoa.di.madgik.execution.utils.EnvironmentKeyValue;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.workflow.adaptor.IWorkflowAdaptor;
import gr.uoa.di.madgik.workflow.adaptor.utils.IAdaptorResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.IOutputResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.IParsedInfo;
import gr.uoa.di.madgik.workflow.adaptor.utils.IWorkflowParser;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AdaptorJDLResources;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.AttachedJDLResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLParser;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.JDLParsingUtils;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.OutputSandboxJDLResource;
import gr.uoa.di.madgik.workflow.adaptor.utils.jdl.ParsedJDLInfo;
import gr.uoa.di.madgik.workflow.exception.WorkflowEnvironmentException;
import gr.uoa.di.madgik.workflow.exception.WorkflowInternalErrorException;
import gr.uoa.di.madgik.workflow.exception.WorkflowSerializationException;
import gr.uoa.di.madgik.workflow.exception.WorkflowValidationException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WorkflowJDLAdaptor
implements IWorkflowAdaptor {
    private static Logger logger = Logger.getLogger(WorkflowJDLAdaptor.class.getName());
    private IWorkflowParser Parser = null;
    private AdaptorJDLResources Resources = null;
    private ExecutionPlan Plan = null;
    private String ExecutionId = null;
    private Set<IOutputResource> OutputResources = null;
    private File JDLFile = null;
    private String JDLDescription = null;
    private EnvHintCollection Hints = new EnvHintCollection();
    private HashMap<String, HashSet<FileTransferPlanElement>> Staging = new HashMap();
    private NodeSelector NodeSelector = new LRUNodeSelector();

    public WorkflowJDLAdaptor() {
        this.Parser = new JDLParser();
        this.OutputResources = new HashSet<IOutputResource>();
    }

    @Override
    public void SetAdaptorResources(IAdaptorResources Resources) throws WorkflowValidationException {
        if (!(Resources instanceof AdaptorJDLResources)) {
            throw new WorkflowValidationException("Invalid adaptor resources provided");
        }
        this.Resources = (AdaptorJDLResources)Resources;
    }

    public void SetJDL(File jdlFile) {
        this.JDLFile = jdlFile;
    }

    public void SetJDL(String jdlDescription) {
        this.JDLDescription = jdlDescription;
    }

    @Override
    public void SetExecutionId(String executionId) {
        this.ExecutionId = executionId;
    }

    @Override
    public void CreatePlan() throws WorkflowValidationException, WorkflowSerializationException, WorkflowInternalErrorException, WorkflowEnvironmentException {
        if (this.Resources == null) {
            throw new WorkflowValidationException("No resources specified");
        }
        if (this.JDLFile != null) {
            this.Parser.Parse(this.JDLFile);
        } else if (this.JDLDescription != null) {
            this.Parser.Parse(this.JDLDescription);
        } else {
            throw new WorkflowValidationException("No jdl specified");
        }
        this.ConstructWorkflow();
        this.ExcludeOutputResourcesCleanUp();
    }

    private void ExcludeOutputResourcesCleanUp() {
        for (IOutputResource res : this.OutputResources) {
            if (!(res instanceof OutputSandboxJDLResource)) continue;
            this.Plan.CleanUpSSExclude.Add(((OutputSandboxJDLResource)res).VariableID);
        }
    }

    public void ConstructEnvironmentHints(String Scope) {
        if (Scope != null) {
            this.Hints.AddHint(new NamedEnvHint("GCubeActionScope", new EnvHint(Scope)));
        }
    }

    @Override
    public ExecutionPlan GetCreatedPlan() {
        return this.Plan;
    }

    @Override
    public Set<IOutputResource> GetOutput() {
        return this.OutputResources;
    }

    private void ValidateParsedInfo(ParsedJDLInfo internal) throws WorkflowValidationException {
        if (internal.jobDescriptionType.equals((Object)ParsedJDLInfo.JobDescriptionType.Job) && !internal.jobType.equals((Object)ParsedJDLInfo.JobType.Normal)) {
            throw new WorkflowValidationException("Only Normal JobType attribute supported");
        }
        if (internal.jobDescriptionType.equals((Object)ParsedJDLInfo.JobDescriptionType.DAG) && internal.Nodes.size() == 0) {
            throw new WorkflowValidationException("No node defined for DAG job");
        }
        if (internal.jobDescriptionType.equals((Object)ParsedJDLInfo.JobDescriptionType.DAG)) {
            for (Map.Entry entry : internal.Nodes.entrySet()) {
                if (!((ParsedJDLInfo)entry.getValue()).jobDescriptionType.equals((Object)ParsedJDLInfo.JobDescriptionType.Job)) {
                    throw new WorkflowValidationException("Only Job Type attribute supported for DAG nodes");
                }
                if (((ParsedJDLInfo)entry.getValue()).jobType.equals((Object)ParsedJDLInfo.JobType.Normal)) continue;
                throw new WorkflowValidationException("Only Normal JobType attribute supported for DAG nodes");
            }
            for (Map.Entry entry : internal.Dependencies.entrySet()) {
                if (internal.Nodes.containsKey(entry.getKey())) continue;
                throw new WorkflowValidationException("Dependency defined for non existing node " + (String)entry.getKey());
            }
        }
        for (String string : internal.InSandbox) {
            if (JDLParsingUtils.IsSandboxNameReference(string) || this.Resources.ResourceExists(string)) continue;
            throw new WorkflowValidationException("Resource with key " + string + " not attached");
        }
    }

    private void ConstructWorkflow() throws WorkflowInternalErrorException, WorkflowValidationException, WorkflowEnvironmentException {
        IParsedInfo tmpinfo = this.Parser.GetParsedInfo();
        if (!(tmpinfo instanceof ParsedJDLInfo)) {
            throw new WorkflowInternalErrorException("Unexpected internal plan type");
        }
        ParsedJDLInfo internal = (ParsedJDLInfo)tmpinfo;
        this.ValidateParsedInfo(internal);
        try {
            this.Resources.StoreResources(this.Hints);
        }
        catch (Exception ex) {
            throw new WorkflowEnvironmentException("Could not store resources in storage system", ex);
        }
        this.Plan = new ExecutionPlan();
        this.Plan.Config.ConcurrentActionsPerBoundary = internal.MaxRunningNodes;
        this.Plan.Config.RestrictActionTypes.clear();
        this.Plan.Config.RestrictActionTypes.add(IPlanElement.PlanElementType.Boundary);
        this.Plan.Config.ConnectionCallbackTimeout = 86400000L;
        this.Plan.Config.ModeOfConnection = PlanConfig.ConnectionMode.Callback;
        this.Plan.Config.ModeOfConnection = internal.ModeOfConnection;
        this.Plan.EnvHints = this.Hints;
        switch (internal.jobDescriptionType) {
            case Job: {
                SequencePlanElement seq = new SequencePlanElement();
                this.Plan.Root = seq;
                seq.ElementCollection.add(this.ConstructJobFlow(internal, null, null, null));
                break;
            }
            case DAG: {
                BoundaryConfig bConfig = null;
                if (internal.NodesCollocation) {
                    bConfig = this.GetBoundaryConfig(internal.Rank, internal.Requirements, null);
                }
                switch (internal.ModeOfParsing) {
                    case Plan: {
                        this.Plan.Root = this.ConstructDAGPlanFlow(internal, bConfig);
                        break;
                    }
                    case Bag: {
                        this.Plan.Root = this.ConstructDAGBagFlow(internal, bConfig);
                        break;
                    }
                    default: {
                        throw new WorkflowValidationException("Unrecognized parsing mode");
                    }
                }
                this.ConnectIntermediateStaging(internal);
                break;
            }
            default: {
                throw new WorkflowValidationException("Unrecognized job description type");
            }
        }
    }

    private List<HostingNode> PrepareMatchmaking(ParsedJDLInfo internal) throws WorkflowEnvironmentException {
        try {
            String commonRequirements = internal.GetCommonRequirements();
            int commonMatches = 0;
            for (String node : internal.Nodes.keySet()) {
                if (!internal.GetExtraRequirements(node).trim().equals("")) continue;
                ++commonMatches;
            }
            if (commonMatches > 1) {
                logger.log(Level.FINE, "Common requirement matchmaking: matches=" + commonMatches + " common requirements=" + commonRequirements);
                List matchingNodes = InformationSystem.GetMatchingNodes((String)internal.Rank, (String)commonRequirements, (EnvHintCollection)this.Hints);
                return new NodeInfo2HostingNodeAdapter().adaptAll(matchingNodes);
            }
            return null;
        }
        catch (Exception ex) {
            throw new WorkflowEnvironmentException("Could not prepare matchmaking", ex);
        }
    }

    private BagPlanElement ConstructDAGBagFlow(ParsedJDLInfo internal, BoundaryConfig bConfig) throws WorkflowEnvironmentException, WorkflowValidationException {
        BagPlanElement bag = new BagPlanElement();
        bag.TerminationCondition = null;
        bag.TerminateOnNoProgress = true;
        List<HostingNode> matchmaked = this.PrepareMatchmaking(internal);
        for (Map.Entry<String, ParsedJDLInfo> nfo : internal.Nodes.entrySet()) {
            List<HostingNode> nodeMatchmaked = null;
            if (internal.GetExtraRequirements(nfo.getKey()).equals("")) {
                nodeMatchmaked = matchmaked;
            }
            BagConditionalElement elem = new BagConditionalElement();
            elem.Executed = false;
            elem.Element = this.ConstructJobFlow(nfo.getValue(), bConfig, nodeMatchmaked, nfo.getKey());
            if (internal.Dependencies.containsKey(nfo.getKey())) {
                elem.Condition = new ConditionTree();
                elem.Condition.Root = new ConditionTreeLeaf();
                ((ConditionTreeLeaf)elem.Condition.Root).Condition = new BagElementDependencyPlanCondition();
                for (String dep : internal.Dependencies.get(nfo.getKey())) {
                    ((BagElementDependencyPlanCondition)((ConditionTreeLeaf)elem.Condition.Root).Condition).DependsOn.add(dep);
                }
            } else {
                elem.Condition = null;
            }
            bag.ElementCollection.put(nfo.getKey(), elem);
        }
        return bag;
    }

    private SequencePlanElement ConstructDAGPlanFlow(ParsedJDLInfo internal, BoundaryConfig bConfig) throws WorkflowEnvironmentException, WorkflowValidationException {
        SequencePlanElement seq = new SequencePlanElement();
        ArrayList<ArrayList<String>> levels = this.CreateDependencyGraph(internal.Nodes, internal.Dependencies);
        List<HostingNode> matchmaked = this.PrepareMatchmaking(internal);
        for (ArrayList<String> level : levels) {
            StringBuilder buf = new StringBuilder();
            FlowPlanElement flw = null;
            if (level.size() > 1) {
                flw = new FlowPlanElement();
            }
            for (String l : level) {
                buf.append(l + " ");
                List<HostingNode> nodeMatchmaked = null;
                if (internal.GetExtraRequirements(l).equals("")) {
                    nodeMatchmaked = matchmaked;
                }
                if (flw != null) {
                    flw.ElementCollection.add(this.ConstructJobFlow(internal.Nodes.get(l), bConfig, nodeMatchmaked, l));
                    continue;
                }
                seq.ElementCollection.add(this.ConstructJobFlow(internal.Nodes.get(l), bConfig, nodeMatchmaked, l));
            }
            if (flw != null) {
                seq.ElementCollection.add(flw);
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            logger.log(Level.FINE, buf.toString());
        }
        return seq;
    }

    private ArrayList<ArrayList<String>> CreateDependencyGraph(Map<String, ParsedJDLInfo> Nodes, Map<String, List<String>> Dependencies) throws WorkflowValidationException {
        HashSet CanRun = new HashSet();
        HashSet<String> LevelCanRun = new HashSet<String>();
        ArrayList<ArrayList<String>> levels = new ArrayList<ArrayList<String>>();
        while (CanRun.size() < Nodes.size()) {
            ArrayList<String> level = new ArrayList<String>();
            for (Map.Entry<String, ParsedJDLInfo> node : Nodes.entrySet()) {
                if (CanRun.contains(node.getKey())) continue;
                if (!Dependencies.containsKey(node.getKey())) {
                    LevelCanRun.add(node.getKey());
                    level.add(node.getKey());
                    continue;
                }
                boolean DepsDone = true;
                for (String dep : Dependencies.get(node.getKey())) {
                    if (CanRun.contains(dep)) continue;
                    DepsDone = false;
                    break;
                }
                if (!DepsDone) continue;
                LevelCanRun.add(node.getKey());
                level.add(node.getKey());
            }
            CanRun.addAll(LevelCanRun);
            LevelCanRun.clear();
            levels.add(level);
            if (level.size() != 0) continue;
            throw new WorkflowValidationException("Cannot determine graph execution order");
        }
        return levels;
    }

    private BoundaryPlanElement ConstructJobFlow(ParsedJDLInfo internal, BoundaryConfig bConfig, List<HostingNode> matchmaked, String NodeName) throws WorkflowEnvironmentException, WorkflowValidationException {
        BoundaryPlanElement boundaryElement = new BoundaryPlanElement();
        boundaryElement.SetName(NodeName);
        boundaryElement.Isolation = new BoundaryIsolationInfo();
        boundaryElement.Isolation.CleanUp = true;
        boundaryElement.Isolation.Isolate = true;
        boundaryElement.Isolation.BaseDir = new SimpleInOutParameter();
        NamedDataType ndtIsolationBaseDirParameter = new NamedDataType();
        ndtIsolationBaseDirParameter.IsAvailable = false;
        ndtIsolationBaseDirParameter.Name = UUID.randomUUID().toString();
        logger.log(Level.FINE, "Boundary isolation dir is " + ndtIsolationBaseDirParameter.Name);
        ndtIsolationBaseDirParameter.Token = ndtIsolationBaseDirParameter.Name;
        ndtIsolationBaseDirParameter.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtIsolationBaseDirParameter);
        ((SimpleInOutParameter)boundaryElement.Isolation.BaseDir).VariableName = ndtIsolationBaseDirParameter.Name;
        boundaryElement.Config = bConfig != null ? bConfig : this.GetBoundaryConfig(internal.Rank, internal.Requirements, matchmaked);
        SequencePlanElement seqRemote = new SequencePlanElement();
        boundaryElement.Root = seqRemote;
        for (AttachedJDLResource att : this.Resources.Resources) {
            if (!internal.InSandbox.contains(att.Key) || att.TypeOfResource != AttachedJDLResource.ResourceType.InData) continue;
            seqRemote.ElementCollection.add(this.CreateInputSandboxRetrieveElement(att, internal));
        }
        for (String SandboxName : internal.InSandbox) {
            if (!JDLParsingUtils.IsSandboxNameReference(SandboxName)) continue;
            seqRemote.ElementCollection.add(this.CreateInternalStagingRetrieveElement(SandboxName));
        }
        TryCatchFinallyPlanElement tcf = new TryCatchFinallyPlanElement();
        seqRemote.ElementCollection.add(tcf);
        tcf.TryFlow = this.CreateExecutableElement(internal);
        tcf.CatchFlows.clear();
        tcf.FinallyFlow = new SequencePlanElement();
        FileTransferPlanElement outfts = null;
        FileTransferPlanElement errfts = null;
        ArrayList<FileTransferPlanElement> otherfts = new ArrayList<FileTransferPlanElement>();
        int count = 0;
        for (String outbox : internal.OutSandbox) {
            if (internal.Output != null && internal.Output.equals(outbox)) {
                outfts = this.CreateOutputSandboxStoreElement(outbox, NodeName, count);
                if (this.Resources.ResourceExists(outbox) && this.Resources.GetResource((String)outbox).ResourceLocationType == AttachedJDLResource.AttachedResourceType.Reference) {
                    boolean slashFound = this.Resources.GetResource((String)outbox).Value.charAt(this.Resources.GetResource((String)outbox).Value.length() - 1) == '/';
                    outfts.OutputStoreMode = FileTransferPlanElement.StoreMode.Url;
                    outfts.StoreUrlLocation = this.Resources.GetResource((String)outbox).Value + (slashFound ? "" : "/") + (this.ExecutionId != null ? this.ExecutionId + "." + (NodeName != null ? NodeName + "." : "") : "") + outbox;
                    outfts.accessInfo.port = this.Resources.GetResource((String)outbox).accessInfo.port;
                    outfts.accessInfo.userId = this.Resources.GetResource((String)outbox).accessInfo.userId;
                    outfts.accessInfo.password = this.Resources.GetResource((String)outbox).accessInfo.password;
                }
            } else if (internal.Error != null && internal.Error.equals(outbox)) {
                errfts = this.CreateOutputSandboxStoreElement(outbox, NodeName, count);
                if (this.Resources.ResourceExists(outbox) && this.Resources.GetResource((String)outbox).ResourceLocationType == AttachedJDLResource.AttachedResourceType.Reference) {
                    boolean slashFound = this.Resources.GetResource((String)outbox).Value.charAt(this.Resources.GetResource((String)outbox).Value.length() - 1) == '/';
                    errfts.OutputStoreMode = FileTransferPlanElement.StoreMode.Url;
                    errfts.StoreUrlLocation = this.Resources.GetResource((String)outbox).Value + (slashFound ? "" : "/") + (this.ExecutionId != null ? this.ExecutionId + "." + (NodeName != null ? NodeName + "." : "") : "") + outbox;
                    errfts.accessInfo.port = this.Resources.GetResource((String)outbox).accessInfo.port;
                    errfts.accessInfo.userId = this.Resources.GetResource((String)outbox).accessInfo.userId;
                    errfts.accessInfo.password = this.Resources.GetResource((String)outbox).accessInfo.password;
                }
            } else if (this.Resources.ResourceExists(outbox) && this.Resources.GetResource((String)outbox).TypeOfResource == AttachedJDLResource.ResourceType.OutData) {
                FileTransferPlanElement fts = this.CreateOutputSandboxStoreElement(outbox, NodeName, count);
                if (this.Resources.GetResource((String)outbox).ResourceLocationType == AttachedJDLResource.AttachedResourceType.Reference) {
                    fts.OutputStoreMode = FileTransferPlanElement.StoreMode.Url;
                    boolean slashFound = this.Resources.GetResource((String)outbox).Value.charAt(this.Resources.GetResource((String)outbox).Value.length() - 1) == '/';
                    fts.StoreUrlLocation = this.Resources.GetResource((String)outbox).Value + (slashFound ? "" : "/") + (this.ExecutionId != null ? this.ExecutionId + "." + (NodeName != null ? NodeName + "." : "") : "") + outbox;
                    fts.accessInfo.port = this.Resources.GetResource((String)outbox).accessInfo.port;
                    fts.accessInfo.userId = this.Resources.GetResource((String)outbox).accessInfo.userId;
                    fts.accessInfo.password = this.Resources.GetResource((String)outbox).accessInfo.password;
                }
                otherfts.add(fts);
            }
            ++count;
        }
        if (outfts != null) {
            ((SequencePlanElement)tcf.FinallyFlow).ElementCollection.add(this.ChockError((IPlanElement)outfts));
        }
        if (errfts != null) {
            ((SequencePlanElement)tcf.FinallyFlow).ElementCollection.add(this.ChockError((IPlanElement)errfts));
        }
        ArrayList<TryCatchFinallyPlanElement> chokedElements = new ArrayList<TryCatchFinallyPlanElement>();
        for (FileTransferPlanElement otherft : otherfts) {
            chokedElements.add(this.ChockError((IPlanElement)otherft));
        }
        ((SequencePlanElement)tcf.FinallyFlow).ElementCollection.addAll(chokedElements);
        if (((SequencePlanElement)tcf.FinallyFlow).ElementCollection.size() == 0) {
            tcf.FinallyFlow = null;
        }
        return boundaryElement;
    }

    private TryCatchFinallyPlanElement ChockError(IPlanElement element) {
        TryCatchFinallyPlanElement tcf = new TryCatchFinallyPlanElement();
        tcf.TryFlow = element;
        CatchElement c = new CatchElement();
        c.Error = null;
        c.Rethrow = false;
        c.Root = null;
        tcf.CatchFlows.add(c);
        tcf.FinallyFlow = null;
        return tcf;
    }

    private BoundaryConfig GetBoundaryConfig(String Rank, String Requirements, List<HostingNode> matchmaked) throws WorkflowEnvironmentException {
        NodeInfo nodeToUse = null;
        String hostname = null;
        int port = -1;
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieving matching node: Rank=" + Rank + " Requirements=" + Requirements);
            }
            if (matchmaked != null) {
                HostingNode n = this.NodeSelector.selectNode(matchmaked);
                hostname = n.getPropertyByName("hostname");
                port = Integer.parseInt(n.getPropertyByName("pe2ng.port"));
            } else {
                nodeToUse = InformationSystem.GetMatchingNode((String)Rank, (String)Requirements, (NodeSelector)this.NodeSelector, (EnvHintCollection)this.Hints);
                if (nodeToUse == null) {
                    throw new WorkflowEnvironmentException("Could not find appropriate node to host execution");
                }
                hostname = nodeToUse.getExtension("hostname");
                port = Integer.parseInt(nodeToUse.getExtension("pe2ng.port"));
            }
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Selected Execution Engine: " + hostname + ":" + port + (matchmaked != null ? " (used common requirements)" : ""));
            }
        }
        catch (EnvironmentInformationSystemException ex) {
            throw new WorkflowEnvironmentException("Could not retrieve appropriate node to host execution", ex);
        }
        BoundaryConfig Config = new BoundaryConfig();
        Config.HostName = hostname;
        Config.Port = port;
        Config.NozzleConfig = new TCPServerNozzleConfig(false, 0);
        return Config;
    }

    private FileTransferPlanElement CreateOutputSandboxStoreElement(String SandboxName, String NodeName, int SandboxIndex) throws WorkflowValidationException {
        OutputSandboxJDLResource outRes = new OutputSandboxJDLResource();
        outRes.NodeName = NodeName;
        outRes.SandboxName = SandboxName;
        outRes.SandboxIndex = SandboxIndex;
        FileTransferPlanElement ftr = new FileTransferPlanElement();
        ftr.Direction = FileTransferPlanElement.TransferDirection.Store;
        SimpleInParameter fileToStoreParameter = new SimpleInParameter();
        NamedDataType ndtFileToStoreParameter = new NamedDataType();
        ndtFileToStoreParameter.IsAvailable = true;
        ndtFileToStoreParameter.Token = ndtFileToStoreParameter.Name = UUID.randomUUID().toString();
        ndtFileToStoreParameter.Value = new DataTypeString();
        try {
            ((DataTypeString)ndtFileToStoreParameter.Value).SetValue((Object)SandboxName);
        }
        catch (Exception ex) {
            throw new WorkflowValidationException("Could not create execution plan", ex);
        }
        this.Plan.Variables.Add(ndtFileToStoreParameter);
        fileToStoreParameter.VariableName = ndtFileToStoreParameter.Name;
        ftr.Input = fileToStoreParameter;
        SimpleOutParameter fileStoredParameter = new SimpleOutParameter();
        NamedDataType ndtFileStoredParameter = new NamedDataType();
        ndtFileStoredParameter.IsAvailable = false;
        ndtFileStoredParameter.Name = UUID.randomUUID().toString();
        ndtFileStoredParameter.Token = SandboxName;
        ndtFileStoredParameter.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtFileStoredParameter);
        outRes.VariableID = ndtFileStoredParameter.Name;
        outRes.VariableID = ndtFileStoredParameter.Name;
        fileStoredParameter.VariableName = ndtFileStoredParameter.Name;
        ftr.Output = fileStoredParameter;
        ftr.IsExecutable = false;
        ftr.MoveTo = null;
        this.OutputResources.add(outRes);
        return ftr;
    }

    private ShellPlanElement CreateExecutableElement(ParsedJDLInfo internal) throws WorkflowValidationException {
        ShellPlanElement shell = new ShellPlanElement();
        logger.log(Level.INFO, "Shell plan element arguments: " + internal.Arguments);
        if (internal.Arguments != null) {
            String[] args;
            for (String arg : args = internal.Arguments.trim().split("\\s")) {
                SimpleInParameter argParameter = new SimpleInParameter();
                NamedDataType ndtArgParameter = new NamedDataType();
                ndtArgParameter.IsAvailable = true;
                ndtArgParameter.Token = ndtArgParameter.Name = UUID.randomUUID().toString();
                ndtArgParameter.Value = new DataTypeString();
                try {
                    ((DataTypeString)ndtArgParameter.Value).SetValue((Object)arg);
                }
                catch (Exception ex) {
                    throw new WorkflowValidationException("Could not create execution plan", ex);
                }
                argParameter.VariableName = ndtArgParameter.Name;
                this.Plan.Variables.Add(ndtArgParameter);
                shell.ArgumentParameters.add(new AttributedInputParameter((IInputParameter)argParameter));
            }
        }
        shell.Command = internal.Executable;
        if (internal.Error != null) {
            SimpleInOutParameter stdErrParameter = new SimpleInOutParameter();
            NamedDataType ndtStdErrParameter = new NamedDataType();
            ndtStdErrParameter.IsAvailable = true;
            ndtStdErrParameter.Token = ndtStdErrParameter.Name = UUID.randomUUID().toString();
            ndtStdErrParameter.Value = new DataTypeString();
            try {
                ((DataTypeString)ndtStdErrParameter.Value).SetValue((Object)internal.Error);
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Could not create execution plan", ex);
            }
            stdErrParameter.VariableName = ndtStdErrParameter.Name;
            this.Plan.Variables.Add(ndtStdErrParameter);
            shell.StdErrParameter = stdErrParameter;
            shell.StdErrIsFile = true;
        }
        SimpleOutParameter exitValueParameter = new SimpleOutParameter();
        NamedDataType ndtExitValueParameter = new NamedDataType();
        ndtExitValueParameter.IsAvailable = false;
        ndtExitValueParameter.Token = ndtExitValueParameter.Name = UUID.randomUUID().toString();
        ndtExitValueParameter.Value = new DataTypeString();
        exitValueParameter.VariableName = ndtExitValueParameter.Name;
        this.Plan.Variables.Add(ndtExitValueParameter);
        shell.StdExitValueParameter = exitValueParameter;
        if (internal.Input != null) {
            SimpleInParameter stdInParameter = new SimpleInParameter();
            NamedDataType ndtStdInParameter = new NamedDataType();
            ndtStdInParameter.IsAvailable = true;
            ndtStdInParameter.Token = ndtStdInParameter.Name = UUID.randomUUID().toString();
            ndtStdInParameter.Value = new DataTypeString();
            try {
                ((DataTypeString)ndtStdInParameter.Value).SetValue((Object)internal.Input);
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Could not create execution plan", ex);
            }
            stdInParameter.VariableName = ndtStdInParameter.Name;
            this.Plan.Variables.Add(ndtStdInParameter);
            shell.StdInParameter = stdInParameter;
            shell.StdInIsFile = true;
        }
        if (internal.Output != null) {
            SimpleInOutParameter stdOutParameter = new SimpleInOutParameter();
            NamedDataType ndtStdOutParameter = new NamedDataType();
            ndtStdOutParameter.IsAvailable = true;
            ndtStdOutParameter.Token = ndtStdOutParameter.Name = UUID.randomUUID().toString();
            ndtStdOutParameter.Value = new DataTypeString();
            try {
                ((DataTypeString)ndtStdOutParameter.Value).SetValue((Object)internal.Output);
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("Could not create execution plan", ex);
            }
            stdOutParameter.VariableName = ndtStdOutParameter.Name;
            this.Plan.Variables.Add(ndtStdOutParameter);
            shell.StdOutParameter = stdOutParameter;
            shell.StdOutIsFile = true;
        }
        shell.ExitCodeErrors.clear();
        shell.Triggers.clear();
        if (internal.RetryCount > 0) {
            ContingencyTrigger trigg = new ContingencyTrigger();
            trigg.IsFullNameOfError = false;
            trigg.TriggeringError = null;
            trigg.Reaction = new ContingencyReactionRetry();
            ((ContingencyReactionRetry)trigg.Reaction).NumberOfRetries = internal.RetryCount;
            ((ContingencyReactionRetry)trigg.Reaction).RetryInterval = internal.RetryInterval > 0L ? internal.RetryInterval : ParsedJDLInfo.DefaultRetryInterval;
            shell.Triggers.add(trigg);
        }
        shell.Environment.clear();
        for (EnvironmentKeyValue envkv : internal.Environment) {
            shell.Environment.add(envkv);
        }
        return shell;
    }

    private FileTransferPlanElement CreateInternalStagingRetrieveElement(String SandboxName) throws WorkflowValidationException {
        FileTransferPlanElement ftr = new FileTransferPlanElement();
        if (JDLParsingUtils.IsSandboxNameReference(SandboxName)) {
            if (!this.Staging.containsKey(SandboxName)) {
                this.Staging.put(SandboxName, new HashSet());
            }
            this.Staging.get(SandboxName).add(ftr);
            return ftr;
        }
        throw new WorkflowValidationException("Provided sandbox name is not of root reference");
    }

    private FileTransferPlanElement CreateInputSandboxRetrieveElement(AttachedJDLResource attachment, ParsedJDLInfo internal) throws WorkflowValidationException {
        FileTransferPlanElement ftr = new FileTransferPlanElement();
        if (JDLParsingUtils.IsSandboxNameReference(attachment.Key)) {
            throw new WorkflowValidationException("Provided sandbox name is of root reference");
        }
        ftr.Direction = FileTransferPlanElement.TransferDirection.Retrieve;
        ftr.Input = new SimpleInParameter();
        if (attachment.Key.equals(internal.Executable)) {
            ftr.IsExecutable = true;
        }
        NamedDataType ndtAttachment = new NamedDataType();
        ndtAttachment.IsAvailable = true;
        ndtAttachment.Token = ndtAttachment.Name = UUID.randomUUID().toString();
        ndtAttachment.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtAttachment);
        try {
            ((DataTypeString)ndtAttachment.Value).SetValue((Object)attachment.StorageSystemID);
        }
        catch (Exception ex) {
            throw new WorkflowValidationException("Could not create execution plan", ex);
        }
        ((SimpleInParameter)ftr.Input).VariableName = ndtAttachment.Name;
        ftr.Output = new SimpleOutParameter();
        NamedDataType ndtRetrievedAttachment = new NamedDataType();
        ndtRetrievedAttachment.IsAvailable = false;
        ndtRetrievedAttachment.Token = ndtRetrievedAttachment.Name = UUID.randomUUID().toString();
        ndtRetrievedAttachment.Value = new DataTypeString();
        this.Plan.Variables.Add(ndtRetrievedAttachment);
        ((SimpleOutParameter)ftr.Output).VariableName = ndtRetrievedAttachment.Name;
        ftr.MoveTo = new SimpleInParameter();
        NamedDataType ndtRename = new NamedDataType();
        ndtRename.IsAvailable = true;
        ndtRename.Token = ndtRename.Name = UUID.randomUUID().toString();
        ndtRename.Value = new DataTypeString();
        String RenameTo = attachment.Key;
        if (RenameTo == null || RenameTo.trim().length() == 0) {
            throw new WorkflowValidationException("Defined resource name is not valid");
        }
        try {
            ((DataTypeString)ndtRename.Value).SetValue((Object)RenameTo);
        }
        catch (Exception ex) {
            throw new WorkflowValidationException("Could not create execution plan", ex);
        }
        this.Plan.Variables.Add(ndtRename);
        ((SimpleInParameter)ftr.MoveTo).VariableName = ndtRename.Name;
        return ftr;
    }

    private void ConnectIntermediateStaging(ParsedJDLInfo internal) throws WorkflowValidationException {
        for (Map.Entry<String, HashSet<FileTransferPlanElement>> entry : this.Staging.entrySet()) {
            String nodeName = null;
            int sandboxIndex = 0;
            try {
                nodeName = entry.getKey().substring("root.nodes.".length(), entry.getKey().indexOf(".", "root.nodes.".length()));
                sandboxIndex = Integer.parseInt(entry.getKey().substring(entry.getKey().indexOf("[") + 1, entry.getKey().indexOf("]")));
            }
            catch (Exception ex) {
                throw new WorkflowValidationException("reference input sandbox element not in valid format", ex);
            }
            for (IOutputResource outres : this.OutputResources) {
                if (!((OutputSandboxJDLResource)outres).NodeName.equals(nodeName) || ((OutputSandboxJDLResource)outres).SandboxIndex != sandboxIndex) continue;
                for (FileTransferPlanElement ftr : entry.getValue()) {
                    ftr.Direction = FileTransferPlanElement.TransferDirection.Retrieve;
                    ftr.Input = new SimpleInParameter();
                    if (((OutputSandboxJDLResource)outres).SandboxName.equals(internal.Executable)) {
                        ftr.IsExecutable = true;
                    }
                    ((SimpleInParameter)ftr.Input).VariableName = ((OutputSandboxJDLResource)outres).VariableID;
                    ftr.Output = new SimpleOutParameter();
                    NamedDataType ndtRetrievedAttachment = new NamedDataType();
                    ndtRetrievedAttachment.IsAvailable = false;
                    ndtRetrievedAttachment.Token = ndtRetrievedAttachment.Name = UUID.randomUUID().toString();
                    ndtRetrievedAttachment.Value = new DataTypeString();
                    this.Plan.Variables.Add(ndtRetrievedAttachment);
                    ((SimpleOutParameter)ftr.Output).VariableName = ndtRetrievedAttachment.Name;
                    ftr.MoveTo = new SimpleInParameter();
                    NamedDataType ndtRename = new NamedDataType();
                    ndtRename.IsAvailable = true;
                    ndtRename.Token = ndtRename.Name = UUID.randomUUID().toString();
                    ndtRename.Value = new DataTypeString();
                    String RenameTo = ((OutputSandboxJDLResource)outres).SandboxName;
                    if (RenameTo == null || RenameTo.trim().length() == 0) {
                        throw new WorkflowValidationException("Defined resource name is not valid");
                    }
                    try {
                        ((DataTypeString)ndtRename.Value).SetValue((Object)RenameTo);
                    }
                    catch (Exception ex) {
                        throw new WorkflowValidationException("Could not create execution plan", ex);
                    }
                    this.Plan.Variables.Add(ndtRename);
                    ((SimpleInParameter)ftr.MoveTo).VariableName = ndtRename.Name;
                }
            }
        }
    }
}

