/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.urlresolutionlibrary.streamable;

import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.LocatorException;
import gr.uoa.di.madgik.urlresolutionlibrary.exceptions.ParseException;
import gr.uoa.di.madgik.urlresolutionlibrary.streamable.Streamable;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPSClient;

public class FTPLocator
implements Streamable {
    private static Logger logger = Logger.getLogger(FTPLocator.class.getName());
    public static final String FTP_PROTOCOL = "ftp";
    public static final String FTPS_PROTOCOL = "ftps";
    private static final String ANONYMOUS_USERNAME = "anonymous";
    private static final String ANONYMOUS_PASSWORD = "";
    private static final int DEFAULT_FTP_PORT = 21;
    private static final int DEFAULT_FTPS_PORT = 22;
    private static final int FTP_OK_REPLYCODE = 230;
    private int port = 21;
    private String username = "anonymous";
    private String password = "";
    private boolean isSecure = false;
    private String host;
    private String path;
    private InputStream is;
    private FTPClient ftpClient = null;

    public FTPLocator(String url) throws ParseException {
        this.parseURL(url);
    }

    private void parseURL(String url) throws ParseException {
        String[] parts;
        String tmpUrl = url.trim();
        if (!tmpUrl.startsWith("ftp://")) {
            if (!tmpUrl.startsWith("ftps://")) {
                throw new ParseException("url is not in ftp(s) format");
            }
            this.isSecure = true;
            this.port = 22;
        }
        if ((tmpUrl = this.isSecure ? tmpUrl.substring("ftps://".length()) : tmpUrl.substring("ftp://".length())).contains("@")) {
            int atIdx = tmpUrl.lastIndexOf(64);
            if (atIdx >= tmpUrl.length()) {
                throw new ParseException("url has not username and password");
            }
            String credentials = tmpUrl.substring(0, atIdx);
            String hostpath = tmpUrl.substring(atIdx + 1, tmpUrl.length());
            String[] parts2 = credentials.split(":");
            if (parts2 == null || parts2.length != 2) {
                throw new ParseException("url has not username and password");
            }
            this.username = parts2[0];
            this.password = parts2[1];
            tmpUrl = hostpath;
        }
        if ((parts = tmpUrl.split("/", 2))[0].contains(":")) {
            String[] parts1 = parts[0].split(":");
            this.host = parts1[0];
            this.port = Integer.parseInt(parts1[1]);
        } else {
            this.host = parts[0];
        }
        if (parts.length == 2) {
            this.path = parts[1];
        }
        logger.log(Level.INFO, "Parsing results for : " + url);
        logger.log(Level.INFO, "Host \t : " + this.host);
        logger.log(Level.INFO, "Port \t : " + this.port);
        logger.log(Level.INFO, "Username : " + this.username);
        logger.log(Level.INFO, "Password : " + this.password);
        logger.log(Level.INFO, "Path \t : " + this.path);
        logger.log(Level.INFO, "Secure \t : " + this.isSecure);
    }

    @Override
    public InputStream getInputStream() throws Exception {
        this.ftpClient = this.isSecure ? new FTPSClient() : new FTPClient();
        this.ftpClient.connect(this.host, this.port);
        if (!this.ftpClient.login(this.username, this.password)) {
            this.ftpClient.logout();
            throw new LocatorException("login error");
        }
        if (this.ftpClient.getReplyCode() != 230) {
            throw new LocatorException("FTP reply : " + this.ftpClient.getReplyString());
        }
        this.is = this.ftpClient.retrieveFileStream(this.path);
        return this.is;
    }

    @Override
    public void close() {
        try {
            this.ftpClient.logout();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Ftp client logout failed", e);
        }
        if (this.ftpClient.isConnected()) {
            try {
                this.ftpClient.disconnect();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Ftp client disconnect failed", e);
            }
        }
        try {
            this.is.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Ftp client input stream close failed", e);
        }
    }
}

