/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataSource
extends RRElement {
    private static final Logger logger = LoggerFactory.getLogger(DataSource.class);
    private static Map<Class<? extends DataSource>, Class<? extends DataSourceDao>> SubTypes = new HashMap<Class<? extends DataSource>, Class<? extends DataSourceDao>>();
    private static Map<Class<? extends DataSourceDao>, Class<? extends DataSource>> ReverseSubTypes = new HashMap<Class<? extends DataSourceDao>, Class<? extends DataSource>>();
    private static Map<Type, Class<? extends DataSource>> SubTypesMap = new HashMap<Type, Class<? extends DataSource>>();
    private static Map<Class<? extends DataSource>, Class<? extends DataSourceService>> Services = new HashMap<Class<? extends DataSource>, Class<? extends DataSourceService>>();
    protected DataSourceDao item = null;
    protected Set<FieldIndexContainer> fieldInfo = new HashSet<FieldIndexContainer>();
    protected List<DataSourceService> boundDataSourceServices = null;
    protected RRContext context = null;
    private Class<? extends DataSourceDao> daoType = null;
    private Class<? extends DataSourceService> serviceType = null;

    public static void clearSubTypes() {
        SubTypesMap.clear();
        SubTypes.clear();
        ReverseSubTypes.clear();
    }

    public static void addSubType(Type type, Class<? extends DataSource> ds, Class<? extends DataSourceDao> dsDao) {
        SubTypesMap.put(type, ds);
        SubTypes.put(ds, dsDao);
        ReverseSubTypes.put(dsDao, ds);
    }

    public static void addServiceType(Class<? extends DataSource> ds, Class<? extends DataSourceService> service) {
        Services.put(ds, service);
    }

    public static Set<Class<? extends DataSource>> subTypes() {
        return SubTypes.keySet();
    }

    public static Set<Class<? extends DataSourceDao>> subTypeItems() {
        return new HashSet<Class<? extends DataSourceDao>>(SubTypes.values());
    }

    public RRContext getISContext() {
        return this.context;
    }

    protected DataSource(Class<? extends DataSourceDao> type, Class<? extends DataSourceService> serviceType) throws ResourceRegistryException {
        try {
            this.item = type.newInstance();
            this.daoType = type;
            this.serviceType = serviceType;
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Unknown dao type: " + type.getName(), (Throwable)e);
        }
        this.item.setID(UUID.randomUUID().toString());
        this.context = ResourceRegistry.getContext();
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public Type getType() {
        return Type.valueOf(this.item.getType());
    }

    protected void setType(Type type) {
        this.item.setType(type.toString());
    }

    public Set<String> getScopes() {
        return this.item.getScopes();
    }

    public String getFunctionality() {
        return this.item.getFunctionality();
    }

    public void setFunctionality(String functionality) {
        this.item.setFunctionality(functionality);
    }

    public Set<String> getCapabilities() {
        return this.item.getCapabilities();
    }

    public Set<FieldIndexContainer> getFieldInfo() {
        return this.fieldInfo;
    }

    public abstract List<DataSourceService> getDataSourceServices() throws ResourceRegistryException;

    public DataSourceDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    private void apply(IRRElement target, boolean applyDetails, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof DataSource)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setID(((DataSource)target).item.getID());
        this.item.setFunctionality(((DataSource)target).item.getFunctionality());
        this.item.setType(((DataSource)target).item.getType());
        this.item.setFields(((DataSource)target).item.getFields());
        this.item.setCapabilities(((DataSource)target).item.getCapabilities());
        this.item.setScopes(((DataSource)target).item.getScopes());
        if (applyDetails) {
            throw new ResourceRegistryException("Unsupported operation");
        }
        if (doStore) {
            this.store(applyDetails, persistencyType, true);
        }
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        long lookupEnd;
        long existEnd;
        long existStart = Calendar.getInstance().getTimeInMillis();
        if (!this.exists(persistencyType)) {
            return false;
        }
        long lookupStart = existEnd = Calendar.getInstance().getTimeInMillis();
        boolean memLoaded = false;
        PersistenceManager pm = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        try {
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    DataSource retrieved = (DataSource)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, false, persistencyType, false);
                    memLoaded = true;
                }
                sharedLock.unlock();
                locked = false;
            }
            if (!memLoaded) {
                pm = this.getISContext().getManagerForRead(persistencyType);
                sharedLock.lock();
                locked = true;
                pm.currentTransaction().begin();
                this.item = (DataSourceDao)pm.detachCopy(pm.getObjectById(this.daoType, (Object)this.item.getID()));
                pm.currentTransaction().commit();
                sharedLock.unlock();
                locked = false;
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        long lookupDStart = lookupEnd = Calendar.getInstance().getTimeInMillis();
        this.fieldInfo.clear();
        for (String item : this.item.getFields()) {
            FieldIndexContainer w = new FieldIndexContainer();
            w.setID(item);
            if (loadDetails) {
                if (!w.exists(persistencyType)) continue;
                if (loadDetails) {
                    w.load(loadDetails, persistencyType, overridePrefetched);
                }
                this.fieldInfo.add(w);
                continue;
            }
            this.fieldInfo.add(w);
        }
        long lookupDend = Calendar.getInstance().getTimeInMillis();
        return true;
    }

    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return;
        }
        if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
            InMemoryStore.removeItem(((Object)((Object)this)).getClass(), (String)this.getID());
        }
        PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
        try {
            DataSource d = (DataSource)((Object)((Object)((Object)this)).getClass().newInstance());
            d.setID(this.getID());
            d.load(deleteDetails, persistencyType, true);
            pm.currentTransaction().begin();
            pm.deletePersistent((Object)d.item);
            pm.currentTransaction().commit();
            pm.flush();
            if (deleteDetails) {
                for (FieldIndexContainer fic : this.getFieldInfo()) {
                    fic.delete(deleteDetails, persistencyType);
                }
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not delete data source", (Throwable)e);
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            DataSource item = null;
            try {
                item = (DataSource)((Object)((Object)((Object)this)).getClass().newInstance());
            }
            catch (Exception e) {
                throw new ResourceRegistryException("Could not store data source", (Throwable)e);
            }
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, false, persistencyType, true);
        } else {
            this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
            }
            PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
            try {
                HashSet<String> fid = new HashSet<String>();
                for (FieldIndexContainer item : this.fieldInfo) {
                    fid.add(item.getID());
                }
                this.item.setFields(fid);
                pm.currentTransaction().begin();
                this.item = (DataSourceDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                pm.flush();
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
            if (storeDetails) {
                for (FieldIndexContainer item : this.fieldInfo) {
                    item.store(storeDetails, persistencyType);
                }
            }
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof DataSource)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((DataSource)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((DataSource)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((DataSource)target).item.getID() != null && !this.item.getID().equals(((DataSource)target).item.getID())) {
            return false;
        }
        if (this.item.getFunctionality() == null && ((DataSource)target).item.getFunctionality() != null) {
            return false;
        }
        if (this.item.getFunctionality() != null && ((DataSource)target).item.getFunctionality() == null) {
            return false;
        }
        if (this.item.getFunctionality() != null && ((DataSource)target).item.getFunctionality() != null && !this.item.getFunctionality().equals(((DataSource)target).item.getFunctionality())) {
            return false;
        }
        if (this.item.getCapabilities().size() != ((DataSource)target).getCapabilities().size()) {
            return false;
        }
        if (!((DataSource)target).getCapabilities().containsAll(this.item.getCapabilities())) {
            return false;
        }
        if (this.item.getFields().size() != ((DataSource)target).item.getFields().size()) {
            return false;
        }
        if (!((DataSource)target).item.getFields().containsAll(this.item.getFields())) {
            return false;
        }
        if (this.item.getScopes().size() != ((DataSource)target).getScopes().size()) {
            return false;
        }
        if (!((DataSource)target).getScopes().containsAll(this.item.getScopes())) {
            return false;
        }
        if (includeDetails) {
            if (this.fieldInfo.size() != ((DataSource)target).fieldInfo.size()) {
                return false;
            }
            for (FieldIndexContainer item : ((DataSource)target).fieldInfo) {
                FieldIndexContainer tmp = this.getFieldInfo(item.getID());
                if (tmp == null) {
                    return false;
                }
                if (tmp.isEqual((IRRElement)item, includeDetails)) continue;
                return false;
            }
        }
        return true;
    }

    public FieldIndexContainer getFieldInfo(String id) {
        for (FieldIndexContainer item : this.fieldInfo) {
            if (!item.getID().equals(id)) continue;
            return item;
        }
        return null;
    }

    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("DataSource - ID : " + this.getID() + "\n");
        buf.append("DataSource - Type : " + (Object)((Object)this.getType()) + "\n");
        buf.append("DataSource - Functionality : " + this.getFunctionality() + "\n");
        buf.append("DataSource - Scopes : ");
        for (String string : this.getScopes()) {
            buf.append(string + " ");
        }
        buf.append("\nDataSource - Capabilities : ");
        for (String string : this.getCapabilities()) {
            buf.append(string + " ");
        }
        buf.append("\nDataSource - Fields : \n");
        for (FieldIndexContainer fieldIndexContainer : this.getFieldInfo()) {
            buf.append(fieldIndexContainer.deepToString() + "\n");
        }
        return buf.toString();
    }

    public boolean supportsCapabilities(List<String> capabilities, boolean all) {
        if (all) {
            return this.getCapabilities().containsAll(capabilities);
        }
        for (String capability : capabilities) {
            if (!this.getCapabilities().contains(capability)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getLanguagesForCollectionAndSearchableField(String collection, String field) {
        HashSet<String> langs = new HashSet<String>();
        for (FieldIndexContainer cont : this.getFieldInfo()) {
            if (!cont.getCollection().equals(collection) || !cont.getField().equals(field) || !cont.isSearchable()) continue;
            langs.add(cont.getLanguage());
        }
        return langs;
    }

    public Set<String> getCollectionsForLanguageAndSearchableField(String language, String field) {
        HashSet<String> cols = new HashSet<String>();
        for (FieldIndexContainer cont : this.getFieldInfo()) {
            if (!cont.getLanguage().equals(language) || !cont.getField().equals(field) || !cont.isSearchable()) continue;
            cols.add(cont.getCollection());
        }
        return cols;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean exists(Class<? extends DataSourceDao> type, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(type, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(DataSourceDao.class, persistencyType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<DataSource> getAll(Class<? extends DataSourceDao> type, RRContext.DatastoreType persistencyType, boolean loadDetails) throws ResourceRegistryException {
        ArrayList<DataSource> col = new ArrayList<DataSource>();
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        Query typeQuery = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(type, "all");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            Class<? extends DataSourceDao> targetType = null;
            boolean base = false;
            if (type.getName().equals(DataSourceDao.class.getName())) {
                base = true;
            } else {
                targetType = type;
            }
            HashMap<String, String> typeQueryArgs = new HashMap<String, String>();
            if (base) {
                typeQuery = pm.newNamedQuery(type, "getType");
                typeQuery.compile();
            }
            try {
                for (String item : res) {
                    Class<? extends DataSource> typeToInstantiate;
                    if (base) {
                        typeQueryArgs.put("id", item);
                        sharedLock.lock();
                        locked = true;
                        Collection t = (Collection)typeQuery.executeWithMap(typeQueryArgs);
                        sharedLock.unlock();
                        locked = false;
                        targetType = SubTypes.get(SubTypesMap.get((Object)Type.valueOf((String)t.iterator().next())));
                        if (targetType == null) continue;
                    }
                    if ((typeToInstantiate = ReverseSubTypes.get(targetType)) == null) continue;
                    DataSource f = typeToInstantiate.newInstance();
                    f.setID(item);
                    f.load(loadDetails, persistencyType);
                    col.add(f);
                }
            }
            catch (IllegalAccessException e) {
                throw new ResourceRegistryException("Could not instantiate type: " + type.getName(), (Throwable)e);
            }
            catch (InstantiationException e) {
                throw new ResourceRegistryException("Could not instantiate type: " + type.getName(), (Throwable)e);
            }
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (typeQuery != null) {
                typeQuery.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return col;
    }

    public static List<DataSource> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSource.getAll(DataSourceDao.class, persistencyType, loadDetails);
    }

    public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSource.getAll(loadDetails, RRContext.DatastoreType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String id, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataSourceDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", id);
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getAllIds(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        Collection res = null;
        try {
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataSourceDao.class, "all");
            query.compile();
            sharedLock.lock();
            locked = true;
            res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            HashSet<String> hashSet = new HashSet<String>(res);
            return hashSet;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static Set<String> getAllIds() throws ResourceRegistryException {
        return DataSource.getAllIds(RRContext.DatastoreType.LOCAL);
    }

    public static boolean exists(String id) throws ResourceRegistryException {
        return DataSource.exists(id, RRContext.DatastoreType.LOCAL);
    }

    public static DataSource getById(boolean loadDetails, RRContext.DatastoreType persistencyType, String id) throws ResourceRegistryException {
        PersistenceManager pm = null;
        Query typeQuery = null;
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        Class<? extends DataSource> typeToInstantiate = null;
        try {
            long instantiateEnd;
            boolean memLoaded = false;
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL)) {
                boolean inMemory = false;
                for (Class<? extends DataSource> type : DataSource.subTypes()) {
                    if (!ResourceRegistry.getContext().isTargetInMemory(type.getName())) continue;
                    inMemory = true;
                }
                if (inMemory) {
                    sharedLock.lock();
                    locked = true;
                    for (Class<? extends DataSource> type : DataSource.subTypes()) {
                        if (!InMemoryStore.hasItem(type, (String)id)) continue;
                        typeToInstantiate = type;
                        memLoaded = true;
                        break;
                    }
                    sharedLock.unlock();
                    locked = false;
                }
            }
            if (!memLoaded) {
                long retrieveTypeEnd;
                long retrieveTypeStart = Calendar.getInstance().getTimeInMillis();
                pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
                typeQuery = pm.newNamedQuery(DataSourceDao.class, "getType");
                typeQuery.compile();
                HashMap<String, String> typeQueryArgs = new HashMap<String, String>();
                typeQueryArgs.put("id", id);
                sharedLock.lock();
                locked = true;
                Collection t = (Collection)typeQuery.executeWithMap(typeQueryArgs);
                if (t.isEmpty()) {
                    DataSource dataSource = null;
                    return dataSource;
                }
                sharedLock.unlock();
                locked = false;
                long instantiateStart = retrieveTypeEnd = Calendar.getInstance().getTimeInMillis();
                Class<? extends DataSourceDao> targetType = SubTypes.get(SubTypesMap.get((Object)Type.valueOf((String)t.iterator().next())));
                if (targetType == null) {
                    DataSource dataSource = null;
                    return dataSource;
                }
                typeToInstantiate = ReverseSubTypes.get(targetType);
            }
            if (typeToInstantiate == null) {
                DataSource retrieveTypeStart = null;
                return retrieveTypeStart;
            }
            DataSource f = (DataSource)((Object)typeToInstantiate.newInstance());
            long loadStart = instantiateEnd = Calendar.getInstance().getTimeInMillis();
            f.setID(id);
            if (!f.load(loadDetails)) {
                DataSource dataSource = null;
                return dataSource;
            }
            long loadEnd = Calendar.getInstance().getTimeInMillis();
            DataSource dataSource = f;
            return dataSource;
        }
        catch (IllegalAccessException e) {
            throw new ResourceRegistryException("Could not instantiate type: " + typeToInstantiate.getName(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ResourceRegistryException("Could not instantiate type: " + typeToInstantiate.getName(), (Throwable)e);
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (typeQuery != null) {
                typeQuery.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException {
        return DataSource.getById(loadDetails, RRContext.DatastoreType.LOCAL, id);
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollection(boolean loadDetails, String fieldID, String collection, FieldIndexContainer.FieldType type) throws ResourceRegistryException {
        String stype = "s";
        switch (type) {
            case Presentable: {
                stype = "p";
                break;
            }
            default: {
                stype = "s";
            }
        }
        return DataSource.queryByFieldIDAndTypeAndCollection(RRContext.DatastoreType.LOCAL, loadDetails, fieldID, collection, stype);
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollectionAndScope(boolean loadDetails, String fieldID, String collection, FieldIndexContainer.FieldType type, String scope) throws ResourceRegistryException {
        String stype = "s";
        switch (type) {
            case Presentable: {
                stype = "p";
                break;
            }
            default: {
                stype = "s";
            }
        }
        return DataSource.queryByFieldIDAndTypeAndCollectionAndScope(RRContext.DatastoreType.LOCAL, loadDetails, fieldID, collection, stype, scope);
    }

    public static List<DataSource> queryByFieldIDAndTypeAndLanguage(boolean loadDetails, String fieldID, String language, FieldIndexContainer.FieldType type) throws ResourceRegistryException {
        String stype = "s";
        switch (type) {
            case Presentable: {
                stype = "p";
                break;
            }
            default: {
                stype = "s";
            }
        }
        return DataSource.queryByFieldIDAndTypeAndLanguage(RRContext.DatastoreType.LOCAL, loadDetails, fieldID, language, stype);
    }

    public boolean containsField(String id) {
        return this.item.getFields().contains(id);
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollection(RRContext.DatastoreType persistencyType, boolean loadDetails, String fieldID, String collection, String type) throws ResourceRegistryException {
        logger.info("querying for field id : " + fieldID + " collection : " + collection + " type : " + type);
        List<FieldIndexContainer> fieldInfos = FieldIndexContainer.queryByFieldIDAndTypeAndCollection(persistencyType, fieldID, collection, type);
        logger.info("fieldInfos size : " + fieldInfos.size());
        HashSet<String> sourceIDs = new HashSet<String>();
        Set all = null;
        try {
            all = DatastoreHelper.getItems((RRContext.DatastoreType)RRContext.DatastoreType.LOCAL, DataSourceDao.class);
            logger.info(" ~> all items from local : " + all.size());
        }
        catch (Exception e) {
            logger.info(" ~> error while getting all item from local", (Throwable)e);
            throw new ResourceRegistryException("Could not load data source information", (Throwable)e);
        }
        for (FieldIndexContainer nfo : fieldInfos) {
            for (IDaoElement ind : all) {
                if (!((DataSourceDao)ind).getFields().contains(nfo.getID())) continue;
                sourceIDs.add(((DataSourceDao)ind).getID());
            }
        }
        logger.info("sourceIDs gathered by fieldInfos : " + sourceIDs);
        ArrayList<DataSource> items = new ArrayList<DataSource>();
        for (String id : sourceIDs) {
            DataSource item = DataSource.getById(loadDetails, id);
            items.add(item);
        }
        logger.info("number of datasources to be returned for querying for field id : " + fieldID + " collection : " + collection + " type : " + type + " #" + items.size());
        return items;
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollectionAndScope(RRContext.DatastoreType persistencyType, boolean loadDetails, String fieldID, String collection, String type, String scope) throws ResourceRegistryException {
        List<DataSource> items = DataSource.queryByFieldIDAndTypeAndCollection(persistencyType, loadDetails, fieldID, collection, type);
        ArrayList<DataSource> filteredItems = new ArrayList<DataSource>();
        for (DataSource item : items) {
            if (!item.getScopes().contains(scope)) continue;
            filteredItems.add(item);
        }
        return filteredItems;
    }

    public static List<DataSource> queryByFieldIDAndTypeAndLanguage(RRContext.DatastoreType persistencyType, boolean loadDetails, String fieldID, String language, String type) throws ResourceRegistryException {
        List<FieldIndexContainer> fieldInfos = FieldIndexContainer.queryByFieldIDAndTypeAndLanguage(persistencyType, fieldID, language, type);
        HashSet<String> sourceIDs = new HashSet<String>();
        List<DataSource> all = DataSource.getAll(false);
        for (FieldIndexContainer nfo : fieldInfos) {
            for (DataSource ind : all) {
                if (!ind.item.getFields().contains(nfo.getID())) continue;
                sourceIDs.add(ind.getID());
            }
        }
        ArrayList<DataSource> items = new ArrayList<DataSource>();
        for (String id : sourceIDs) {
            DataSource item = DataSource.getById(loadDetails, id);
            items.add(item);
        }
        return items;
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollectionAndLanguage(boolean loadDetails, String fieldID, String collection, String language, FieldIndexContainer.FieldType type) throws ResourceRegistryException {
        String stype = "s";
        switch (type) {
            case Presentable: {
                stype = "p";
                break;
            }
            default: {
                stype = "s";
            }
        }
        return DataSource.queryByFieldIDAndTypeAndCollectionAndLanguage(RRContext.DatastoreType.LOCAL, loadDetails, fieldID, collection, language, stype);
    }

    public static List<DataSource> queryByFieldIDAndTypeAndCollectionAndLanguage(RRContext.DatastoreType persistencyType, boolean loadDetails, String fieldID, String collection, String language, String type) throws ResourceRegistryException {
        List<FieldIndexContainer> fieldInfos = FieldIndexContainer.queryByFieldIDAndTypeAndCollectionAndLanguage(persistencyType, fieldID, collection, language, type);
        HashSet<String> sourceIDs = new HashSet<String>();
        List<DataSource> all = DataSource.getAll(false);
        for (FieldIndexContainer nfo : fieldInfos) {
            for (DataSource ind : all) {
                if (!ind.item.getFields().contains(nfo.getID())) continue;
                sourceIDs.add(ind.getID());
            }
        }
        ArrayList<DataSource> items = new ArrayList<DataSource>();
        for (String id : sourceIDs) {
            DataSource item = DataSource.getById(loadDetails, id);
            items.add(item);
        }
        return items;
    }

    public static enum Type {
        FullTextIndex,
        SruConsumer,
        OpenSearch;


        public boolean isExternal() {
            return this.equals((Object)OpenSearch) || this.equals((Object)SruConsumer);
        }
    }
}

