/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.search.index;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexService;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoIndex
extends DataSource {
    public static Logger logger = Logger.getLogger(GeoIndex.class.getName());

    public GeoIndex() throws ResourceRegistryException {
        super(GeoIndexDao.class, GeoIndexService.class);
        super.setType(DataSource.Type.GeoIndex);
    }

    @Override
    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append("GeoIndexService - ID : " + this.getID() + "\n");
        buf.append("GeoIndexService - Functionality : " + this.getFunctionality() + "\n");
        buf.append("GeoIndexService - Scopes : ");
        for (String string : this.getScopes()) {
            buf.append(string + " ");
        }
        buf.append("\nGeoIndexService - Capabilities : ");
        for (String string : this.getCapabilities()) {
            buf.append(string + " ");
        }
        buf.append("\nGeoIndexService - Fields : \n");
        for (FieldIndexContainer fieldIndexContainer : this.getFieldInfo()) {
            buf.append(fieldIndexContainer.deepToString() + "\n");
        }
        return buf.toString();
    }

    @Override
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.exists(GeoIndexDao.class, persistencyType);
    }

    public static List<DataSource> getAll(boolean loadDetails) throws ResourceRegistryException {
        return DataSource.getAll(GeoIndexDao.class, RRContext.DatastoreType.LOCAL, loadDetails);
    }

    public static List<DataSource> getAll(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return DataSource.getAll(GeoIndexDao.class, persistencyType, loadDetails);
    }

    @Override
    public List<DataSourceService> getDataSourceServices() throws ResourceRegistryException {
        if (this.boundDataSourceServices == null) {
            if (this.item.getBoundDataSourceServices() != null) {
                ArrayList<DataSourceService> ret = new ArrayList<DataSourceService>();
                for (String ds : this.item.getBoundDataSourceServices()) {
                    DataSourceService s = GeoIndexService.getById(true, ds);
                    if (s != null) {
                        ret.add(s);
                        continue;
                    }
                    logger.log(Level.WARNING, "Could not find bound geo text index service with id " + ds);
                }
                this.boundDataSourceServices = ret;
                return ret;
            }
            return GeoIndexService.getAll(true);
        }
        return this.boundDataSourceServices;
    }

    public static DataSource getById(boolean loadDetails, String id) throws ResourceRegistryException {
        GeoIndex f = new GeoIndex();
        f.setID(id);
        return f.load(loadDetails) ? f : null;
    }
}

