/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.element.data;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistry;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IRRElement;
import gr.uoa.di.madgik.rr.element.RRElement;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jdo.PersistenceManager;
import javax.jdo.Query;

public class DataCollection
extends RRElement {
    private static Logger logger = Logger.getLogger(DataCollection.class.getName());
    private DataCollectionDao item = new DataCollectionDao();
    private RRContext context = null;
    private static boolean retrieved = false;

    public RRContext getISContext() {
        return this.context;
    }

    public DataCollection() throws ResourceRegistryException {
        this.item.setID(UUID.randomUUID().toString());
        this.context = ResourceRegistry.getContext();
    }

    public String getID() {
        return this.item.getID();
    }

    public void setID(String id) {
        this.item.setID(id);
    }

    public String getName() {
        return this.item.getName();
    }

    public void setName(String name) {
        this.item.setName(name);
    }

    public Set<String> getScopes() {
        return this.item.getScopes();
    }

    public void setScopes(Set<String> scopes) {
        this.item.setScopes(scopes);
    }

    public String getDescription() {
        return this.item.getDescription();
    }

    public void setDescription(String description) {
        this.item.setDescription(description);
    }

    public Calendar getCreationTime() {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Long.parseLong(this.item.getCreationTime()));
        return c;
    }

    public void setCreationTime(Calendar creationTime) {
        this.item.setCreationTime(Long.toString(creationTime.getTimeInMillis()));
    }

    public DataCollectionDao getItem() {
        return this.item;
    }

    public void setDirty() {
        this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
    }

    private void apply(IRRElement target, boolean applyDetails, RRContext.DatastoreType persistencyType, boolean doStore) throws ResourceRegistryException {
        if (!(target instanceof DataCollection)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.isEqual(target, applyDetails)) {
            return;
        }
        this.item.setCreationTime(((DataCollection)target).item.getCreationTime());
        this.item.setDescription(((DataCollection)target).item.getDescription());
        this.item.setID(((DataCollection)target).item.getID());
        this.item.setName(((DataCollection)target).item.getName());
        this.item.setScopes(((DataCollection)target).item.getScopes());
        if (doStore) {
            this.store(applyDetails, persistencyType);
        }
    }

    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        return this.load(loadDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(boolean loadDetails, RRContext.DatastoreType persistencyType, boolean overridePrefetched) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        PersistenceManager pm = null;
        boolean locked = false;
        if (!this.exists(persistencyType)) {
            return false;
        }
        try {
            if (!overridePrefetched && persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    DataCollection retrieved = (DataCollection)InMemoryStore.getItem(((Object)((Object)this)).getClass(), (String)this.getID());
                    this.apply((IRRElement)retrieved, loadDetails, persistencyType, false);
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = this.getISContext().getManagerForRead(persistencyType);
            pm.currentTransaction().begin();
            sharedLock.lock();
            locked = true;
            this.item = (DataCollectionDao)pm.detachCopy(pm.getObjectById(DataCollectionDao.class, (Object)this.item.getID()));
            sharedLock.unlock();
            locked = false;
            pm.currentTransaction().commit();
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (pm != null && pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            if (pm != null) {
                pm.close();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(boolean deleteDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        if (!this.exists(persistencyType)) {
            return;
        }
        if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
            InMemoryStore.removeItem(((Object)((Object)this)).getClass(), (String)this.getID());
        }
        DataCollection c = new DataCollection();
        c.setID(this.getID());
        c.load(deleteDetails, persistencyType, true);
        PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
        try {
            pm.currentTransaction().begin();
            pm.deletePersistent((Object)c.item);
            pm.currentTransaction().commit();
            pm.flush();
        }
        finally {
            if (pm.currentTransaction().isActive()) {
                pm.currentTransaction().rollback();
            }
            pm.close();
        }
    }

    public void store(boolean storeDetails, RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        this.store(storeDetails, persistencyType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(boolean storeDetails, RRContext.DatastoreType persistencyType, boolean writeThrough) throws ResourceRegistryException {
        if (this.exists(persistencyType) && !writeThrough) {
            DataCollection item = new DataCollection();
            item.setID(this.getID());
            item.load(storeDetails, persistencyType, true);
            item.apply((IRRElement)this, storeDetails, persistencyType, true);
        } else {
            this.item.setTimestamp(Calendar.getInstance().getTimeInMillis());
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                InMemoryStore.setItem(((Object)((Object)this)).getClass(), (IRRElement)this);
            }
            PersistenceManager pm = this.getISContext().getManagerForWrite(persistencyType);
            try {
                pm.currentTransaction().begin();
                this.item = (DataCollectionDao)pm.detachCopy(pm.makePersistent((Object)this.item));
                pm.currentTransaction().commit();
                pm.flush();
            }
            finally {
                if (pm.currentTransaction().isActive()) {
                    pm.currentTransaction().rollback();
                }
                pm.close();
            }
        }
    }

    public boolean isEqual(IRRElement target, boolean includeDetails) throws ResourceRegistryException {
        if (!(target instanceof DataCollection)) {
            throw new ResourceRegistryException("cannot apply to target of " + target);
        }
        if (this.item.getID() == null && ((DataCollection)target).item.getID() != null) {
            return false;
        }
        if (this.item.getID() != null && ((DataCollection)target).item.getID() == null) {
            return false;
        }
        if (this.item.getID() != null && ((DataCollection)target).item.getID() != null && !this.item.getID().equals(((DataCollection)target).item.getID())) {
            return false;
        }
        if (this.item.getName() == null && ((DataCollection)target).item.getName() != null) {
            return false;
        }
        if (this.item.getName() != null && ((DataCollection)target).item.getName() == null) {
            return false;
        }
        if (this.item.getName() != null && ((DataCollection)target).item.getName() != null && !this.item.getName().equals(((DataCollection)target).item.getName())) {
            return false;
        }
        if (this.item.getScopes().size() != ((DataCollection)target).item.getScopes().size()) {
            return false;
        }
        return ((DataCollection)target).item.getScopes().containsAll(this.item.getScopes());
    }

    public boolean equals(Object target) {
        if (target == null) {
            return false;
        }
        if (target == this) {
            return true;
        }
        if (!(target instanceof DataCollection)) {
            return false;
        }
        boolean res = false;
        try {
            this.isEqual((IRRElement)target, false);
        }
        catch (ResourceRegistryException e) {
            logger.log(Level.WARNING, "Unexpected error from isEqual", e);
            res = false;
        }
        return res;
    }

    public int hashCode() {
        int hash = 1;
        hash = hash * 17 + this.item.getID().hashCode();
        hash = hash * 31 + this.item.getName().hashCode();
        hash = hash * 13 + this.item.getScopes().hashCode();
        return hash;
    }

    public String deepToString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.item.deepToString());
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(RRContext.DatastoreType persistencyType) throws ResourceRegistryException {
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        try {
            if (persistencyType.equals((Object)RRContext.DatastoreType.LOCAL) && this.context.isTargetInMemory(((Object)((Object)this)).getClass().getName())) {
                sharedLock.lock();
                locked = true;
                if (InMemoryStore.hasItem(((Object)((Object)this)).getClass(), (String)this.getID())) {
                    boolean bl = true;
                    return bl;
                }
                sharedLock.unlock();
                locked = false;
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataCollectionDao.class, "exists");
            query.compile();
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("id", this.getID());
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.executeWithMap(args);
            boolean bl = res.size() == 1;
            return bl;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static List<DataCollection> getAllCollections(boolean loadDetails) throws ResourceRegistryException {
        RRContext.ReadPolicy policy;
        if (ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)RRContext.ReadPolicy.REFRESH_AHEAD)) {
            policy = RRContext.ReadPolicy.REFRESH_AHEAD;
        } else if (ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)RRContext.ReadPolicy.READ_THROUGH)) {
            policy = !retrieved ? RRContext.ReadPolicy.READ_THROUGH : RRContext.ReadPolicy.READ_LOCAL;
        } else {
            throw new ResourceRegistryException("Could not infer read policy");
        }
        List<DataCollection> col = DataCollection.getAllCollections(loadDetails, policy);
        if (policy == RRContext.ReadPolicy.READ_THROUGH) {
            retrieved = true;
        }
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<DataCollection> getAllCollections(boolean loadDetails, RRContext.ReadPolicy policy) throws ResourceRegistryException {
        RRContext.DatastoreType persistencyType;
        if (!ResourceRegistry.isReadPolicySupported((RRContext.ReadPolicy)policy)) {
            throw new ResourceRegistryException("Read policy not supported");
        }
        if (policy == RRContext.ReadPolicy.READ_LOCAL || policy == RRContext.ReadPolicy.REFRESH_AHEAD) {
            persistencyType = RRContext.DatastoreType.LOCAL;
        } else {
            if (policy != RRContext.ReadPolicy.READ_THROUGH) throw new ResourceRegistryException("Unsupported read policy");
            if (ResourceRegistry.getContext().isDatastoreSupportedForRead(RRContext.DatastoreType.REMOTE)) {
                persistencyType = RRContext.DatastoreType.REMOTE;
            } else {
                ResourceRegistry.retrieveDirect(DataCollectionDao.class);
                return DataCollection.getAllCollections(loadDetails, RRContext.ReadPolicy.READ_LOCAL);
            }
        }
        Lock sharedLock = ResourceRegistry.getContext().getSharedLock();
        boolean locked = false;
        PersistenceManager pm = null;
        Query query = null;
        ArrayList<DataCollection> col = new ArrayList<DataCollection>();
        try {
            if (ResourceRegistry.getContext().isTargetInMemory(DataCollection.class.getName())) {
                sharedLock.lock();
                locked = true;
                Set retrieved = InMemoryStore.getItems(DataCollection.class);
                sharedLock.unlock();
                locked = false;
                if (retrieved != null) {
                    for (IRRElement item : retrieved) {
                        col.add((DataCollection)item);
                    }
                    ArrayList<DataCollection> i$ = col;
                    return i$;
                }
            }
            pm = ResourceRegistry.getContext().getManagerForRead(persistencyType);
            query = pm.newNamedQuery(DataCollectionDao.class, "allCollections");
            query.compile();
            sharedLock.lock();
            locked = true;
            Collection res = (Collection)query.execute();
            sharedLock.unlock();
            locked = false;
            for (String item : res) {
                DataCollection f = new DataCollection();
                f.setID(item);
                f.load(loadDetails);
                col.add(f);
            }
            return col;
        }
        finally {
            if (locked) {
                sharedLock.unlock();
            }
            if (query != null) {
                query.closeAll();
            }
            if (pm != null) {
                pm.close();
            }
        }
    }

    public static List<DataCollection> getCollectionsOfScope(boolean loadDetails, String scope) throws ResourceRegistryException {
        List<DataCollection> cols = DataCollection.getAllCollections(loadDetails);
        ArrayList<DataCollection> res = new ArrayList<DataCollection>();
        for (DataCollection col : cols) {
            if (!col.getScopes().contains(scope)) continue;
            res.add(col);
        }
        return res;
    }
}

