package gr.uoa.di.madgik.rr.element.functionality;

import java.util.Calendar;

import org.w3c.dom.Element;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IDaoElement;

public class FunctionalityDao implements IDaoElement
{
	public String name;
	public long timestamp = Calendar.getInstance().getTimeInMillis();

	public String getName()
	{
		return name;
	}
	
	public String getID()
	{
		return name;
	}
	
	public long getTimestamp()
	{
		return timestamp;
	}

	public void setName(String name)
	{
		this.name = name;
	}

	public void apply(IDaoElement target) throws ResourceRegistryException
	{
		if(!(target instanceof FunctionalityDao)) throw new ResourceRegistryException("cannot apply to target of "+target);
		this.setName(((FunctionalityDao)target).getName());
	}
	
	public void fromXML(Element element) throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}

	public String toXML() throws ResourceRegistryException
	{
		throw new ResourceRegistryException("This element does not support serialization operation");
	}
	
	public String deepToString()
	{
		StringBuilder buf=new StringBuilder();
		buf.append("Functionality Name : "+this.name);
		return buf.toString();
	}

}
