package org.gcube.execution.rr.bridge;
import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.rr.RRContext.DatastoreType;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.access.InMemoryStore;
import gr.uoa.di.madgik.rr.element.IDaoElement;
import gr.uoa.di.madgik.rr.element.config.StaticConfigurationDao;
import gr.uoa.di.madgik.rr.element.data.DataCollection;
import gr.uoa.di.madgik.rr.element.data.DataCollectionDao;
import gr.uoa.di.madgik.rr.element.data.DataLanguage;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServerDao;
import gr.uoa.di.madgik.rr.element.execution.ExecutionServiceDao;
import gr.uoa.di.madgik.rr.element.execution.SearchServiceDao;
import gr.uoa.di.madgik.rr.element.execution.WorkflowServiceDao;
import gr.uoa.di.madgik.rr.element.functionality.Functionality;
import gr.uoa.di.madgik.rr.element.functionality.FunctionalityDao;
import gr.uoa.di.madgik.rr.element.infra.HostingNode;
import gr.uoa.di.madgik.rr.element.infra.HostingNodeDao;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadata;
import gr.uoa.di.madgik.rr.element.metadata.ElementMetadataDao;
import gr.uoa.di.madgik.rr.element.search.Field;
import gr.uoa.di.madgik.rr.element.search.FieldDao;
import gr.uoa.di.madgik.rr.element.search.Presentable;
import gr.uoa.di.madgik.rr.element.search.PresentableDao;
import gr.uoa.di.madgik.rr.element.search.Searchable;
import gr.uoa.di.madgik.rr.element.search.SearchableDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndex;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FTIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndex;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexService;
import gr.uoa.di.madgik.rr.element.search.index.FWIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainer;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndex;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexDao;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexService;
import gr.uoa.di.madgik.rr.element.search.index.GeoIndexServiceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSource;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.FieldIndexContainerDao;
import gr.uoa.di.madgik.rr.element.search.index.DataSource;
import gr.uoa.di.madgik.rr.element.search.index.DataSourceDao;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceService;
import gr.uoa.di.madgik.rr.element.search.index.OpenSearchDataSourceServiceDao;
import gr.uoa.di.madgik.rr.utils.DatastoreHelper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.RPDocument;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGHNQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBEGenericResourceQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.informationsystem.client.queries.WSResourceQuery;
import org.gcube.common.core.informationsystem.publisher.ISPublisher;
import org.gcube.common.core.resources.GCUBEGenericResource;
import org.gcube.common.core.resources.GCUBEHostingNode;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.resources.node.Description.FileSystem;
import org.gcube.common.core.resources.node.Description.NetworkAdapter;
import org.gcube.common.core.resources.node.Description.Processor;
import org.gcube.common.core.resources.node.Description.StorageDevice;
import org.gcube.common.core.resources.node.Description.StoragePartition;
import org.gcube.common.core.resources.node.Description.RuntimeEnvironment.Variable;
import org.gcube.common.core.resources.runninginstance.Endpoint;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManagerImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BridgeHelper
{
	private static Logger logger=Logger.getLogger(BridgeHelper.class.getName());
	
	private static GCUBEScope[] scopes = null;
	private static GCUBEScope[] searchSystemScopes = null;
	private static Set<IDaoElement> searchSystemServices = null;
	
	public static void initializeIndexTypes()
	{
		DataSource.clearSubTypes();
		DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndex.class, FTIndexDao.class);
		DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndex.class, FWIndexDao.class);
		DataSource.addSubType(DataSource.Type.GeoIndex, GeoIndex.class, GeoIndexDao.class);
		DataSource.addSubType(DataSource.Type.OpenSearch, OpenSearchDataSource.class, OpenSearchDataSourceDao.class);
		
		DataSourceService.clearSubTypes();
		DataSourceService.addSubType(DataSourceService.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
		DataSourceService.addSubType(DataSourceService.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
		DataSourceService.addSubType(DataSourceService.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
		DataSourceService.addSubType(DataSourceService.Type.OpenSearch, OpenSearchDataSourceService.class, OpenSearchDataSourceServiceDao.class);
	}
	
	public static void initializeIndexTypes(Properties config) throws ResourceRegistryException
	{
		try 
		{
			int count=Integer.parseInt(config.getProperty("dataSourceSubTypesCount","0"));
			if(count!=0) 
			{
				DataSource.clearSubTypes();
				Set<String> res=new HashSet<String>(count);
				for(int i=0;i<count;i+=1)
				{
					String type, key, value;
					if((type = config.getProperty("dataSourceSubTypesType."+i)) == null) throw new ResourceRegistryException("Could not read datasource type #"+i);
					if((key = config.getProperty("dataSourceSubTypesKey."+i)) == null) throw new ResourceRegistryException("Could not read datasource class name #"+i);
					if((value = config.getProperty("dataSourceSubTypesValue."+i)) ==  null) throw new ResourceRegistryException("Could not read datasource dao class name #"+i);
					DataSource.addSubType(DataSource.Type.valueOf(type), (Class<? extends DataSource>)Class.forName(key), 
					(Class<? extends DataSourceDao>)Class.forName(value));
					logger.log(Level.INFO, "Adding DataSource type: " + type + "-" + key + "-" + value);
				}
			}
			count=Integer.parseInt(config.getProperty("dataSourceServiceSubTypesCount", "0"));
			if(count!=0)
			{
				DataSourceService.clearSubTypes();
				Set<String> res=new HashSet<String>(count);
				for(int i=0;i<count;i+=1)
				{
					String type, key, value;
					if((type = config.getProperty("dataSourceServiceSubTypesType."+i)) == null) throw new ResourceRegistryException("Could not read datasource service type #"+i);
					if((key = config.getProperty("dataSourceServiceSubTypesKey."+i)) == null) throw new ResourceRegistryException("Could not read datasource service class name #"+i);
					if((value = config.getProperty("dataSourceServiceSubTypesValue."+i)) ==  null) throw new ResourceRegistryException("Could not read datasource service dao class name #"+i);
					DataSourceService.addSubType(DataSourceService.Type.valueOf(type), (Class<? extends DataSourceService>)Class.forName(key), 
					(Class<? extends DataSourceServiceDao>)Class.forName(value));
					logger.log(Level.INFO, "Adding DataSource service type: " + type + "-" + key + "-" + value);
				}
			}
		}catch(Exception e)
		{
			throw new ResourceRegistryException("Error while initializing datasource types", e);
		}
	}
	
	public static void retrieveScopes() throws Exception
	{		
		if(GHNContext.getContext().isClientMode())
			retrieveScopesOffline();
		else
			retrieveScopesOnline();
		
		if(logger.isLoggable(Level.INFO))
		{
			StringBuilder logScopes = new StringBuilder();
			for(GCUBEScope scope : BridgeHelper.scopes)
			{
				logScopes.append(scope.toString());
				logScopes.append(" ");
			}
//			BridgeHelper.scopes = new GCUBEScope[] {
//					GCUBEScope.getScope("/d4science.research-infrastructures.eu/FARM"),
//					GCUBEScope.getScope("/d4science.research-infrastructures.eu/FARM/FCPPS")
//			};
			logger.log(Level.INFO, "Scopes: " + logScopes.toString());
		}
		searchSystemServices = retrieveSearchService();
		Set<String> searchSystemScopeSet = new HashSet<String>();
		for(IDaoElement searchSystemService : searchSystemServices)
			searchSystemScopeSet.addAll(((SearchServiceDao)searchSystemService).scopes);
		searchSystemScopes = new GCUBEScope[searchSystemScopeSet.size()];
		int i=0;
		for(String s : searchSystemScopeSet)
			searchSystemScopes[i++] = GCUBEScope.getScope(s);
	}
	
	public static GCUBEScope[] getFieldModelScopes() throws Exception
	{
		Set<String> fieldScopes = new HashSet<String>();
		for(GCUBEScope scope : BridgeHelper.searchSystemScopes)
		{
			if(scope.getType().equals(GCUBEScope.Type.VO))
				fieldScopes.add(scope.toString());
			else if(scope.getType().equals(GCUBEScope.Type.VRE))
				fieldScopes.add(scope.getEnclosingScope().toString());
		}
		List<GCUBEScope> gCubeScopes = new ArrayList<GCUBEScope>();
		for(String scope : fieldScopes)
			gCubeScopes.add(GCUBEScope.getScope(scope));
		//if(gCubeScopes.size()==0) return BridgeHelper.scopes;
		return gCubeScopes.toArray(new GCUBEScope[]{});
	}
	
	private static void retrieveScopesOnline()
	{
		java.util.Collection<GCUBEScope> tmpScopes = GHNContext.getContext().getGHN().getScopes().values();
		List<GCUBEScope> toKeepScopes = new ArrayList<GCUBEScope>();
		for(GCUBEScope scope : tmpScopes)
		{
			if(!scope.isInfrastructure())
				toKeepScopes.add(scope);
		}
		BridgeHelper.scopes = toKeepScopes.toArray(new GCUBEScope[0]);
	}
	
	private static void retrieveScopesOffline() throws Exception
	{
		List<GCUBEScope> scopes = new ArrayList<GCUBEScope>();
		scopes.addAll(Arrays.asList(GHNContext.getContext().getStartScopes()));
		
		List<GCUBEGenericResource> resources = BridgeHelper.getPublishedVREResources();
		for(GCUBEGenericResource resource : resources)
		{
			String retrievedScope = BridgeHelper.getVREScope(resource);
			if(retrievedScope != null)
				scopes.add(GCUBEScope.getScope(retrievedScope));
		}
	
		BridgeHelper.scopes = scopes.toArray(new GCUBEScope[]{});
	}
	
	private static List<GCUBEGenericResource> getPublishedVREResources() throws Exception
	{
		ISClient client = null;
		GCUBEGenericResourceQuery query = null;
		client =  GHNContext.getImplementation(ISClient.class);
		
		GCUBEScope []scopes = GHNContext.getContext().getStartScopes();
		
		List<GCUBEGenericResource> resources=new ArrayList<GCUBEGenericResource>();
		for(GCUBEScope scope : scopes)
		{
			if(scope.getType() != GCUBEScope.Type.VO) continue;
			query = client.getQuery(GCUBEGenericResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", GCUBEGenericResource.SECONDARYTYPE_VRE));
			resources.addAll(client.execute(query,scope));
		}
		return resources;

	}
	
	private static String getVREScope(GCUBEGenericResource resource) throws Exception
	{
		Document doc = null;
		if(resource != null && 
				resource.getBody()!=null && 
				resource.getBody().trim().length()!=0) doc = XMLUtils.Deserialize("<root>" + resource.getBody() + "</root>");
			else return null;
		
		    return XMLUtils.GetChildElementWithName(doc.getDocumentElement(), "Scope").getFirstChild().getNodeValue();
	}
	
	public static Set<IDaoElement> getElement(Class<?> type) throws Exception
	{
		if(type.equals(FieldDao.class)) return getFields();
		else if(type.equals(PresentableDao.class)) return getPresentables();
		else if(type.equals(SearchableDao.class)) return getSearchables();
		else if(type.equals(DataCollectionDao.class)) return getAllCollections();
		else if(type.equals(HostingNodeDao.class)) return getHostingNodes();
		else if(type.equals(FunctionalityDao.class)) return getFunctionality();
		else if(type.equals(ExecutionServerDao.class)) return getExecutionServer();
		else if(type.equals(ExecutionServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the server case
		else if(type.equals(WorkflowServiceDao.class)) return getWorkflowService();
		else if(type.equals(FieldIndexContainerDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(FTIndexDao.class)) return getFTIndex();
		else if(type.equals(FWIndexDao.class)) return getFWIndex();
		else if(type.equals(GeoIndexDao.class)) return getGeoIndex();
		else if(type.equals(OpenSearchDataSourceDao.class)) return getOpenSearchDataSource(); //covered by the Index cases
		else if(type.equals(FTIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(FWIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(GeoIndexServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(OpenSearchDataSourceServiceDao.class)) return new HashSet<IDaoElement>(); //covered by the Index cases
		else if(type.equals(ElementMetadataDao.class)) return getElementMetadata();
		else if(type.equals(StaticConfigurationDao.class)) return getStaticConfiguration();
		throw new ResourceRegistryException("unrecognized element type "+type);
	}
	
	private static Set<IDaoElement> getDataSource(String className, String serviceClassName, String serviceClass, String serviceName, String functionality, 
			DataSource.Type type, String description) throws Exception
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		logger.log(Level.WARNING,"### getting datasources from scopes : " + scopes);
		
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> datasourceServiceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for " + description + " indexes in scope "+scope.toString());
			ISClient client =  GHNContext.getImplementation(ISClient.class);
			WSResourceQuery query=client.getQuery(WSResourceQuery.class);
//			query.addAtomicConditions(new AtomicCondition("/Data/ServiceName","FullTextIndexLookup"));
//			query.addAtomicConditions(new AtomicCondition("/Data/ServiceClass","Index"));
//			query.addGenericCondition("$result/Data/child::*[local-name()='ServiceName']/string() eq 'FullTextIndexLookup' and $result/Data/child::*[local-name()='ServiceClass']/string() eq 'Index'");
			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceName']/string() eq '" + serviceName + "'");
			query.addGenericCondition("$result//Data/child::*[local-name()='ServiceClass']/string() eq '" + serviceClass + "'");
			List<RPDocument> inds=client.execute(query, scope);
			logger.log(Level.INFO,"Found "+inds.size()+" indexes in scope");
			for(RPDocument d : inds)
			{
				if(d.getKey()==null || d.getKey().getValue()==null) continue;
				String key=d.getKey().getValue();
				if(datasourceItems.containsKey(key)) 
				{
					for(GCUBEScope s : d.getScope())
					{
						datasourceItems.get(d.getKey().getValue()).getScopes().add(s.toString());
						datasourceServiceItems.get(d.getKey().getValue()).getScopes().add(s.toString());
					}
					datasourceItems.get(d.getKey().getValue()).getScopes().add(scope.toString()); 
					datasourceServiceItems.get(d.getKey().getValue()).getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
																										 //sources deployed on VO scope, regardless of the fact that
					   																					 //they might not contain the VRE scope. For that
					   																					 //reason, the current scope is added to the source scopes		 																			
				}
				else
				{
					
					DataSourceServiceDao ss = (DataSourceServiceDao)Class.forName(serviceClassName).newInstance();
					ss.setID(key);
					ss.setType(type.toString());
					ss.getDataSources().add(key);
					ss.setEndpoint(d.getEndpoint().getAddress().toString());
					ss.setFunctionality(functionality);
					ss.setHostingNode(d.getGHNID());
					for(GCUBEScope sc : d.getScope()) ss.getScopes().add(sc.toString());
					ss.getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
														  //sources deployed on VO scope, regardless of the fact that
					 									  //they might not contain the VRE scope. For that
					 									  //reason, the current scope is added to the source scopes
					ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
					datasourceServiceItems.put(ss.getID(), ss);
					
					DataSourceDao s = (DataSourceDao)Class.forName(className).newInstance();
					//FTIndexServiceDao s=new FTIndexServiceDao();
					s.setID(key);
					s.setType(type.toString());
					s.setFunctionality(functionality);
					if(s.getBoundDataSourceServices() == null) s.setBoundDataSourceServices(new HashSet<String>());
					s.getBoundDataSourceServices().add(key);
					s.setTimestamp(Calendar.getInstance().getTimeInMillis());
				//	s.setHostingNode(d.getGHNID());
					s.getCapabilities().clear();
					s.getCapabilities().addAll(d.evaluate("//SupportedRelations/text()"));
					
				//	s.getFields().clear();
					for(GCUBEScope sc : d.getScope()) s.getScopes().add(sc.toString());
					s.getScopes().add(scope.toString()); //If the IS was queried in VRE scope, it will return all
														 //sources deployed on VO scope, regardless of the fact that
														 //they might not contain the VRE scope. For that
														 //reason, the current scope is added to the source scopes
					List<String> ff=d.evaluate("//Fields/text()");
					Set<String> checkDups = new HashSet<String>();
					for(String f:ff)
					{
						String []fparts=f.split(":");
						if(fparts.length==6 && fparts[2].equals("s")) fparts[4] += ":" + fparts[5];
						if(fparts.length<4 || fparts.length>6 ) continue;
						if(fparts.length==6 && !fparts[2].equals("s")) continue;
						FieldIndexContainerDao fc=new FieldIndexContainerDao();
						fc.setID(s.getID()+":"+f);
						if(checkDups.contains(fc.getID()))
						{
							logger.log(Level.WARNING, "Duplicate field detected: " + fc.getID()); 
							continue;
						}
						checkDups.add(fc.getID());
						fc.setCollection(fparts[0]);
						fc.setLanguage(fparts[1]);
						
						
						 
						
						fc.setFieldType(fparts[2]);
						fc.setField(fparts[3]);
						logger.log(Level.INFO, "Field : " + f + " language " + fparts[1]);
						
						if(fparts.length>=5) fc.setExpression(fparts[4]);
						s.getFields().add(fc.getID());
						fieldItems.add(fc);
					}
					datasourceItems.put(s.getID(), s);
				}
			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(datasourceServiceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
	}
	
//	private static Set<IDaoElement> getFTIndex() throws Exception
//	{
//		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
//		return getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexLookup", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
//	}
	
	private static Set<IDaoElement> getFTIndex() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
		return getDataSource(FTIndexDao.class.getName(), FTIndexServiceDao.class.getName(), "Index", "FullTextIndexNode", "search.index.ft", DataSource.Type.FullTextIndex, "full text");
	}
	
	private static Set<IDaoElement> getFakeFTIndex() throws Exception
	{
		
		//DataSource.addSubType(DataSource.Type.FullTextIndex, FTIndexService.class, FTIndexServiceDao.class);
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> serviceItems=new HashMap<String, DataSourceServiceDao>();
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		
		FTIndexServiceDao ss =  new FTIndexServiceDao();
		ss.setID("1283-5c96-f869-172b");
		ss.setFunctionality("search.index.ft");
		ss.setHostingNode("FTIndexGHNOne");
		ss.setEndpoint("http://nowhere1.com/wsrf/index/fulltext");
		ss.getScopes().add("/no/scope/");
		ss.setTimestamp(Calendar.getInstance().getTimeInMillis());
		ss.setType(DataSource.Type.FullTextIndex.toString());
		serviceItems.put(ss.getID(), ss);
		
		FTIndexDao s = new FTIndexDao();
		s.setID("1283-5c96-f869-172b");
		s.setType(DataSource.Type.FullTextIndex.toString());
		s.setFunctionality("search.index.ft");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		List<String> ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:title");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:title");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:source");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:source");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		
		//////////////
		ss = new FTIndexServiceDao();
		ss.setID("768a-8ab8-1281-9812");
		ss.setType(DataSource.Type.FullTextIndex.toString());
		ss.setHostingNode("FTIndexGHNTwo");
		ss.setEndpoint("http://nowhere2.com/wsrf/index/fulltext");
		serviceItems.put(ss.getID(), ss);
		
		s = new FTIndexDao();
		s.setID("768a-8ab8-1281-9812");
		s.setType(DataSource.Type.FullTextIndex.toString());
		s.setFunctionality("search.index.ft");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:type");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:type");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		///////////////////////
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(serviceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
	}
	
	private static Set<IDaoElement> getFWIndex() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
		//return getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(),"Index", "ForwardIndexLookup", "search.index.fw",  DataSource.Type.ForwardIndex, "forward");
		return getDataSource(FWIndexDao.class.getName(), FWIndexServiceDao.class.getName(), "Index", "ForwardIndexNode", "search.index.fw", DataSource.Type.ForwardIndex, "forward index");
	}
	
	private static Set<IDaoElement> getGeoIndex() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.GeoIndex, GeoIndexService.class, GeoIndexServiceDao.class);
		return getDataSource(GeoIndexDao.class.getName(), GeoIndexServiceDao.class.getName(), "Index",  "GeoIndexLookup", "search.index.geo", DataSource.Type.GeoIndex, "geo");
	}
	
	private static Set<IDaoElement> getOpenSearchDataSource() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.OpenSearch, OpenSearchService.class, OpenSearchServiceDao.class);
		return getDataSource(OpenSearchDataSourceDao.class.getName(), OpenSearchDataSourceServiceDao.class.getName(),"OpenSearch", "OpenSearchDataSource",  "search.index.opensearch",  DataSource.Type.OpenSearch, "opensearch");
	}
	
	
	private static Set<IDaoElement> getFakeFWIndex() throws Exception
	{
		//DataSource.addSubType(DataSource.Type.ForwardIndex, FWIndexService.class, FWIndexServiceDao.class);
		
		Map<String, DataSourceDao> datasourceItems=new HashMap<String, DataSourceDao>();
		Map<String, DataSourceServiceDao> serviceItems=new HashMap<String, DataSourceServiceDao>();
		
		Set<FieldIndexContainerDao> fieldItems=new HashSet<FieldIndexContainerDao>();
		FWIndexServiceDao ss = new FWIndexServiceDao();
		ss.setID("8b77-1111-89b1-c128");
		ss.setType(DataSource.Type.ForwardIndex.toString());
		ss.setFunctionality("search.index.fw");
		ss.setHostingNode("FWIndexGHNOne");
		ss.setEndpoint("http://nowhere3.com/wsrf/index/forward");
		ss.getScopes().add("/no/scope/");
		serviceItems.put(ss.getID(), ss);
		
		FWIndexDao s = new FWIndexDao();
		s.setID("8b77-1111-89b1-c128");
		s.setType(DataSource.Type.ForwardIndex.toString());
		s.setFunctionality("search.index.fw");
		
		s.getCapabilities().clear();
		s.getCapabilities().add("any");
		
		s.getFields().clear();
		s.getScopes().add("/no/scope/");
		List<String> ff=new ArrayList<String>();
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:s:identifier");
		ff.add("3572c6f0-2f5e-11df-a838-c20ddc2e724e:en:p:identifier");
		for(String f:ff)
		{
			String []fparts=f.split(":");
			if(fparts.length!=4) continue;
			FieldIndexContainerDao fc=new FieldIndexContainerDao();
			fc.setID(s.getID()+":"+f);
			fc.setCollection(fparts[0]);
			fc.setLanguage(fparts[1]);
			fc.setFieldType(fparts[2]);
			fc.setField(fparts[3]);
			s.getFields().add(fc.getID());
			fieldItems.add(fc);
		}
		datasourceItems.put(s.getID(), s);
		////////////////////
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(datasourceItems.values());
		retValue.addAll(fieldItems);
		return retValue;
		
		//return getDataSource(FWIndexServiceDao.class.getName(), "ForwardIndexLookup", "Index", "search.index.fw", "forward");
	}
	
	private static Set<IDaoElement> getWorkflowService() throws Exception 
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		Map<String,WorkflowServiceDao> serviceItems=new HashMap<String,WorkflowServiceDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for workflow engine services in scope "+scope.toString());
			ISClient client =  GHNContext.getImplementation(ISClient.class);
			GCUBERIQuery query=client.getQuery(GCUBERIQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceName","WorkflowEngineService"));
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceClass","Execution"));
			List<GCUBERunningInstance> result=client.execute(query, scope);
			logger.log(Level.INFO,"Found "+result.size()+" services in scope");
			for(GCUBERunningInstance inst : result)
			{
				List<Endpoint> eprs= inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
				if(eprs.size()!=1) continue;
				if(serviceItems.containsKey(inst.getID())) serviceItems.get(inst.getID()).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
				else
				{
					WorkflowServiceDao s=new WorkflowServiceDao();
					s.setEndpoint(eprs.get(0).getValue());
					s.setFunctionality("execution.workflow");
					s.setID(inst.getID());
					s.setHostingNode(inst.getGHNID());
					s.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
					serviceItems.put(s.getID(), s);
				}
			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		return retValue;
	}
	
	private static Set<IDaoElement> getSearchService()
	{
		return searchSystemServices;
	}
	
	private static Set<IDaoElement> retrieveSearchService() throws Exception 
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		Map<String,SearchServiceDao> serviceItems=new HashMap<String,SearchServiceDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for search system services in scope "+scope.toString());
			ISClient client =  GHNContext.getImplementation(ISClient.class);
			GCUBERIQuery query=client.getQuery(GCUBERIQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceName","SearchSystemService"));
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceClass","Search"));
			List<GCUBERunningInstance> result=client.execute(query, scope);
			logger.log(Level.INFO,"Found "+result.size()+" services in scope");
			for(GCUBERunningInstance inst : result)
			{
				List<Endpoint> eprs= inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
				if(eprs.size()!=1) continue;
				if(serviceItems.containsKey(inst.getID())) serviceItems.get(inst.getID()).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
				else
				{
					SearchServiceDao s=new SearchServiceDao();
					s.setEndpoint(eprs.get(0).getValue());
					s.setFunctionality("search.orchestrator");
					s.setID(inst.getID());
					s.setHostingNode(inst.getGHNID());
					s.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
					serviceItems.put(s.getID(), s);
				}
			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		return retValue;
	}
	
	private static Set<IDaoElement> getExecutionServer() throws Exception 
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		Map<String,ExecutionServerDao> serverItems=new HashMap<String,ExecutionServerDao>();
		Map<String,ExecutionServiceDao> serviceItems=new HashMap<String,ExecutionServiceDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for execution engine services in scope "+scope.toString());
			ISClient client =  GHNContext.getImplementation(ISClient.class);
			GCUBERIQuery query=client.getQuery(GCUBERIQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceName","ExecutionEngineService"));
			query.addAtomicConditions(new AtomicCondition("/Profile/ServiceClass","Execution"));
			List<GCUBERunningInstance> result=client.execute(query, scope);
			logger.log(Level.INFO,"Found "+result.size()+" services in scope");
			for(GCUBERunningInstance inst : result)
			{
				List<Endpoint> eprs= inst.getAccessPoint().getRunningInstanceInterfaces().getEndpoint();
				if(eprs.size()!=1) continue;
				if(serviceItems.containsKey(inst.getID())) serviceItems.get(inst.getID()).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
				else
				{
					ExecutionServiceDao s=new ExecutionServiceDao();
					s.setEndpoint(eprs.get(0).getValue());
					s.setFunctionality("execution.execute");
					s.setID(inst.getID());
					s.setHostingNode(inst.getGHNID());
					s.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
					serviceItems.put(s.getID(), s);
				}
				String sd = inst.getSpecificData();
				if(sd==null || sd.trim().length()==0) continue;
				Document doc = XMLUtils.Deserialize(sd);
				List<Element> elems=XMLUtils.GetChildElementsWithName(doc.getDocumentElement(), "element");
				String hostname=null;
				String port=null;
				String elemId=null;
				for(Element el : elems)
				{
					elemId=XMLUtils.GetAttribute(el, "id");
					Element dynElem=XMLUtils.GetChildElementWithName(el, "dynamic");
					List<Element> dynPairs=XMLUtils.GetChildElementsWithName(dynElem, "entry");
					for(Element pair : dynPairs)
					{
						if(!XMLUtils.AttributeExists(pair, "pe2ng.port")) //this is preserved for backward compatibility
						{
							if(!XMLUtils.AttributeExists(pair, "key")) continue;
							String attrVal = XMLUtils.GetAttribute(pair, "key"); 
							if(attrVal != null && attrVal.equals("pe2ng.port"))
								port = XMLUtils.GetChildText(pair);
						}
						else port=XMLUtils.GetAttribute(pair, "pe2ng.port");
						if(!XMLUtils.AttributeExists(pair, "hostname")) //this is preserved for backward compatibility
						{
							if(!XMLUtils.AttributeExists(pair, "key")) continue;
							String attrVal = XMLUtils.GetAttribute(pair, "key"); 
							if(attrVal == null || !attrVal.equals("hostname")) continue;
							hostname = XMLUtils.GetChildText(pair);
						}
						else hostname=XMLUtils.GetAttribute(pair, "hostname");
						break;
					}
					if(port!=null && hostname!=null) break;
				}
				if(port!=null /*&& hostname!=null*/) //TODO see if host name is needed
				{
					if(serverItems.containsKey(elemId)) serverItems.get(elemId).getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
					else
					{
						ExecutionServerDao ss=new ExecutionServerDao();
						ss.setFunctionality("execution.execute");
						ss.setHostingNode(inst.getGHNID());
						ss.setID(elemId);
						ss.setHostname(hostname);
						ss.setPort(port);
						ss.getScopes().addAll(new HashSet<String>(inst.getScopes().keySet()));
						serverItems.put(ss.getID(), ss);
					}
				}
			}
		}
		Set<IDaoElement> retValue=new HashSet<IDaoElement>();
		retValue.addAll(serviceItems.values());
		retValue.addAll(serverItems.values());
		logger.log(Level.INFO,"Found "+serverItems.values().size()+" execution servers");
		return retValue;
	}
	
	private static Set<IDaoElement> getFunctionality() throws Exception 
	{
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		FunctionalityDao f=new FunctionalityDao();
		f.setName("execution.execute");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("execution.workflow");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.ft");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.fw");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.geo");
		items.add(f);
		f=new FunctionalityDao();
		f.setName("search.index.opensearch");
		items.add(f);
		return items;
	}
	
	private static Set<IDaoElement> getHostingNodes() throws Exception 
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		HashMap<String, HostingNodeDao> items=new HashMap<String, HostingNodeDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for hosting nodes in scope "+scope.toString());
			ISClient client =  GHNContext.getImplementation(ISClient.class);
			GCUBEGHNQuery query=client.getQuery(GCUBEGHNQuery.class);
			List<GCUBEHostingNode> result=client.execute(query, scope);
			logger.log(Level.INFO,"Found "+result.size()+" nodes in scope");
			for(GCUBEHostingNode node : result)
			{
				if(items.containsKey(node.getID()))
				{
					items.get(node.getID()).getScopes().addAll(node.getScopes().keySet());
					//logger.log(Level.INFO, "updated node of : \n"+items.get(node.getID()).deepToString());
				}
				else
				{			
					HostingNodeDao item=new HostingNodeDao();
					item.setID(node.getID());
					item.setScopes(new HashSet<String>(node.getScopes().keySet()));
					try{item.getPairKeys().add("hn.infrastructure"); item.getPairValues().add("hn.infrastructure"+ HostingNode.KeyValueDelimiter+ node.getInfrastructure());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.country"); item.getPairValues().add("hn.country"+ HostingNode.KeyValueDelimiter+ node.getSite().getCountry());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.domain"); item.getPairValues().add("hn.domain"+ HostingNode.KeyValueDelimiter+ node.getSite().getDomain());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.latitude"); item.getPairValues().add("hn.latitude"+ HostingNode.KeyValueDelimiter+ node.getSite().getLatitude());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.longitude"); item.getPairValues().add("hn.longitude"+ HostingNode.KeyValueDelimiter+ node.getSite().getLongitude());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.location"); item.getPairValues().add("hn.location"+ HostingNode.KeyValueDelimiter+ node.getSite().getLocation());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.platform"); item.getPairValues().add("hn.architecture.platform"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getArchitecture().getPlatformType());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.smp"); item.getPairValues().add("hn.architecture.smp"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getArchitecture().getSMPSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.architecture.smt"); item.getPairValues().add("hn.architecture.smt"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getArchitecture().getSMTSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.benchmark.sf00"); item.getPairValues().add("hn.benchmark.sf00"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getBenchmark().getSF00()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.benchmark.si00"); item.getPairValues().add("hn.benchmark.si00"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getBenchmark().getSI00()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_day"); item.getPairValues().add("hn.load.one_day"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Day()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_hour"); item.getPairValues().add("hn.load.one_hour"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Hour()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_week"); item.getPairValues().add("hn.load.one_week"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getHistoricalLoad().getLast1Week()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.one_min"); item.getPairValues().add("hn.load.one_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getLoad().getLast1min()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.five_min"); item.getPairValues().add("hn.load.five_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getLoad().getLast5min()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.load.fifteen_min"); item.getPairValues().add("hn.load.fifteen_min"+ HostingNode.KeyValueDelimiter+ Double.toString(node.getNodeDescription().getLoad().getLast15min()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.disk.size"); item.getPairValues().add("hn.disk.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getLocalAvailableSpace()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.physical.available"); item.getPairValues().add("hn.memory.physical.available"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getMemory().getAvailable()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.physical.size"); item.getPairValues().add("hn.memory.physical.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getMemory().getSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.virtual.size"); item.getPairValues().add("hn.memory.virtual.size"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getMemory().getVirtualSize()));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.memory.virtual.available"); item.getPairValues().add("hn.memory.virtual.available"+ HostingNode.KeyValueDelimiter+ Long.toString(node.getNodeDescription().getMemory().getVirtualAvailable()));}catch(Exception ex){}
					try{item.getPairKeys().add("hostname"); item.getPairValues().add("hostname"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getName().substring(0, node.getNodeDescription().getName().lastIndexOf(':')));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.port"); item.getPairValues().add("hn.port"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getName().substring(node.getNodeDescription().getName().lastIndexOf(':')+1));}catch(Exception ex){}
					try{item.getPairKeys().add("hn.hostname"); item.getPairValues().add("hn.hostname"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getName());}catch(Exception ex){}
					int count=0;
					try{
						for(NetworkAdapter nadp : node.getNodeDescription().getNetworkAdapters())
						{
							try{item.getPairKeys().add("hn.network.adapter."+count+".inbound.ip"); item.getPairValues().add("hn.network.adapter."+count+".inbound.ip"+ HostingNode.KeyValueDelimiter+ nadp.getInboundIP());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".ip.address"); item.getPairValues().add("hn.network.adapter."+count+".ip.address"+ HostingNode.KeyValueDelimiter+ nadp.getIPAddress());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".mtu"); item.getPairValues().add("hn.network.adapter."+count+".mtu"+ HostingNode.KeyValueDelimiter+ Long.toString(nadp.getMTU()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".name"); item.getPairValues().add("hn.network.adapter."+count+".name"+ HostingNode.KeyValueDelimiter+ nadp.getName());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.network.adapter."+count+".outbound.ip"); item.getPairValues().add("hn.network.adapter."+count+".outbound.ip"+ HostingNode.KeyValueDelimiter+ nadp.getOutboundIP());}catch(Exception ex){}
							count+=1;
						}
					}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.name"); item.getPairValues().add("hn.os.name"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getOS().getName());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.release"); item.getPairValues().add("hn.os.release"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getOS().getRelease());}catch(Exception ex){}
					try{item.getPairKeys().add("hn.os.version"); item.getPairValues().add("hn.os.version"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getOS().getVersion());}catch(Exception ex){}
					count=0;
					try{
						long totalBogoMips = 0;
						long totalClockSpeed = 0;
						for(Processor pr : node.getNodeDescription().getProcessors())
						{
							try{item.getPairKeys().add("hn.processor."+count+".bogomips"); item.getPairValues().add("hn.processor."+count+".bogomips"+ HostingNode.KeyValueDelimiter+ Double.toString(pr.getBogomips())); totalBogoMips+=pr.getBogomips();}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1"); item.getPairValues().add("hn.processor."+count+".cache.l1"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.getCacheL1()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1d"); item.getPairValues().add("hn.processor."+count+".cache.l1d"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.getCacheL1D()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l1i"); item.getPairValues().add("hn.processor."+count+".cache.l1i"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.getCacheL1I()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".cache.l2"); item.getPairValues().add("hn.processor."+count+".cache.l2"+ HostingNode.KeyValueDelimiter+ Long.toString(pr.getCacheL2()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".clockspeed"); item.getPairValues().add("hn.processor."+count+".clockspeed"+ HostingNode.KeyValueDelimiter+ Double.toString(pr.getClockSpeedMHZ())); totalClockSpeed+=pr.getClockSpeedMHZ();}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".family"); item.getPairValues().add("hn.processor."+count+".clockspeed"+ HostingNode.KeyValueDelimiter+ pr.getFamily());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".model"); item.getPairValues().add("hn.processor."+count+".model"+ HostingNode.KeyValueDelimiter+ pr.getModel());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".model_name"); item.getPairValues().add("hn.processor."+count+".model_name"+ HostingNode.KeyValueDelimiter+ pr.getModelName());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.processor."+count+".vendor"); item.getPairValues().add("hn.processor."+count+".vendor"+ HostingNode.KeyValueDelimiter+ pr.getVendor());}catch(Exception ex){}
							count+=1;
						}
						item.getPairKeys().add("hn.processor.count"); item.getPairValues().add("hn.processor.count" + HostingNode.KeyValueDelimiter + Integer.toString(count));
						item.getPairKeys().add("hn.processor.total_bogomips"); item.getPairValues().add("hn.processor.total_bogomips" + HostingNode.KeyValueDelimiter + Long.toString(totalBogoMips));
						item.getPairKeys().add("hn.processor.total_clockspeed"); item.getPairValues().add("hn.processor.total_clockspeed" + HostingNode.KeyValueDelimiter + Long.toString(totalClockSpeed));
					}catch(Exception ex){}
					try{item.getPairKeys().add("hn.status"); item.getPairValues().add("hn.status"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getStatus().toString());}catch(Exception ex){}
					count=0;
					try{
						for(StorageDevice sd : node.getNodeDescription().getStorageDevices())
						{
							try{item.getPairKeys().add("hn.disk.device."+count+".name"); item.getPairValues().add("hn.disk.device."+count+".name"+ HostingNode.KeyValueDelimiter+ sd.getName());}catch(Exception ex){}
							try{item.getPairKeys().add("hn.disk.device."+count+".size"); item.getPairValues().add("hn.disk.device."+count+".size"+ HostingNode.KeyValueDelimiter+ Long.toString(sd.getSize()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.disk.device."+count+".transfer_rate"); item.getPairValues().add("hn.disk.device."+count+".transfer_rate"+ HostingNode.KeyValueDelimiter+ Long.toString(sd.getTransferRate()));}catch(Exception ex){}
							try{item.getPairKeys().add("hn.disk.device."+count+".type"); item.getPairValues().add("hn.disk.device."+count+".type"+ HostingNode.KeyValueDelimiter+ sd.getType());}catch(Exception ex){}
							int newCount=0;
							try{
								for(StoragePartition sdp : sd.getPartitions().values())
								{
									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".name"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".name"+ HostingNode.KeyValueDelimiter+ sdp.getName());}catch(Exception ex){}
									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".read_rate"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".read_rate"+ HostingNode.KeyValueDelimiter+Long.toString(sdp.getReadRate()));}catch(Exception ex){}
									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".size"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".size"+ HostingNode.KeyValueDelimiter+ sdp.getSize());}catch(Exception ex){}
									try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".write_rate"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".write_rate"+ HostingNode.KeyValueDelimiter+Long.toString(sdp.getWriteRate()));}catch(Exception ex){}
									int deepCount=0;
									try{
										for(FileSystem sdpfs : sdp.getFileSystems().values())
										{
											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".name"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".name"+ HostingNode.KeyValueDelimiter+sdpfs.getName());}catch(Exception ex){}
											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".root"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".root"+ HostingNode.KeyValueDelimiter+sdpfs.getRoot());}catch(Exception ex){}
											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".size"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".size"+ HostingNode.KeyValueDelimiter+Long.toString(sdpfs.getSize()));}catch(Exception ex){}
											try{item.getPairKeys().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".type"); item.getPairValues().add("hn.disk.device."+count+".partition."+newCount+".filesystem."+deepCount+".type"+ HostingNode.KeyValueDelimiter+sdpfs.getType());}catch(Exception ex){}
											deepCount+=1;
										}
									}catch(Exception ex){}
									newCount+=1;
								}
							}catch(Exception ex){}
							count+=1;
						}
					}catch(Exception ex){}
					try{item.getPairKeys().add("hn.uptime"); item.getPairValues().add("hn.uptime"+ HostingNode.KeyValueDelimiter+ node.getNodeDescription().getUptime());}catch(Exception ex){}
					try{
						for(GCUBEHostingNode.Package pkg : node.getDeployedPackages())
						{
							String identifier=pkg.getServiceClass()+"."+pkg.getServiceName()+"."+pkg.getPackageName();
							try{item.getPairKeys().add("software."+identifier+".deployed"); item.getPairValues().add("software."+identifier+".deployed"+ HostingNode.KeyValueDelimiter+ "true");}catch(Exception ex){}
							try{item.getPairKeys().add("software."+identifier+".service_version"); item.getPairValues().add("software."+identifier+".service_version"+ HostingNode.KeyValueDelimiter+ pkg.getServiceVersion());}catch(Exception ex){}
							try{item.getPairKeys().add("software."+identifier+".package_version"); item.getPairValues().add("software."+identifier+".package_version"+ HostingNode.KeyValueDelimiter+ pkg.getPackageVersion());}catch(Exception ex){}
						}
					}catch(Exception ex){}
					try{
						for(Variable var : node.getNodeDescription().getRuntime().getVariables())
						{
							try{item.getPairKeys().add(var.getKey()); item.getPairValues().add(var.getKey()+ HostingNode.KeyValueDelimiter+ var.getValue());}catch(Exception ex){}

						}
					}catch(Exception ex){}
					items.put(item.getID(), item);
					//logger.log(Level.INFO, "added hosting node of : \n"+item.deepToString());
				}
			}
		}
		return new HashSet<IDaoElement>(items.values());
	}
	
	private static Set<IDaoElement> getAllCollections() throws Exception {
		Set<IDaoElement> dataCollections = new HashSet<IDaoElement>();
		dataCollections.addAll(getDataCollections());
		dataCollections.addAll(getTreeCollections());
		
		return dataCollections;
	}
	
	
	private static Set<IDaoElement> getDataCollections() throws Exception 
	{
		GCUBEScope []scopes = BridgeHelper.scopes;
		
		
		HashMap<String, DataCollectionDao> hcols=new HashMap<String, DataCollectionDao>();
		for(GCUBEScope scope : scopes)
		{
			logger.log(Level.INFO,"Searching for collection in scope "+scope.toString());
			ISClient client = GHNContext.getImplementation(ISClient.class);
			GCUBEGenericResourceQuery query = client.getQuery(GCUBEGenericResourceQuery.class);
			query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", "GCUBECollection"));

			List<GCUBEGenericResource> resources = client.execute(query, scope);
			
			logger.log(Level.INFO, "Found : " + resources.size() + " collections");
			
			for (GCUBEGenericResource resource : resources) {
				 String id = resource.getID();
				 logger.log(Level.INFO, "Found collection with id : " + id);
				 if (hcols.containsKey(id)) {
					 hcols.get(id).getScopes().add(scope.toString());
				 } else {
					String name = resource.getName();
					logger.log(Level.INFO, "collection with id : " + id + " has name : " + name);
					String description = resource.getDescription();
					CollectionDescription collectionDescription = CollectionDescription.getCollection(resource);
					Boolean isUserCollection = collectionDescription.isUser();
					Calendar creationTime = collectionDescription.getCreationTime();
					
					if(!isUserCollection) continue;
					DataCollectionDao d=new DataCollectionDao();
					d.setID(id);
					d.setDescription(description);
					if(creationTime != null) d.setCreationTime(Long.toString(creationTime.getTimeInMillis()));
					d.setName(name);
					d.getScopes().add(scope.toString());
					hcols.put(d.getID(), d);
					if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
					if(d.getName().trim().length()==0) d.setName(null);
					Set<String> toDel=new HashSet<String>();
					for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
					d.getScopes().removeAll(toDel);
				 }
				
			}
			
			
//			logger.log(Level.INFO,"Searching for collection in scope "+scope.toString());
//			List<Collection> cols = org.gcube.contentmanagement.gcubedocumentlibrary.util.Collections.list(scope);
//			
//			logger.log(Level.INFO,"Found "+cols.size()+" collections in scope");
//			for(Collection col : cols)
//			{
//				if(hcols.containsKey(col.getId()))
//				{
//					hcols.get(col.getId()).getScopes().add(scope.toString());
//					//logger.log(Level.INFO, "updated collection of : \n"+hcols.get(col.getId()).deepToString());
//				}
//				else
//				{
//					if(!col.isUserCollection()) continue;
//					DataCollectionDao d=new DataCollectionDao();
//					d.setID(col.getId());
//					d.setDescription(col.getDescription());
//					if(col.getCreationTime() != null) d.setCreationTime(Long.toString(col.getCreationTime().getTimeInMillis()));
//					d.setName(col.getName());
//					d.getScopes().add(scope.toString());
//					hcols.put(d.getID(), d);
//					if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
//					if(d.getName().trim().length()==0) d.setName(null);
//					Set<String> toDel=new HashSet<String>();
//					for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
//					d.getScopes().removeAll(toDel);
//					//logger.log(Level.INFO, "added collection of : \n"+d.deepToString());
//				}
//			}
		}
		return new HashSet<IDaoElement>(hcols.values());
	}
	
	private static final String JNDI_NAME = "gcube/data/tm";
	private static final String TREADER_NAME = JNDI_NAME+"/reader";
	private static final String SOURCENAME_RPNAME = "Name";
	private static final String SOURCEID_RPNAME = "SourceId";
	private static final String CARDINALITY_RPNAME = "Cardinality";
	
	public static Set<IDaoElement> getTreeCollections() throws Exception {
		//String xquery = "declare namespace is = 'http://gcube-system.org/namespaces/informationsystem/registry'; declare namespace gc = 'http://gcube-system.org/namespaces/common/core/porttypes/GCUBEProvider'; for $result in collection("/db/Properties")//Document  where ($result/Data/child::*[local-name()='ServiceName']/string() eq 'tree-manager-service')   and ($result/SourceKey/string() ne 'binder')  and ($result/SourceKey/string() ne 'manager')  return $result";
		GCUBEScope []scopes = BridgeHelper.scopes;
		HashMap<String, DataCollectionDao> hcols=new HashMap<String, DataCollectionDao>();
		ISClient client = GHNContext.getImplementation(ISClient.class);
		for(GCUBEScope scope : scopes) {
			 logger.log(Level.INFO,"Searching for tree collection in scope : " + scope);
			 WSResourceQuery query = client.getQuery(WSResourceQuery.class);
			    	query.addAtomicConditions(
			    		new AtomicCondition("//gc:ServiceName", "tree-manager-service"), new AtomicCondition("//gc:ServiceClass", "DataAccess")
			    );
			    List<RPDocument> results = client.execute(query, scope);
			    for (RPDocument result : results) {
			    	
			    	try {
					    String endpoint = result.getEndpoint().getAddress().getPath();
					    if (endpoint.endsWith(TREADER_NAME)) {
					    	logger.log(Level.INFO, "Parsing tree...");
					    	String name = result.evaluate("//*[local-name()='"+SOURCENAME_RPNAME+"']/text()").get(0);
					    	logger.log(Level.INFO, "\t name : "+name);
					    	String id = result.evaluate("//*[local-name()='"+SOURCEID_RPNAME+"']/text()").get(0);
					    	logger.log(Level.INFO, "\t id : "+id);
					    	
					    	logger.log(Level.INFO, "Parsing tree...OK");
					    	
					    	//String totalItems = result.evaluate("//*[local-name()='"+CARDINALITY_RPNAME+"']/text()").get(0);
					    	String description = null;
					    	String creationTime = null;
					    	
					    	///logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + ", totalItems = " + totalItems + " ] ");
					    	logger.log(Level.INFO,"Parsed elements from xml : [id = " + id +", name = " + name + " ] ");
					    	
					    	if(hcols.containsKey(id))
							{
								hcols.get(id).getScopes().add(scope.toString());
								logger.log(Level.INFO, "updated collection of : \n"+hcols.get(id).deepToString());
							}
							else
							{
						    	DataCollectionDao d=new DataCollectionDao();
						    	d.setID(id);
						    	d.setName(name);
						    	d.setDescription(description);
						    	d.setCreationTime(creationTime);
						    	if(d.getDescription() == null || d.getDescription().trim().length()==0) d.setDescription(null);
								if(d.getName().trim().length()==0) d.setName(null);
						    	if (creationTime == null || creationTime.trim().length() == 0) d.setCreationTime(null);
						    	d.getScopes().add(scope.toString());
						    	
						    	hcols.put(d.getID(), d);
						    	
						    	Set<String> toDel=new HashSet<String>();
								for(String s : d.getScopes()) if(s.trim().length()==0) toDel.add(s);
								d.getScopes().removeAll(toDel);
								
								logger.log(Level.INFO, "added collection : \n"+hcols.get(id).deepToString());
							}
					    }
				    
			    	}catch (Exception e) {
				    	logger.log(Level.WARNING, "Error while retrieving-parsing the tree manager collection");
				    }
				    
			    }
		}
		return new HashSet<IDaoElement>(hcols.values());	
	}
	
	private static Set<IDaoElement> getFields() throws Exception
	{
		//TODO remove
//		if(!ResourceRegistry.isInitialBridgingComplete()) 
//		{
//			System.out.println("Starting second incoming field bridging. Continue...");
//			BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
//			br.readLine();
//		}
		logger.info("Searching for fields");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields") , "field");
		if(xmlObjs.size()!=0)
			flatModel = true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
			
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
					FieldDao f=new FieldDao();
					f.fromXML(elem);
					items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fieldInfo") , "field");
					for(Element elem : xmlObjs)
					{
						FieldDao f=new FieldDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " fields");
		return items;
	}
	
	private static Set<IDaoElement> getSearchables() throws Exception
	{
		logger.info("Searching for searchables");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "searchables") , "searchable");
		if(xmlObjs.size()!=0)
			flatModel=true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
		
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
				SearchableDao f=new SearchableDao();
				f.fromXML(elem);
				items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "searchables") , "searchable");
					for(Element elem : xmlObjs)
					{
						SearchableDao f=new SearchableDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " searchables");
		return items;
	}
	
	private static Set<IDaoElement> getPresentables() throws Exception
	{
		logger.info("Searching for presentables");
		Set<IDaoElement> items=new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String fieldsResource=FieldModel.getMainResource();
		if(fieldsResource != null) fieldsDOM = XMLUtils.Deserialize(fieldsResource);
		else return items;
		boolean flatModel = false;
		List<Element> xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "presentables") , "presentable");
		if(xmlObjs.size()!=0)
			flatModel=true;
		else
			xmlObjs =XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "fields"), "fieldId");
		
		if(flatModel)
		{
			for(Element elem : xmlObjs)
			{
				PresentableDao f=new PresentableDao();
				f.fromXML(elem);
				items.add(f);
			}
		}
		else
		{
			Set<String> fieldIds = FieldModel.getFieldIds();
			for(String fieldId : fieldIds)
			{
				String fieldResource=FieldModel.getFieldResource(fieldId);
				if(fieldResource != null) 
				{
					fieldsDOM = XMLUtils.Deserialize(fieldResource);
					xmlObjs = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "presentables") , "presentable");
					for(Element elem : xmlObjs)
					{
						PresentableDao f=new PresentableDao();
						f.fromXML(elem);
						items.add(f);
					}
				}
			}
		}
		logger.info("Found " + items.size() + " presentables");
		return items;
	}
	
	private static Set<IDaoElement> getElementMetadata() throws Exception
	{
		logger.info("Searching for element metadata");
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		Document fieldsDOM=null;
		String resource = null;
		String fieldsResource = null;
		String metadataResource = FieldModel.getMetadataResource();
		if(metadataResource == null)
		{
			fieldsResource = FieldModel.getMainResource();
			resource = fieldsResource;
		}
		else
			resource = metadataResource;
		
		if(resource != null) fieldsDOM = XMLUtils.Deserialize(resource);
		else return items;
		
		List<Element> xmlObjs = null;
		Element metadataElement = XMLUtils.GetChildElementWithName(fieldsDOM.getDocumentElement(), "metadata");
		if(metadataElement==null) return items;
		
		xmlObjs = XMLUtils.GetChildElementsWithName(metadataElement, "elementMetadata");
		for(Element elem : xmlObjs)
		{
			ElementMetadataDao s=new ElementMetadataDao();
			s.fromXML(elem);
			items.add(s);
		}
		logger.info("Found " + items.size() + " element metadata");
		return items;
	}

	private static Set<IDaoElement> getStaticConfiguration() throws Exception
	{
		logger.info("Searching for static configuration");
		Set<IDaoElement> items = new HashSet<IDaoElement>();
		Document staticConfigDOM=null;
		String staticConfigResource = FieldModel.getStaticConfigResource();
		
		if(staticConfigResource != null) staticConfigDOM = XMLUtils.Deserialize(staticConfigResource);
		else return items;
		
		//Element staticConfigElement = XMLUtils.GetChildElementWithName(staticConfigDOM.getDocumentElement(), "staticConfiguration");
		//if(staticConfigElement==null) return items;
		
		StaticConfigurationDao item = new StaticConfigurationDao();
		item.fromXML(staticConfigDOM.getDocumentElement());
		
		items.add(item);
		
		logger.info("Found " + items.size() + " static configuration");
		return items;
	}
	
	private static GCUBEGenericResource getMostRecentResource(List<GCUBEGenericResource> resources) throws Exception
	{
		long mostRecentTime=-1;
		GCUBEGenericResource mostRecentResource=null;
		for(GCUBEGenericResource resource : resources)
		{
			long updateTime=0;
			try{updateTime = Long.parseLong(resource.getDescription());}catch(Exception ex){continue;}
			if(updateTime> mostRecentTime) mostRecentResource=resource;
		}
		return mostRecentResource;
	}
	
	public static List<GCUBEGenericResource> getPublishedFieldResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName);
	}
	
	public static List<GCUBEGenericResource> getPublishedMetadataResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "Metadata");
	}
	
	public static List<GCUBEGenericResource> getPublishedStaticConfigResources() throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + "StaticConfig");
	}
	
	public static List<GCUBEGenericResource> getPublishedFieldResourcesForField(String fieldId) throws Exception
	{
		return getPublishedFieldResources(GCubeRepositoryProvider.RRModelGenericResourceName + "." + fieldId);
	}
	
	public static List<GCUBEGenericResource> getPublishedFieldResources(String resourceName) throws Exception
	{
		//logger.log(Level.INFO, "getPublishedFieldResources: RR Classloader=" + Thread.currentThread().getContextClassLoader().getClass().getName());
		//logger.log(Level.INFO, "GHNContext Classloader: " + GHNContext.class.getClassLoader());
		ISClient client = null;
		GCUBEGenericResourceQuery query = null;
		client =  GHNContext.getImplementation(ISClient.class);
		query = client.getQuery(GCUBEGenericResourceQuery.class);
		
		query.addAtomicConditions(new AtomicCondition("/Profile/SecondaryType", GCubeRepositoryProvider.RRModelGenericResourceName));
		query.addAtomicConditions(new AtomicCondition("/Profile/Name", resourceName));
		
		GCUBEScope []scopes = BridgeHelper.scopes;
		
		List<GCUBEGenericResource> resources=new ArrayList<GCUBEGenericResource>();
		for(GCUBEScope scope : scopes) resources.addAll(client.execute(query,scope));
		return resources;

	}
	
	public static void publishFieldResource(GCUBEGenericResource resource, boolean isNew) throws Exception
	{
		logger.log(Level.INFO, "publishing information on IS");
		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
		ISPublisher publish =  GHNContext.getImplementation(ISPublisher.class);
		for(GCUBEScope scope : BridgeHelper.getFieldModelScopes())
		{
			if(isNew)publish.registerGCUBEResource(resource, scope, managerSec);
			else publish.updateGCUBEResource(resource, scope, managerSec);
		}
		logger.log(Level.INFO, "done publishing information on IS");
	}
	
	public static void deleteFieldResource(GCUBEGenericResource resource) throws Exception
	{
		logger.log(Level.INFO, "Deleting information from IS");
		GCUBESecurityManagerImpl managerSec = new GCUBESecurityManagerImpl() {  public boolean isSecurityEnabled() {return false;}};
		ISPublisher publish =  GHNContext.getImplementation(ISPublisher.class);
		for(GCUBEScope scope : BridgeHelper.getFieldModelScopes())
		{
			publish.removeGCUBEResource(resource.getID(), resource.getType(), scope, managerSec);
		}
		logger.log(Level.INFO, "done deleting information from IS");
	}
	
	public static String buildFieldDirectorySerialization(Set<IDaoElement> fields) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<fields>\n");
		for(IDaoElement elem : fields)
		{
			buf.append("<fieldId>");
			buf.append(((FieldDao)elem).getID());
			buf.append("</fieldId>");
		}
		buf.append("</fields>\n");	
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildFieldSerialization(IDaoElement field,Set<IDaoElement> searchables,Set<IDaoElement> presentables) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<fieldInfo>\n");
		buf.append(field.toXML());
		buf.append("</fieldInfo>\n");
		buf.append("<searchables>\n");
		for(String searchableId : ((FieldDao)field).getSearchables()) 
		{
			for(IDaoElement elem : searchables)
			{
				if(elem.getID().equals(searchableId))
					buf.append(elem.toXML());
			}
		}
		buf.append("</searchables>\n");
		buf.append("<presentables>\n");
		for(String presentableId : ((FieldDao)field).getPresentables()) 
		{
			for(IDaoElement elem :presentables)
			{
				if(elem.getID().equals(presentableId))
					buf.append(elem.toXML());
			}
		}
		buf.append("</presentables>\n");
		
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String updateFieldSerialization(String originalSerialization, IDaoElement field,Set<IDaoElement> searchables,Set<IDaoElement> presentables,
			boolean updateFields, boolean updateSearchables, boolean updatePresentables) throws Exception
	{
		Document original = XMLUtils.Deserialize(originalSerialization);
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		if(updateFields)
		{
			if(updateSearchables && updatePresentables)
			{
				buf.append("<fieldInfo>\n");
				buf.append(field.toXML());
				buf.append("</fieldInfo>\n");
			}else
			{
				Element originalField = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(original.getDocumentElement(), "fieldInfo"), "field").get(0);
				buf.append("<fieldInfo>\n");
				FieldDao updatedDao = new FieldDao();
				Document dbField = XMLUtils.Deserialize(field.toXML());
				
				updatedDao.setID(((FieldDao)field).getID());
				updatedDao.setName(((FieldDao)field).getName());
				updatedDao.setDescription(((FieldDao)field).getDescription());
			
				Set<String> updatedSearchables = new HashSet<String>();
				if(updateSearchables)
				{
					//the searchables of this field as retrieved from the database (updated)
					List<Element> dbSearchables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(dbField.getDocumentElement(), "searchables") , "searchable");
					for(Element dbSearchable : dbSearchables)
						updatedSearchables.add(dbSearchable.getFirstChild().getNodeValue());
				}else 
				{
					//the searchables of this field as retrieved from the is (original)
					List<Element> originalSearchables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(originalField, "searchables"), "searchable");
					for(Element originalSearchable : originalSearchables)
						updatedSearchables.add(originalSearchable.getFirstChild().getNodeValue());
				}
				
				Set<String> updatedPresentables = new HashSet<String>();
				if(updatePresentables)
				{
					//the presentables of this field as retrieved from the database (updated)
					List<Element> dbPresentables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(dbField.getDocumentElement(), "presentables") , "presentable");
					for(Element dbPresentable : dbPresentables)
						updatedPresentables.add(dbPresentable.getFirstChild().getNodeValue());
				}else 
				{
					//the presentables of this field as retrieved from the is (original)
					List<Element> originalPresentables = XMLUtils.GetChildElementsWithName(XMLUtils.GetChildElementWithName(originalField, "presentables"), "presentable");
					for(Element originalPresentable : originalPresentables)
						updatedPresentables.add(originalPresentable.getFirstChild().getNodeValue());
				}
				
				updatedDao.setSearchables(updatedSearchables);
				updatedDao.setPresentables(updatedPresentables);
				
				buf.append(updatedDao.toXML());
				buf.append("</fieldInfo>\n");
			}
		}else 
		{
			Element originalFields = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "fieldInfo");
			buf.append(XMLUtils.Serialize(originalFields, true));
		}
		
		if(updateSearchables)
		{
			buf.append("<searchables>\n");
			for(String searchableId : ((FieldDao)field).getSearchables()) 
			{
				for(IDaoElement elem : searchables)
				{
					if(elem.getID().equals(searchableId))
						buf.append(elem.toXML());
				}
			}
			buf.append("</searchables>\n");
		}else
		{
			Element originalSearchables = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "searchables");
			buf.append(XMLUtils.Serialize(originalSearchables, true));
		}
		
		if(updatePresentables)
		{
			buf.append("<presentables>\n");
			for(String presentableId : ((FieldDao)field).getPresentables()) 
			{
				for(IDaoElement elem :presentables)
				{
					if(elem.getID().equals(presentableId))
						buf.append(elem.toXML());
				}
			}
			buf.append("</presentables>\n");
		}else
		{
			Element originalPresentables = XMLUtils.GetChildElementWithName(original.getDocumentElement(), "presentables");
			buf.append(XMLUtils.Serialize(originalPresentables, true));
		}
		
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildElementMetadataSerialization(Set<IDaoElement> metadata) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append("<root>\n");
		buf.append("<metadata>\n");
		for(IDaoElement elem : metadata) buf.append(elem.toXML());
		buf.append("</metadata>\n");
		buf.append("</root>\n");
		return buf.toString();
	}
	
	public static String buildStaticConfigSerialization(IDaoElement staticConfig) throws ResourceRegistryException
	{
		StringBuilder buf=new StringBuilder();
		buf.append(staticConfig.toXML());
		return buf.toString();
	}
	
	public static void prefetchInMemoryItems(Set<Class<?>> itemTypes) throws ResourceRegistryException
	{
		InMemoryStore.clear();
		
		Map<String, ElementMetadataDao> metadata = new HashMap<String, ElementMetadataDao>();
		Set<IDaoElement> metadataSet = null;
		try { metadataSet = DatastoreHelper.getItems(DatastoreType.LOCAL, ElementMetadataDao.class); }
		catch(Exception e) { throw new ResourceRegistryException("Could not retrieve element metadata", e); }
		for(IDaoElement m : metadataSet)
			metadata.put(m.getID(), (ElementMetadataDao)m);
		
		boolean baseDatasource = false;
		for(Class<?> itemType : itemTypes)
		{
			if(itemType.getName().equals(DataSource.class.getName()))
			{
				baseDatasource = true;
				break;
			}
		}
		boolean baseDatasourceService = false;
		for(Class<?> itemType : itemTypes)
		{
			if(itemType.getName().equals(DataSourceService.class.getName()))
			{
				baseDatasourceService = true;
				break;
			}
		}
		for(Class<?> itemType : itemTypes)
		{
			logger.log(Level.INFO, "Prefetching element " + itemType.getName());
			if(itemType.getName().equals(DataCollection.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<DataCollection>(DataCollection.getAllCollections(false)));
			else if(itemType.getName().equals(DataLanguage.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<DataLanguage>(DataLanguage.getLanguages()));
			else if(itemType.getName().equals(Functionality.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<Functionality>(Functionality.getAllFunctionalities(false)));
			else if(itemType.getName().equals(HostingNode.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<HostingNode>(HostingNode.getAll(false)));
			else if(itemType.getName().equals(Field.class.getName()))
				InMemoryStore.setItems(itemType, new HashSet<Field>(Field.getAll(false)));
			else if(itemType.getName().equals(Searchable.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, SearchableDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch searchables", e); }
				for(IDaoElement item : items)
				{
					Searchable loaded = new Searchable();
					loaded.setID(((SearchableDao)item).getID());
					loaded.load(false);
					if(!(metadata.containsKey(loaded.getField()) && metadata.get(loaded.getField()).getType().equals(ElementMetadata.Type.DeletedField.toString())))
						InMemoryStore.setItem(Searchable.class, loaded);
				}
			}
			else if(itemType.getName().equals(Presentable.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, PresentableDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch presentables", e); }
				for(IDaoElement item : items)
				{
					Presentable loaded = new Presentable();
					loaded.setID(((PresentableDao)item).getID());
					loaded.load(false);
					if(!(metadata.containsKey(loaded.getField()) && metadata.get(loaded.getField()).getType().equals(ElementMetadata.Type.DeletedField.toString())))
						InMemoryStore.setItem(Presentable.class, loaded);
				}
			}
			else if(itemType.getName().equals(DataSource.class.getName()))
			{
				List<DataSource> ds = DataSource.getAll(false);
				for(DataSource d : ds)
					InMemoryStore.setItem(d.getClass(), d);	
			}
			else if(itemType.getName().equals(DataSourceService.class.getName()))
			{
				List<DataSourceService> ds = DataSourceService.getAll(false);
				for(DataSourceService d : ds)
					InMemoryStore.setItem(d.getClass(), d);	
			}
			else if(itemType.getName().equals(FTIndex.class.getName()))
			{
				if(baseDatasource==false)
					InMemoryStore.setItems(FTIndex.class, new HashSet<DataSource>(FTIndex.getAll(false)));
			}
			else if(itemType.getName().equals(FTIndexService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(FTIndexService.class, new HashSet<DataSourceService>(FTIndexService.getAll(false)));
			}
			else if(itemType.getName().equals(FWIndex.class.getName()))
			{
				if(baseDatasource == false)
					InMemoryStore.setItems(FWIndex.class, new HashSet<DataSource>(FWIndex.getAll(false)));
			}
			else if(itemType.getName().equals(FWIndexService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(FWIndexService.class, new HashSet<DataSourceService>(FWIndexService.getAll(false)));
			}
			else if(itemType.getName().equals(GeoIndex.class.getName()))
			{
				if(baseDatasource == false)
					InMemoryStore.setItems(GeoIndex.class, new HashSet<DataSource>(GeoIndex.getAll(false)));
			}
			else if(itemType.getName().equals(GeoIndexService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(GeoIndexService.class, new HashSet<DataSourceService>(GeoIndexService.getAll(false)));
			}
			else if(itemType.getName().equals(OpenSearchDataSource.class.getName()))
			{
				if(baseDatasource == false)
					InMemoryStore.setItems(OpenSearchDataSource.class, new HashSet<DataSource>(OpenSearchDataSource.getAll(false)));
			}
			else if(itemType.getName().equals(OpenSearchDataSourceService.class.getName()))
			{
				if(baseDatasourceService == false)
					InMemoryStore.setItems(OpenSearchDataSourceService.class, new HashSet<DataSourceService>(OpenSearchDataSourceService.getAll(false)));
			}
			else if(itemType.getName().equals(FieldIndexContainer.class.getName()))
			{
				Set<IDaoElement> items = null;
				try { items = DatastoreHelper.getItems(DatastoreType.LOCAL, FieldIndexContainerDao.class); }
				catch(Exception e) { throw new ResourceRegistryException("Could not prefetch datasource field info", e); }
				for(IDaoElement item : items)
				{
					FieldIndexContainer loaded = new FieldIndexContainer();
					loaded.setID(((FieldIndexContainerDao)item).getID());
					loaded.load(false);
					InMemoryStore.setItem(FieldIndexContainer.class, loaded);
				}
			}
		}
	}
}
