/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr;

import gr.uoa.di.madgik.rr.RRContext;
import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.bridge.IRegistryProvider;
import gr.uoa.di.madgik.rr.bridge.RegistryBridge;
import java.util.Set;

public class ResourceRegistry {
    private static RRContext context = null;
    private static RegistryBridge bridge = null;
    private static IRegistryProvider provider = null;

    private static synchronized void initialize() throws ResourceRegistryException {
        if (context == null) {
            context = new RRContext();
        }
    }

    private static synchronized void initProvider() throws ResourceRegistryException {
        if (provider == null) {
            try {
                Object o = Class.forName(ResourceRegistry.getContext().getRepositoryProvider()).newInstance();
                if (!(o instanceof IRegistryProvider)) {
                    throw new ResourceRegistryException("targeted provider not of supported type");
                }
                provider = (IRegistryProvider)o;
                provider.readConfiguration(ResourceRegistry.getContext().getRepositoryProviderConfig());
                boolean foundPolicy = false;
                for (RRContext.ReadPolicy readPolicy : RRContext.ReadPolicy.values()) {
                    if (!provider.isReadPolicySupported(readPolicy)) continue;
                    foundPolicy = true;
                    break;
                }
                if (!foundPolicy) {
                    throw new ResourceRegistryException("Could not find any supported read policies for provider " + provider.getClass().getName() + ". Check datastore configuration");
                }
                foundPolicy = false;
                for (Enum enum_ : RRContext.WritePolicy.values()) {
                    if (!provider.isWritePolicySupported((RRContext.WritePolicy)enum_)) continue;
                    foundPolicy = true;
                    break;
                }
                if (!foundPolicy) {
                    throw new ResourceRegistryException("Could not find any supported write policies for provider " + provider.getClass().getName() + ". Check datastore configuration");
                }
            }
            catch (Exception e) {
                throw new ResourceRegistryException("provider could not be initialized", e);
            }
        }
    }

    private static synchronized void initBridge() throws ResourceRegistryException {
        if (context == null) {
            bridge = new RegistryBridge(ResourceRegistry.getProvider());
            if (ResourceRegistry.getContext().getBridgingPeriod() != null) {
                bridge.setBridgingPeriod(ResourceRegistry.getContext().getBridgingPeriod());
            }
            if (ResourceRegistry.getContext().getShortBridgingPeriod() != null) {
                bridge.setShortBridgingPeriod(ResourceRegistry.getContext().getShortBridgingPeriod());
            }
            if (ResourceRegistry.getContext().getClearDataStoreOnStartup() != null) {
                bridge.setClearDataStoreOnStartup(ResourceRegistry.getContext().getClearDataStoreOnStartup());
            }
            bridge.setOutgoing(ResourceRegistry.getContext().getEditableTargets());
            bridge.setIncoming(ResourceRegistry.getContext().getReadOnlyTargets());
            bridge.setUpdating(ResourceRegistry.getContext().getUpdateTargets());
            bridge.setInMemory(ResourceRegistry.getContext().getInMemoryTargets());
            bridge.start();
        }
    }

    private static IRegistryProvider getProvider() throws ResourceRegistryException {
        if (provider == null) {
            ResourceRegistry.initProvider();
        }
        return provider;
    }

    public static RRContext getContext() throws ResourceRegistryException {
        if (context == null) {
            ResourceRegistry.initialize();
        }
        return context;
    }

    public static void startBridging() throws ResourceRegistryException {
        if (bridge == null) {
            ResourceRegistry.initBridge();
        }
    }

    public static boolean isInitialBridgingComplete() throws ResourceRegistryException {
        if (bridge != null) {
            return bridge.isInitialBridgingComplete();
        }
        throw new ResourceRegistryException("Registry bridge not initialized");
    }

    public static void retrieveDirect(Class<?> item, String id) throws ResourceRegistryException {
        provider.retrieveDirect(item, id);
    }

    public static void retrieveDirect(Class<?> item) throws ResourceRegistryException {
        provider.retrieveDirect(item);
    }

    public static void storeDirect(Class<?> item, String id) throws ResourceRegistryException {
        provider.persistDirect(item, id);
    }

    public static void storeDirect(Class<?> item) throws ResourceRegistryException {
        provider.persistDirect(item);
    }

    public static Set<String> getReadOnlyTargets() {
        return context.getReadOnlyTargets();
    }

    public static Set<String> getUpdateTargets() {
        return context.getUpdateTargets();
    }

    public static Set<String> getEditableTargets() {
        return context.getEditableTargets();
    }

    public static void setDirty() {
        if (bridge != null) {
            bridge.update();
        }
    }

    public static boolean isWritePolicySupported(RRContext.WritePolicy policy) throws ResourceRegistryException {
        return ResourceRegistry.getProvider().isWritePolicySupported(policy);
    }

    public static boolean isReadPolicySupported(RRContext.ReadPolicy policy) throws ResourceRegistryException {
        return ResourceRegistry.getProvider().isReadPolicySupported(policy);
    }

    public static long getCurrentIteration() {
        return bridge.getCurrentIteration();
    }
}

