/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.access;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.element.IRRElement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class InMemoryStore {
    private static Map<String, Map<String, IRRElement>> store = new ConcurrentHashMap<String, Map<String, IRRElement>>();
    private static Map<String, String> inMemoryTargetItemTypes = new ConcurrentHashMap<String, String>();
    private static Map<String, String> revInMemoryTargetItemTypes = new ConcurrentHashMap<String, String>();

    private InMemoryStore() {
    }

    public static void setItems(Class<?> type, Set<? extends IRRElement> items) throws ResourceRegistryException {
        try {
            IRRElement obj;
            store.put(type.getName(), new ConcurrentHashMap());
            if (items != null) {
                for (IRRElement iRRElement : items) {
                    store.get(type.getName()).put(iRRElement.getID(), iRRElement);
                }
                if (items.size() > 0 && !inMemoryTargetItemTypes.containsKey(type.getName()) && IRRElement.class.isAssignableFrom(type) && (obj = (IRRElement)type.newInstance()).getItem() != null) {
                    inMemoryTargetItemTypes.put(obj.getItem().getClass().getName(), type.getName());
                    revInMemoryTargetItemTypes.put(type.getName(), obj.getItem().getClass().getName());
                }
            }
            if ((items == null || items.size() == 0) && IRRElement.class.isAssignableFrom(type) && (obj = (IRRElement)type.newInstance()).getItem() != null) {
                inMemoryTargetItemTypes.remove(obj.getItem().getClass().getName());
                revInMemoryTargetItemTypes.remove(type.getName());
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not set items", e);
        }
    }

    public static void setItem(Class<?> type, IRRElement item) throws ResourceRegistryException {
        try {
            IRRElement obj;
            if (store.get(type.getName()) == null) {
                store.put(type.getName(), new ConcurrentHashMap());
            }
            store.get(type.getName()).put(item.getID(), item);
            if (!inMemoryTargetItemTypes.containsKey(type.getName()) && IRRElement.class.isAssignableFrom(type) && (obj = (IRRElement)type.newInstance()).getItem() != null) {
                inMemoryTargetItemTypes.put(obj.getItem().getClass().getName(), type.getName());
                revInMemoryTargetItemTypes.put(type.getName(), obj.getItem().getClass().getName());
            }
        }
        catch (Exception e) {
            throw new ResourceRegistryException("Could not set item", e);
        }
    }

    public static void removeItem(Class<?> type, String id) {
        String sType = type.getName();
        boolean rev = false;
        Map<String, IRRElement> itemStore = store.get(sType);
        if (itemStore == null) {
            rev = true;
            if ((sType = revInMemoryTargetItemTypes.get(sType)) == null) {
                return;
            }
            itemStore = store.get(sType);
            if (itemStore == null) {
                return;
            }
        }
        if (itemStore.containsKey(id)) {
            itemStore.remove(id);
            if (itemStore.size() == 0) {
                store.put(sType, new ConcurrentHashMap());
                if (!rev) {
                    inMemoryTargetItemTypes.remove(revInMemoryTargetItemTypes.get(sType));
                    revInMemoryTargetItemTypes.remove(sType);
                } else {
                    revInMemoryTargetItemTypes.remove(inMemoryTargetItemTypes.get(sType));
                    inMemoryTargetItemTypes.remove(sType);
                }
            }
        }
    }

    public static Set<IRRElement> getItems(Class<?> type) {
        String sType = type.getName();
        if (store.get(sType) == null) {
            if ((sType = revInMemoryTargetItemTypes.get(sType)) == null) {
                return null;
            }
            if (store.get(sType) == null) {
                return null;
            }
        }
        return new HashSet<IRRElement>(store.get(type.getName()).values());
    }

    public static IRRElement getItem(Class<?> type, String id) {
        String sType = type.getName();
        Map<String, IRRElement> itemStore = store.get(sType);
        if (itemStore == null) {
            if ((sType = revInMemoryTargetItemTypes.get(sType)) == null) {
                return null;
            }
            itemStore = store.get(sType);
            if (itemStore == null) {
                return null;
            }
        }
        return itemStore.get(id);
    }

    public static boolean hasItem(Class<?> type, String id) {
        String sType = type.getName();
        Map<String, IRRElement> itemStore = store.get(type.getName());
        if (itemStore == null) {
            if ((sType = revInMemoryTargetItemTypes.get(sType)) == null) {
                return false;
            }
            itemStore = store.get(sType);
            if (itemStore == null) {
                return false;
            }
        }
        return itemStore.containsKey(id);
    }

    public static void clear() {
        store = new ConcurrentHashMap<String, Map<String, IRRElement>>();
        inMemoryTargetItemTypes = new ConcurrentHashMap<String, String>();
        revInMemoryTargetItemTypes = new ConcurrentHashMap<String, String>();
    }

    public static boolean containsItemType(String type) {
        return inMemoryTargetItemTypes.containsKey(type);
    }
}

