/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.rr.plugins;

import gr.uoa.di.madgik.rr.ResourceRegistryException;
import gr.uoa.di.madgik.rr.plugins.Plugin;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PluginManager {
    private static Map<Plugin.Type, TreeMap<Integer, Map<String, Plugin>>> plugins = new HashMap<Plugin.Type, TreeMap<Integer, Map<String, Plugin>>>();
    private static Logger logger = Logger.getLogger(PluginManager.class.getName());
    private static ExecutorService executor = Executors.newCachedThreadPool(new PluginThreadFactory());

    public static synchronized String registerPlugin(Plugin plugin, int order) {
        if (plugins.get((Object)plugin.getType()) == null) {
            plugins.put(plugin.getType(), new TreeMap());
        }
        if (plugins.get((Object)plugin.getType()).get(order) == null) {
            plugins.get((Object)plugin.getType()).put(order, new HashMap());
        }
        String id = UUID.randomUUID().toString();
        plugins.get((Object)plugin.getType()).get(order).put(id, plugin);
        logger.log(Level.INFO, "Registered plugin: " + plugin.getClass().getName() + " of type " + (Object)((Object)plugin.getType()) + ", order #" + order + (plugin.getType() == Plugin.Type.PERIODIC ? ", period " + plugin.getPeriod() + " " + (Object)((Object)plugin.getPeriodUnit()) : ""));
        if (plugin.getType() == Plugin.Type.PERIODIC) {
            executor.execute(new PeriodicPluginTask(plugin));
        } else if (plugin.getType() == Plugin.Type.ONE_OFF) {
            executor.execute(new OneOffPluginTask(plugin));
        }
        return id;
    }

    public static synchronized Map<String, Plugin> getPluginsOfType(Plugin.Type type) {
        Map pluginsOfType = plugins.get((Object)type);
        if (pluginsOfType == null) {
            return new HashMap<String, Plugin>();
        }
        LinkedHashMap<String, Plugin> ret = new LinkedHashMap<String, Plugin>();
        for (Map<String, Plugin> p : plugins.get((Object)type).values()) {
            ret.putAll(p);
        }
        return ret;
    }

    public static synchronized Map<String, Plugin> getPlugins() {
        HashMap<String, Plugin> ret = new HashMap<String, Plugin>();
        for (TreeMap<Integer, Map<String, Plugin>> pluginsOfType : plugins.values()) {
            for (Map p : pluginsOfType.values()) {
                ret.putAll(p);
            }
        }
        return ret;
    }

    public static synchronized void executePluginsOfType(Plugin.Type type, Set<Class<?>> targets) throws ResourceRegistryException {
        Map pluginsOfType = plugins.get((Object)type);
        if (pluginsOfType == null) {
            return;
        }
        for (Map<String, Plugin> orderedPlugins : plugins.get((Object)type).values()) {
            for (Plugin p : orderedPlugins.values()) {
                logger.log(Level.INFO, "Executing " + (Object)((Object)p.getType()) + " plugin: " + p.getClass().getName());
                p.executePlugin(targets);
            }
        }
    }

    private static class PluginThreadFactory
    implements ThreadFactory {
        private long i = 0L;

        private PluginThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "PluginTask-" + this.i++);
            t.setDaemon(true);
            return t;
        }
    }

    private static class OneOffPluginTask
    implements Runnable {
        private Plugin plugin = null;
        private static Logger logger = Logger.getLogger(OneOffPluginTask.class.getName());

        public OneOffPluginTask(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            boolean success = false;
            while (!success) {
                try {
                    this.plugin.execute(null);
                    success = true;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not execute plugin", e);
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static class PeriodicPluginTask
    implements Runnable {
        private Plugin plugin = null;
        private static Logger logger = Logger.getLogger(PeriodicPluginTask.class.getName());

        public PeriodicPluginTask(Plugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        this.plugin.execute(null);
                        this.plugin.getPeriodUnit().sleep(this.plugin.getPeriod());
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not execute plugin", e);
                    try {
                        TimeUnit.SECONDS.sleep(30L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

