/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy;

import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.proxy.local.LocalChannelLocator;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPChannelLocator;
import gr.uoa.di.madgik.commons.utils.URIUtils;
import java.net.URI;

public class ChannelLocatorFactory {
    public static IChannelLocator GetLocator(URI locator) throws Exception {
        try {
            IChannelLocator loc = null;
            IChannelLocator.LocatorType type = URIUtils.GetLocatorType(locator);
            switch (type) {
                case Local: {
                    loc = new LocalChannelLocator();
                    break;
                }
                case TCP: {
                    loc = new TCPChannelLocator();
                    break;
                }
                default: {
                    throw new Exception("Unrecognized channel locator type");
                }
            }
            loc.FromURI(locator);
            return loc;
        }
        catch (Exception ex) {
            throw new Exception("Could not instantiate locator based on provided serialization", ex);
        }
    }
}

