/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.registry;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.events.ChannelStateEvent;
import gr.uoa.di.madgik.commons.channel.nozzle.INozzleConfig;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryCleanUp;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryEntry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import java.util.Hashtable;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelRegistry {
    private static Logger logger = Logger.getLogger(ChannelRegistry.class.getName());
    private static final Object lockMe = new Object();
    private static Map<ChannelRegistryKey, ChannelRegistryEntry> Dictionary = new Hashtable<ChannelRegistryKey, ChannelRegistryEntry>();
    private static ChannelRegistryCleanUp CleanUp = new ChannelRegistryCleanUp();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelRegistryKey Register(ChannelState State2, INozzleConfig Config2, String RegisteringNozzle) {
        Object object = lockMe;
        synchronized (object) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Registering channel state");
            }
            String UUIDRegistryKey = UUID.randomUUID().toString();
            ChannelRegistryKey key = new ChannelRegistryKey(UUIDRegistryKey);
            Dictionary.put(key, new ChannelRegistryEntry(key, State2, Config2, RegisteringNozzle));
            Config2.GetChannelProxy().SetChannelRegistryKey(key);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Registering registry cleanup to events of channel");
            }
            for (ChannelStateEvent event : State2.GetChannelEvents()) {
                event.addObserver(CleanUp);
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ChannelRegistryEntry Retrieve(ChannelRegistryKey Key) {
        Object object = lockMe;
        synchronized (object) {
            if (Key == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Retrieving entry for key (null)");
                }
                return null;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Retrieving entry for key " + Key.toString());
            }
            if (!Dictionary.containsKey(Key)) {
                return null;
            }
            return Dictionary.get(Key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void CleanUp(ChannelRegistryKey RegistryKey) {
        Object object = lockMe;
        synchronized (object) {
            if (RegistryKey == null || !Dictionary.containsKey(RegistryKey)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "No Registry Key provided. Disgarding");
                }
                return;
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unregistering CleanUp from events of channel with key " + RegistryKey);
            }
            for (ChannelStateEvent event : Dictionary.get(RegistryKey).GetState().GetChannelEvents()) {
                event.deleteObserver(CleanUp);
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Disposing items of registry entry with key " + RegistryKey);
            }
            Dictionary.get(RegistryKey).Dispose();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Cleaning up registry from entry with key " + RegistryKey);
            }
            Dictionary.remove(RegistryKey);
        }
    }
}

