/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.events.ChannelState;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.proxy.IChannelProxy;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.InletProtocol;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.OutletProtocol;
import gr.uoa.di.madgik.commons.channel.proxy.tcp.TCPChannelLocator;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryEntry;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TCPServerChannelProxy
implements IChannelProxy {
    private static Logger logger = Logger.getLogger(TCPServerChannelProxy.class.getName());
    private ChannelRegistryKey RegistryKey = null;
    private IChannelLocator Locator = null;
    private InletProtocol InletProt = null;
    private OutletProtocol OutletProt = null;
    private boolean InletSide = false;
    private String NozzleID = null;
    private ChannelState State = null;

    protected TCPServerChannelProxy() {
        this.InletSide = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPServerChannelProxy(IChannelLocator Locator, String NozzleID) {
        Object synchThreadStart;
        this.NozzleID = NozzleID;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating TCP Server Proxy");
        }
        if (!this.CanHandleProxyLocator(Locator.GetLocatorType()).booleanValue()) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "TCPServerProxy cannot handle locators of type " + Locator.GetLocatorType().toString());
            }
            throw new IllegalArgumentException("TCPServerProxy cannot handle locators of type " + Locator.GetLocatorType().toString());
        }
        if (!(Locator instanceof TCPChannelLocator)) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Incompatible declared and found types of locators");
            }
            throw new IllegalArgumentException("Incompatible declared and found types of locators");
        }
        this.Locator = Locator;
        Socket clientSock = null;
        try {
            clientSock = new Socket(((TCPChannelLocator)this.Locator).GetHostName(), ((TCPChannelLocator)this.Locator).GetPort());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not establish connection to " + ((TCPChannelLocator)this.Locator).GetHostName() + ":" + ((TCPChannelLocator)this.Locator).GetPort());
        }
        Object object = synchThreadStart = new Object();
        synchronized (object) {
            this.State = new ChannelState();
            this.OutletProt = new OutletProtocol(synchThreadStart, clientSock, this.NozzleID, this.Locator.GetRegistryKey().GetUniqueID(), this.State);
        }
    }

    @Override
    public Boolean CanHandleProxyLocator(IChannelLocator.LocatorType Locator) {
        if (Locator == IChannelLocator.LocatorType.TCP) {
            return true;
        }
        return false;
    }

    @Override
    public ChannelState GetChannelState() {
        return this.State;
    }

    @Override
    public void Dispose() {
        if (this.State != null) {
            try {
                this.State.Dispose();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.InletProt != null) {
            try {
                this.InletProt.Dispose();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (this.OutletProt != null) {
            try {
                this.OutletProt.Dispose();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public IChannelLocator GetLocator() {
        return this.Locator;
    }

    @Override
    public IChannelProxy.ProxyConnector GetProxyType() {
        return IChannelProxy.ProxyConnector.TCP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void SetChannelRegistryKey(ChannelRegistryKey RegistryKey) {
        this.RegistryKey = RegistryKey;
        if (this.InletSide) {
            Object synchThreadStart;
            ChannelRegistryEntry entry = ChannelRegistry.Retrieve(this.RegistryKey);
            if (entry == null) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "Provided registry entry not found");
                }
                throw new IllegalStateException("Provided registry entry not found");
            }
            this.State = entry.GetState();
            this.Locator = this.CreateProxyLocator();
            Object object = synchThreadStart = new Object();
            synchronized (object) {
                this.InletProt = new InletProtocol(entry, synchThreadStart);
            }
        }
    }

    private IChannelLocator CreateProxyLocator() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Creating locator for proxy");
        }
        if (TCPConnectionManager.GetConnectionManagerPort() < 0) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Cannot create a locator as there is no active server socket");
            }
            throw new IllegalStateException("Cannot create a locator as there is no active server socket");
        }
        if (TCPConnectionManager.GetConnectionManagerHostName() == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Cannot create a locator as the server socket is not bound");
            }
            throw new IllegalStateException("Cannot create a locator as the server socket is not bound");
        }
        if (this.RegistryKey == null) {
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Registry Key not yet defined. Cannot create Locator");
            }
            throw new IllegalStateException("Registry Key not yet defined. Cannot create Locator");
        }
        String HostAddress = TCPConnectionManager.GetConnectionManagerHostName();
        int HostPort = TCPConnectionManager.GetConnectionManagerPort();
        TCPChannelLocator loc = new TCPChannelLocator(HostAddress, HostPort);
        loc.SetRegistryKey(this.RegistryKey);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Locator created " + loc.toString());
        }
        return loc;
    }

    @Override
    public Boolean HasConnected() {
        if (this.InletSide) {
            return ChannelRegistry.Retrieve(this.RegistryKey).HasConnected();
        }
        return this.OutletProt.HasConnected();
    }

    @Override
    public Boolean StillConnected() {
        if (this.InletSide) {
            return ChannelRegistry.Retrieve(this.RegistryKey).StillConnected();
        }
        return this.OutletProt.StillConnected();
    }
}

