/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.channel.proxy.tcp;

import gr.uoa.di.madgik.commons.channel.proxy.IChannelLocator;
import gr.uoa.di.madgik.commons.channel.registry.ChannelRegistryKey;
import gr.uoa.di.madgik.commons.utils.URIUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.net.URI;
import java.util.Map;

public class TCPChannelLocator
implements IChannelLocator {
    private ChannelRegistryKey RegistryKey = null;
    private String HostName = null;
    private int Port = 0;

    public TCPChannelLocator() {
    }

    public TCPChannelLocator(String HostName, int Port) {
        this.HostName = HostName;
        this.Port = Port;
    }

    public String GetHostName() {
        return this.HostName;
    }

    public int GetPort() {
        return this.Port;
    }

    @Override
    public void Decode(byte[] payload) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(payload);
        DataInputStream din = new DataInputStream(bin);
        String loctype = din.readUTF();
        if (!loctype.equalsIgnoreCase(this.GetLocatorType().toString())) {
            throw new Exception("Not valid serialization for this channel locator. Type found " + loctype);
        }
        this.HostName = din.readUTF();
        this.Port = din.readInt();
        this.RegistryKey = new ChannelRegistryKey(din.readUTF());
    }

    @Override
    public byte[] Encode() throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        dout.writeUTF(this.GetLocatorType().toString());
        dout.writeUTF(this.GetHostName());
        dout.writeInt(this.GetPort());
        dout.writeUTF(this.GetRegistryKey().GetUniqueID());
        dout.flush();
        dout.close();
        return bout.toByteArray();
    }

    @Override
    public IChannelLocator.LocatorType GetLocatorType() {
        return IChannelLocator.LocatorType.TCP;
    }

    @Override
    public ChannelRegistryKey GetRegistryKey() {
        return this.RegistryKey;
    }

    @Override
    public void SetRegistryKey(ChannelRegistryKey RegistryKey) {
        this.RegistryKey = RegistryKey;
    }

    @Override
    public URI ToURI() throws Exception {
        String queryString = URIUtils.BuildQueryString(this.GetRegistryKey().GetUniqueID());
        return new URI("channel", null, this.GetHostName(), this.GetPort(), null, queryString, this.GetLocatorType().toString());
    }

    @Override
    public void FromURI(URI locator) throws Exception {
        if (!locator.getScheme().equals("channel")) {
            throw new Exception("Invalid scheme");
        }
        if (!IChannelLocator.LocatorType.valueOf(locator.getFragment()).equals((Object)this.GetLocatorType())) {
            throw new Exception("Invalid type");
        }
        this.HostName = locator.getHost();
        this.Port = locator.getPort();
        Map<String, String> params = URIUtils.ParseQueryString(locator.getQuery());
        this.RegistryKey = new ChannelRegistryKey(URIUtils.GetID(params, true));
    }

    public String toString() {
        return this.GetLocatorType().toString() + "#" + this.GetHostName() + "#" + this.GetPort() + "#" + this.GetRegistryKey();
    }

    public boolean equals(Object o) {
        if (!(o instanceof TCPChannelLocator)) {
            return false;
        }
        return this.GetRegistryKey().equals(((TCPChannelLocator)o).GetRegistryKey()) && this.GetHostName().equals(((TCPChannelLocator)o).GetHostName()) && this.GetPort() == ((TCPChannelLocator)o).GetPort();
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + (this.HostName != null ? this.HostName.hashCode() : 0);
        hash = 89 * hash + this.Port;
        hash = 89 * hash + (this.RegistryKey != null ? this.RegistryKey.hashCode() : 0);
        return hash;
    }
}

