package gr.uoa.di.madgik.grs.bridge.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.ArrayList;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import gr.uoa.di.madgik.grs.buffer.IBuffer.TransportDirective;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;

/**
 * The record definition for the {@link GCubeXMLRecord}
 * 
 * @author gpapanikos, NKUA
 * @author Gerasimos Farantatos, NKUA
 *
 */
public class GCubeXMLRecordDefinition extends RecordDefinition
{
	/**
	 * The name of the payload field. Currently set to "payload"
	 */
	public static final String PayloadFieldName="payload";
	/**
	 * Whether or not the payload should be compressed at transfer. Currently set to false
	 */
	public static final boolean DefaultCompress=false;

	public GCubeXMLRecordDefinition()
	{
		StringFieldDefinition def=new StringFieldDefinition(GCubeXMLRecordDefinition.PayloadFieldName);
		def.setTransportDirective(TransportDirective.Full);
		def.setCompress(GCubeXMLRecordDefinition.DefaultCompress);
		this.Fields = new ArrayList<FieldDefinition>();
		this.Fields.add(def);
	}

	public void copyFrom(GCubeXMLRecordDefinition other) throws Exception
	{
		super.copyFrom(other);
	}
	
	/**
	 * Create a new instance
	 * 
	 * @param compress Do compression at transport
	 */
	public GCubeXMLRecordDefinition(boolean compress)
	{
		StringFieldDefinition def=new StringFieldDefinition(GCubeXMLRecordDefinition.PayloadFieldName);
		def.setTransportDirective(TransportDirective.Full);
		def.setCompress(compress);
		this.Fields = new ArrayList<FieldDefinition>();
		this.Fields.add(def);
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.record.RecordDefinition#extendEquals(java.lang.Object)
	 */
	@Override
	public boolean extendEquals(Object obj)
	{
		if(!(obj instanceof GCubeXMLRecordDefinition)) return false;
		return true;
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.record.RecordDefinition#extendDeflate(java.io.DataOutput)
	 */
	@Override
	public void extendDeflate(DataOutput out) throws GRS2RecordSerializationException
	{
		//nothing to deflate
	}

	/**
	 * {@inheritDoc}
	 * 
	 * @see gr.uoa.di.madgik.grs.record.RecordDefinition#extendInflate(java.io.DataInput)
	 */
	@Override
	public void extendInflate(DataInput in) throws GRS2RecordSerializationException
	{
		//nothing to inflate
	}

	@Override
	public void extendFromXML(Element element) throws GRS2RecordSerializationException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void extendToXML(Element element)
			throws GRS2RecordSerializationException {
		// TODO Auto-generated method stub
		
	}

}
