/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.bridge.xml;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.bridge.BridgeDowngrade;
import gr.uoa.di.madgik.grs.bridge.exceptions.GCubeBridgeException;
import gr.uoa.di.madgik.grs.bridge.xml.GCubeXMLRecord;
import gr.uoa.di.madgik.grs.reader.ForwardReader;
import java.net.URI;
import java.util.logging.Logger;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSLocator;
import org.gcube.common.searchservice.searchlibrary.rsclient.elements.RSResourceType;
import org.gcube.common.searchservice.searchlibrary.rswriter.RSXMLWriter;

public class XMLDowngrade
extends BridgeDowngrade {
    private static Logger logger = Logger.getLogger(XMLDowngrade.class.getName());
    private RSXMLWriter writer = null;
    private ForwardReader<GCubeXMLRecord> reader = null;
    private RSResourceType resourseType = null;

    public XMLDowngrade() {
    }

    public XMLDowngrade(URI locator) {
        this.locator = locator;
    }

    public void setResourceType(RSResourceType resourceType) {
        this.resourseType = resourceType;
    }

    @Override
    public void initialize() throws GCubeBridgeException {
        try {
            this.writer = RSXMLWriter.getRSXMLWriter();
        }
        catch (Exception e) {
            throw new GCubeBridgeException("Could not initialize RS XML Writer", e);
        }
        try {
            this.reader = new ForwardReader(this.locator);
        }
        catch (GRS2Exception e) {
            throw new GCubeBridgeException("Could not initialize Forward Reader", e);
        }
    }

    @Override
    public RSLocator getLocator() throws GCubeBridgeException {
        try {
            return this.writer.getRSLocator(this.resourseType);
        }
        catch (Exception e) {
            throw new GCubeBridgeException("Could not retrieve locator", e);
        }
    }

    @Override
    public void doDowngrade() throws GCubeBridgeException {
        try {
            for (GCubeXMLRecord record : this.reader) {
                this.writer.addResults(this.getRecord(record));
            }
        }
        catch (Exception ex) {
            throw new GCubeBridgeException("Could not add the downgraded record", ex);
        }
        finally {
            try {
                this.reader.close();
            }
            catch (Exception ex) {}
            try {
                this.writer.close();
            }
            catch (Exception ex) {}
        }
    }

    @Override
    public Logger getLogger() {
        return logger;
    }
}

