/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.environment.gcube;

import gr.uoa.di.madgik.environment.exception.EnvironmentReportingException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.reporting.IReportingFrameworkProvider;
import java.util.HashMap;
import java.util.Map;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.messaging.accounting.system.SystemAccounting;
import org.gcube.messaging.accounting.system.SystemAccountingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GCubeReportingFrameworkProvider
implements IReportingFrameworkProvider {
    private static Logger logger = LoggerFactory.getLogger(GCubeReportingFrameworkProvider.class);
    public static final String GCubeActionScopeHintName = "GCubeActionScope";
    public static final String GCubeGHNHintName = "GCubeGHN";
    public static final String ReportingFrameworkRIContainerServiceClassHintName = "ReportingFrameworkRIContainerServiceClass";
    public static final String ReportingFrameworkRIContainerServiceNameHintName = "ReportingFrameworkRIContainerServiceName";
    public static final String ReportingFrameworkRIContainerServiceJNDINameHintName = "ReportingFrameworkRIContainerServiceJNDIName";
    private static final Object lockMe = new Object();
    private static GCUBEServiceContext context = null;
    private static SystemAccounting Accounting = null;
    private static String RIContainerServiceClass = null;
    private static String RIContainerServiceName = null;
    private static String RIContainerServiceJNDIName = null;
    private static String GHN = null;

    public void SessionInit(EnvHintCollection Hints) throws EnvironmentReportingException {
        try {
            Accounting = SystemAccountingFactory.getSystemAccountingInstance();
            GHN = GCubeReportingFrameworkProvider.getGHN(Hints);
            RIContainerServiceClass = GCubeReportingFrameworkProvider.getRIContainerServiceClass(Hints);
            RIContainerServiceName = GCubeReportingFrameworkProvider.getRIContainerServiceName(Hints);
            RIContainerServiceJNDIName = GCubeReportingFrameworkProvider.getRIContainerServiceJNDIName(Hints);
            context = new GCUBEServiceContext(){

                public String getServiceClass() {
                    return RIContainerServiceClass;
                }

                public String getName() {
                    return RIContainerServiceName;
                }

                protected String getJNDIName() {
                    return RIContainerServiceJNDIName;
                }
            };
        }
        catch (Exception e) {
            throw new EnvironmentReportingException("Could not initialize session", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Send(String messageType, Map<String, Object> messageParameters, EnvHintCollection hints) throws EnvironmentReportingException {
        HashMap<String, Object> msgParameters = null;
        Object object = lockMe;
        synchronized (object) {
            try {
                msgParameters = !(messageParameters instanceof HashMap) ? new HashMap<String, Object>(messageParameters) : (HashMap<String, Object>)messageParameters;
                logger.debug("Sending message of type: " + messageType + " with message parameters: " + msgParameters + ". Scope is " + GCUBEScope.getScope((String)GCubeReportingFrameworkProvider.getActionScope(hints)) + " and GHN is " + GHN);
                Accounting.sendSystemAccountingMessage(context, messageType, msgParameters, new GCUBEScope[]{GCUBEScope.getScope((String)GCubeReportingFrameworkProvider.getActionScope(hints))});
            }
            catch (Exception e) {
                throw new EnvironmentReportingException("Could not send reporting message", (Throwable)e);
            }
        }
    }

    private static String getActionScope(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(GCubeActionScopeHintName)) {
            return null;
        }
        return Hints.GetHint((String)GCubeActionScopeHintName).Hint.Payload;
    }

    private static String getGHN(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(GCubeGHNHintName)) {
            return null;
        }
        return Hints.GetHint((String)GCubeGHNHintName).Hint.Payload;
    }

    private static String getRIContainerServiceClass(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(ReportingFrameworkRIContainerServiceClassHintName)) {
            return null;
        }
        return Hints.GetHint((String)ReportingFrameworkRIContainerServiceClassHintName).Hint.Payload;
    }

    private static String getRIContainerServiceName(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(ReportingFrameworkRIContainerServiceNameHintName)) {
            return null;
        }
        return Hints.GetHint((String)ReportingFrameworkRIContainerServiceNameHintName).Hint.Payload;
    }

    private static String getRIContainerServiceJNDIName(EnvHintCollection Hints) {
        if (Hints == null) {
            return null;
        }
        if (!Hints.HintExists(ReportingFrameworkRIContainerServiceJNDINameHintName)) {
            return null;
        }
        return Hints.GetHint((String)ReportingFrameworkRIContainerServiceJNDINameHintName).Hint.Payload;
    }
}

