/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.execution.executionengine.service;

import gr.uoa.di.madgik.commons.channel.proxy.tcp.ChannelTCPConnManagerEntry;
import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.environment.hint.EnvHint;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.environment.hint.NamedEnvHint;
import gr.uoa.di.madgik.environment.is.elements.ExtensionPair;
import gr.uoa.di.madgik.environment.is.elements.NodeInfo;
import gr.uoa.di.madgik.execution.engine.ExecutionEngine;
import gr.uoa.di.madgik.execution.engine.ExecutionEngineConfig;
import gr.uoa.di.madgik.execution.engine.QueueableExecutionEngine;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngCallbackTCPConnManagerEntry;
import gr.uoa.di.madgik.execution.plan.element.invocable.tcpserver.ExecEngTCPConnManagerEntry;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.is.InformationSystem;
import gr.uoa.di.madgik.notificationhandling.NotificationHandling;
import gr.uoa.di.madgik.ss.StorageSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.scope.GCUBEScopeNotSupportedException;
import org.gcube.common.core.utils.proxies.ReadOnlyProxyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceContext
extends GCUBEServiceContext {
    private static Logger logger = LoggerFactory.getLogger(ServiceContext.class);
    private static ServiceContext Context = null;
    private static final Object lockMe = new Object();

    private ServiceContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceContext GetServiceContext() {
        if (Context == null) {
            Object object = lockMe;
            synchronized (object) {
                if (Context == null) {
                    Context = new ServiceContext();
                }
            }
        }
        return Context;
    }

    @ReadOnlyProxyContext.ReadOnly(value={"org.gcube.common", "gr.uoa.di.madgik.environment.gcube", "org.gcube.execution.executionengine.service"})
    public GCUBERunningInstance getInstance() {
        return super.getInstance();
    }

    protected String getJNDIName() {
        return "execution/executionengine";
    }

    protected void onReady() throws Exception {
        EnvHintCollection Hints = new EnvHintCollection();
        Hints.AddHint(new NamedEnvHint("StorageSystemDeleteOnExit", new EnvHint(Boolean.TRUE.toString())));
        Hints.AddHint(new NamedEnvHint("StorageSystemLocalFileSystemBufferPath", new EnvHint(this.GetLocalFSBuffer())));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorCount", new EnvHint(Integer.toString(this.GetRetryOnErrorTimes()))));
        Hints.AddHint(new NamedEnvHint("RetryOnErrorInterval", new EnvHint(Integer.toString(this.GetRetryOnErrorInterval()))));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceClass", new EnvHint(ServiceContext.GetServiceContext().getService().getServiceClass())));
        Hints.AddHint(new NamedEnvHint("InformationSystemRIContainerServiceName", new EnvHint(ServiceContext.GetServiceContext().getService().getServiceName())));
        Hints.AddHint(new NamedEnvHint("JMSHost", new EnvHint(this.GetJMSHost())));
        String JMSPROVIDER = this.GetJMSProvider();
        try {
            NotificationHandling.Init((String)JMSPROVIDER, (EnvHintCollection)Hints);
        }
        catch (Exception e) {
            logger.warn("Notification Handler initialization failed", (Throwable)e);
        }
        this.InitExecutionEngineEnvironment(Hints);
        this.RegisterInfo(Hints);
        super.onReady();
    }

    private void InitExecutionEngineEnvironment(EnvHintCollection Hints) throws Exception {
        logger.info("Initalizing Engine Environment");
        logger.info("Initalizing TCPManager");
        List<PortRange> range = this.GetPortRanges();
        for (PortRange r : range) {
            logger.info("port range : " + r.GetStart() + "-" + r.GetEnd());
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(this.GetHostName(), range, this.GetUseRandomPort().booleanValue()));
        logger.info("Registering entries");
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ExecEngCallbackTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new ChannelTCPConnManagerEntry());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        logger.info("Initializing Execution Engine");
        try {
            QueueableExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
        }
        catch (NoClassDefFoundError e) {
            logger.warn("Queuing mechanism is not supported cause class not found " + e.getMessage());
        }
        ExecutionEngine.Init((ExecutionEngineConfig)new ExecutionEngineConfig(0));
        logger.info("Collecting Environment Hints");
        logger.info("Initializing Information System Provider");
        InformationSystem.Init((String)this.GetInformationSystemProvider(), (EnvHintCollection)Hints);
        logger.info("Initializing Storage System Provider");
        StorageSystem.Init((String)this.GetStorageSystemProvider(), (EnvHintCollection)Hints);
    }

    private void RegisterInfo(EnvHintCollection Hints) throws Exception {
        logger.info("Registering Node");
        NodeInfo nfo = new NodeInfo();
        nfo.DynamicExtensions.put("pe2ng.port", new ExtensionPair("pe2ng.port", Integer.toString(TCPConnectionManager.GetConnectionManagerPort())));
        InformationSystem.RegisterNode((NodeInfo)nfo, (EnvHintCollection)Hints);
        logger.info("Registering boundary listener");
    }

    private String GetLocalFSBuffer() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("localFSBuffer", new boolean[]{false});
        if (tmpObj == null) {
            return "";
        }
        return tmpObj.toString();
    }

    private int GetRetryOnErrorInterval() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("retryOnErrorInterval", new boolean[]{false});
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private int GetRetryOnErrorTimes() {
        Object tmpObj = ServiceContext.GetServiceContext().getProperty("retryOnErrorTimes", new boolean[]{false});
        if (tmpObj == null) {
            return 0;
        }
        try {
            return Integer.parseInt(tmpObj.toString().trim());
        }
        catch (Exception ex) {
            return 0;
        }
    }

    private String GetInformationSystemProvider() {
        Object informationProviderObj = ServiceContext.GetServiceContext().getProperty("providerInformationName", new boolean[]{false});
        if (informationProviderObj == null) {
            return null;
        }
        return informationProviderObj.toString();
    }

    private String GetStorageSystemProvider() {
        Object storageProviderObj = ServiceContext.GetServiceContext().getProperty("providerStorageName", new boolean[]{false});
        if (storageProviderObj == null) {
            return null;
        }
        return storageProviderObj.toString();
    }

    private String GetJMSProvider() {
        Object JMSProviderObj = ServiceContext.GetServiceContext().getProperty("JMSProviderName", new boolean[]{false});
        if (JMSProviderObj == null) {
            return null;
        }
        return JMSProviderObj.toString();
    }

    private String GetJMSHost() {
        String JMSHost = null;
        for (GCUBEScope scope : GHNContext.getContext().getGHN().getScopes().values()) {
            if (!scope.isInfrastructure()) continue;
            Set serviceMapings = null;
            try {
                serviceMapings = scope.getServiceMap().getEndpoints((Object)"MessageBroker");
            }
            catch (GCUBEScopeNotSupportedException e) {
                logger.warn("Could not find JMSHost", (Throwable)e);
            }
            if (serviceMapings == null || serviceMapings.isEmpty()) continue;
            JMSHost = ((EndpointReferenceType)serviceMapings.iterator().next()).getAddress().toString();
            break;
        }
        return JMSHost;
    }

    private List<PortRange> GetPortRanges() {
        Object portRangesObj = ServiceContext.GetServiceContext().getProperty("portRanges", new boolean[]{false});
        logger.info("port ranges retrieved is " + portRangesObj);
        if (portRangesObj == null) {
            return new ArrayList<PortRange>();
        }
        String portRangesStr = portRangesObj.toString();
        String[] rangePairs = portRangesStr.trim().split("-");
        ArrayList<PortRange> ranges = new ArrayList<PortRange>();
        for (String pair : rangePairs) {
            String[] pairSplit = pair.trim().split(",");
            if (pairSplit.length != 2) {
                return new ArrayList<PortRange>();
            }
            String pairStart = pairSplit[0].trim();
            if (!pairStart.startsWith("{")) {
                return new ArrayList<PortRange>();
            }
            pairStart = pairStart.substring(1).trim();
            String pairEnd = pairSplit[1].trim();
            if (!pairEnd.endsWith("}")) {
                return new ArrayList<PortRange>();
            }
            pairEnd = pairEnd.substring(0, pairEnd.length() - 1).trim();
            int beginPair = 0;
            int endPair = 0;
            try {
                beginPair = Integer.parseInt(pairStart.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            try {
                endPair = Integer.parseInt(pairEnd.trim());
            }
            catch (Exception ex) {
                return new ArrayList<PortRange>();
            }
            ranges.add(new PortRange(beginPair, endPair));
        }
        return ranges;
    }

    private Boolean GetUseRandomPort() {
        Object portRandomObj = ServiceContext.GetServiceContext().getProperty("useRandomPort", new boolean[]{false});
        if (portRandomObj == null) {
            return false;
        }
        try {
            return Boolean.parseBoolean(portRandomObj.toString().trim());
        }
        catch (Exception ex) {
            return false;
        }
    }

    private String GetHostName() {
        return GHNContext.getContext().getHostname();
    }

    private String GetLoggingConfigLocation() {
        Object loggingObj = ServiceContext.GetServiceContext().getProperty("loggingConfigLocation", new boolean[]{false});
        if (loggingObj == null) {
            return null;
        }
        return loggingObj.toString();
    }
}

