/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.environment.exception.EnvironmentSerializationException;
import gr.uoa.di.madgik.environment.hint.EnvHintCollection;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.PlanConfig;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.variable.VariableCollection;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import gr.uoa.di.madgik.execution.utils.ValueCollection;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ExecutionPlan
implements Serializable {
    private static final long serialVersionUID = 1L;
    public IPlanElement Root = null;
    public EnvHintCollection EnvHints = new EnvHintCollection();
    public VariableCollection Variables = new VariableCollection();
    public PlanConfig Config = new PlanConfig();
    public List<String> CleanUpLocalFiles = new ArrayList<String>();
    public ValueCollection CleanUpSS = new ValueCollection();
    public ValueCollection CleanUpSSExclude = new ValueCollection();

    public IPlanElement Locate(String ID) {
        if (this.Root == null) {
            return null;
        }
        return this.Root.Locate(ID);
    }

    public Set<IPlanElement> LocateActionElements() {
        if (this.Root == null) {
            return new HashSet<IPlanElement>();
        }
        return this.Root.LocateActionElements();
    }

    public void Validate() throws ExecutionValidationException {
        this.Root.Validate();
    }

    public String Serialize() throws ExecutionSerializationException {
        try {
            this.Validate();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Serialization is not valid", ex);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("<executionPlan>");
        buf.append(this.Config.ToXML());
        buf.append(this.Variables.ToXML());
        try {
            buf.append(this.EnvHints.ToXML());
        }
        catch (EnvironmentSerializationException ex) {
            throw new ExecutionSerializationException("Could not serialize environment variables", ex);
        }
        buf.append("<cleanup>");
        buf.append("<local>");
        for (String f : this.CleanUpLocalFiles) {
            buf.append("<file name=\"" + f + "\"/>");
        }
        buf.append("</local>");
        buf.append("<ss>");
        buf.append("<include>");
        buf.append(this.CleanUpSS.ToXML());
        buf.append("</include>");
        buf.append("<exclude>");
        buf.append(this.CleanUpSSExclude.ToXML());
        buf.append("</exclude>");
        buf.append("</ss>");
        buf.append("</cleanup>");
        buf.append("<tree>");
        buf.append(this.Root.ToXML());
        buf.append("</tree>");
        buf.append("</executionPlan>");
        return buf.toString();
    }

    public void Deserialize(String serialization) throws ExecutionSerializationException {
        try {
            Document doc = XMLUtils.Deserialize((String)serialization);
            Element config = XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"config");
            if (config == null) {
                throw new ExecutionSerializationException("Not valid serialization of execution plan");
            }
            this.Config.FromXML(config);
            Element variables = XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"variables");
            if (variables == null) {
                throw new ExecutionSerializationException("Not valid serialization of execution plan");
            }
            this.Variables.FromXML(variables);
            Element envhints = XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"nhints");
            if (envhints == null) {
                throw new ExecutionSerializationException("Not valid serialization of execution plan");
            }
            this.EnvHints.FromXML(envhints);
            Element cleanupElement = XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"cleanup");
            if (cleanupElement == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            Element cleanupLocalElement = XMLUtils.GetChildElementWithName((Node)cleanupElement, (String)"local");
            if (cleanupLocalElement == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            List cleanupFilesElementlst = XMLUtils.GetChildElementsWithName((Node)cleanupLocalElement, (String)"file");
            this.CleanUpLocalFiles.clear();
            for (Element cleanupFileElement : cleanupFilesElementlst) {
                if (!XMLUtils.AttributeExists((Element)cleanupFileElement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("not valid serialization of element");
                }
                this.CleanUpLocalFiles.add(XMLUtils.GetAttribute((Element)cleanupFileElement, (String)"value"));
            }
            Element cleanupSSElement = XMLUtils.GetChildElementWithName((Node)cleanupElement, (String)"ss");
            if (cleanupSSElement == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            Element cleanupSSElementInclude = XMLUtils.GetChildElementWithName((Node)cleanupSSElement, (String)"include");
            if (cleanupSSElementInclude == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            Element cleanupSSElementValColl = XMLUtils.GetChildElementWithName((Node)cleanupSSElementInclude, (String)"valueColl");
            if (cleanupSSElementValColl != null) {
                this.CleanUpSS.FromXML(cleanupSSElementValColl);
            } else {
                this.CleanUpSS = new ValueCollection();
            }
            Element cleanupSSElementExclude = XMLUtils.GetChildElementWithName((Node)cleanupSSElement, (String)"exclude");
            if (cleanupSSElementExclude == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            Element cleanupSSElementValCollExc = XMLUtils.GetChildElementWithName((Node)cleanupSSElementExclude, (String)"valueColl");
            if (cleanupSSElementValCollExc != null) {
                this.CleanUpSSExclude.FromXML(cleanupSSElementValCollExc);
            } else {
                this.CleanUpSSExclude = new ValueCollection();
            }
            Element rootnode = XMLUtils.GetChildElementWithName((Node)XMLUtils.GetChildElementWithName((Node)doc.getDocumentElement(), (String)"tree"), (String)"planElement");
            this.Root = PlanElementUtils.GetPlanElement(rootnode);
            this.Validate();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize Plan", ex);
        }
    }
}

