/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.datatype;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.IDataType;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataTypeDoubleClass
implements IDataType {
    private static final long serialVersionUID = 1L;
    private Double Value = null;

    @Override
    public boolean CanSuggestDataTypeClass() {
        return true;
    }

    @Override
    public Class<?> GetDataTypeClass() {
        return this.Value.getClass();
    }

    @Override
    public IDataType.DataTypes GetDataTypeEnum() {
        return IDataType.DataTypes.DoubleClass;
    }

    @Override
    public String GetStringValue() throws ExecutionSerializationException {
        if (this.Value == null) {
            return "";
        }
        return this.Value.toString();
    }

    @Override
    public Object GetValue() {
        return this.Value;
    }

    @Override
    public void SetStringValue(String val) throws ExecutionValidationException, ExecutionSerializationException {
        if (val == null || val.trim().length() == 0) {
            this.SetValue(null);
        }
        this.SetValue(val);
    }

    @Override
    public void SetValue(Object Value) throws ExecutionValidationException {
        this.Value = Value == null ? null : Double.valueOf(DataTypeUtils.GetValueAsDouble(Value));
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!XMLUtils.AttributeExists((Element)XML, (String)"type").booleanValue()) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!IDataType.DataTypes.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetDataTypeEnum())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            Element valelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"value");
            if (valelem == null) {
                this.SetValue(null);
            } else {
                this.SetValue(XMLUtils.GetChildText((Node)valelem));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<dt type=\"" + this.GetDataTypeEnum().toString() + "\">");
        if (this.Value != null) {
            buf.append("<value>");
            buf.append(this.Value);
            buf.append("</value>");
        }
        buf.append("</dt>");
        return buf.toString();
    }
}

