/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.event;

import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;

public class ExecutionProgressReportStateEvent
extends ExecutionStateEvent {
    private long EmitTimestamp = Calendar.getInstance().getTimeInMillis();
    private boolean ReportsProgress = false;
    private boolean ReportsNodeProgress = false;
    private boolean ReportsNodeStatus = false;
    private int CurrentStep = 0;
    private int TotalSteps = 0;
    private String Message = "";
    private String ID = "";
    private String NodeName = "";
    private String NodeHostName = "";
    private int NodePort = -1;

    public ExecutionProgressReportStateEvent() {
        this.ReportsProgress = false;
        this.ReportsNodeProgress = false;
        this.ReportsNodeStatus = false;
    }

    public ExecutionProgressReportStateEvent(String ID, String Message) {
        this.ReportsProgress = false;
        this.ReportsNodeProgress = false;
        this.ReportsNodeStatus = false;
        this.Message = Message;
        this.ID = ID;
    }

    public ExecutionProgressReportStateEvent(String ID, int CurrentStep, int TotalSteps) {
        this.ReportsProgress = true;
        this.ReportsNodeProgress = false;
        this.ReportsNodeStatus = false;
        this.CurrentStep = CurrentStep;
        this.TotalSteps = TotalSteps;
        this.ID = ID;
    }

    public ExecutionProgressReportStateEvent(String ID, int CurrentStep, int TotalSteps, String Message) {
        this.ReportsProgress = true;
        this.ReportsNodeProgress = false;
        this.ReportsNodeStatus = false;
        this.CurrentStep = CurrentStep;
        this.TotalSteps = TotalSteps;
        this.Message = Message;
        this.ID = ID;
    }

    public ExecutionProgressReportStateEvent(String ID, int SuccessfulNodes, int TotalNodes, String Message, boolean ReportsNodeStatus) {
        this.ReportsProgress = false;
        this.ReportsNodeProgress = false;
        this.ReportsNodeStatus = ReportsNodeStatus;
        this.CurrentStep = SuccessfulNodes;
        this.TotalSteps = TotalNodes;
        this.Message = Message;
        this.ID = ID;
    }

    public ExecutionProgressReportStateEvent(String ID, int CurrentStep, int TotalSteps, String Message, String NodeName, String NodeHostName, int NodePort) {
        this.ReportsProgress = true;
        this.ReportsNodeProgress = true;
        this.ReportsNodeStatus = false;
        this.CurrentStep = CurrentStep;
        this.TotalSteps = TotalSteps;
        this.Message = Message;
        this.NodeName = NodeName;
        this.NodeHostName = NodeHostName;
        this.NodePort = NodePort;
        this.ID = ID;
    }

    public String GetID() {
        return this.ID;
    }

    public boolean DoesReportProgress() {
        return this.ReportsProgress;
    }

    public boolean DoesReportNodeProgress() {
        return this.ReportsNodeProgress;
    }

    public boolean DoesReportNodeStatus() {
        return this.ReportsNodeStatus;
    }

    public void DoesReportProgress(boolean ReportsProgress) {
        this.ReportsProgress = ReportsProgress;
    }

    public int GetCurrentStep() {
        return this.CurrentStep;
    }

    public void SetCurrentStep(int CurrentStep) {
        this.CurrentStep = CurrentStep;
    }

    public int GetTotalSteps() {
        return this.TotalSteps;
    }

    public void SetTotalSteps(int TotalSteps) {
        this.TotalSteps = TotalSteps;
    }

    public String GetMessage() {
        return this.Message;
    }

    public String GetNodeName() {
        return this.NodeName;
    }

    public String GetNodeHostName() {
        return this.NodeHostName;
    }

    public int GetNodePort() {
        return this.NodePort;
    }

    public void SetMessage(String Message) {
        this.Message = Message;
    }

    @Override
    public ExecutionStateEvent.EventName GetEventName() {
        return ExecutionStateEvent.EventName.ExecutionProgress;
    }

    @Override
    public long GetEmitTimestamp() {
        return this.EmitTimestamp;
    }

    @Override
    public void Decode(byte[] buf) throws ExecutionSerializationException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            DataInputStream din = new DataInputStream(bin);
            this.EmitTimestamp = din.readLong();
            this.ReportsProgress = din.readBoolean();
            this.ReportsNodeProgress = din.readBoolean();
            this.ReportsNodeStatus = din.readBoolean();
            this.CurrentStep = din.readInt();
            this.TotalSteps = din.readInt();
            this.ID = din.readUTF();
            this.Message = din.readUTF();
            this.NodeName = din.readUTF();
            this.NodeHostName = din.readUTF();
            this.NodePort = din.readInt();
            din.close();
            bin.close();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }

    @Override
    public byte[] Encode() throws ExecutionSerializationException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeLong(this.EmitTimestamp);
            dout.writeBoolean(this.ReportsProgress);
            dout.writeBoolean(this.ReportsNodeProgress);
            dout.writeBoolean(this.ReportsNodeStatus);
            dout.writeInt(this.CurrentStep);
            dout.writeInt(this.TotalSteps);
            dout.writeUTF(this.ID == null ? "" : this.ID);
            dout.writeUTF(this.Message == null ? "" : this.Message);
            dout.writeUTF(this.NodeName == null ? "" : this.NodeName);
            dout.writeUTF(this.NodeHostName == null ? "" : this.NodeHostName);
            dout.writeInt(this.NodePort);
            dout.flush();
            dout.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }
}

