/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.event;

import gr.uoa.di.madgik.execution.event.ExecutionStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Calendar;

public class ExecutionExternalProgressReportStateEvent
extends ExecutionStateEvent {
    private long EmitTimestamp = Calendar.getInstance().getTimeInMillis();
    private boolean ReportsProgress = false;
    private int CurrentStep = 0;
    private int TotalSteps = 0;
    private String Message = "";
    private String ID = "";
    private String ExternalSender = "";

    public ExecutionExternalProgressReportStateEvent() {
        this.ReportsProgress = false;
    }

    public ExecutionExternalProgressReportStateEvent(String ID, String ExternalSender, String Message) {
        this.ReportsProgress = false;
        this.Message = Message;
        this.ID = ID;
        this.ExternalSender = ExternalSender;
    }

    public ExecutionExternalProgressReportStateEvent(String ID, String ExternalSender, int CurrentStep, int TotalSteps) {
        this.ReportsProgress = true;
        this.CurrentStep = CurrentStep;
        this.TotalSteps = TotalSteps;
        this.ID = ID;
        this.ExternalSender = ExternalSender;
    }

    public ExecutionExternalProgressReportStateEvent(String ID, String ExternalSender, int CurrentStep, int TotalSteps, String Message) {
        this.ReportsProgress = true;
        this.CurrentStep = CurrentStep;
        this.TotalSteps = TotalSteps;
        this.Message = Message;
        this.ID = ID;
        this.ExternalSender = ExternalSender;
    }

    public String GetID() {
        return this.ID;
    }

    public boolean DoesReportProgress() {
        return this.ReportsProgress;
    }

    public void DoesReportProgress(boolean ReportsProgress) {
        this.ReportsProgress = ReportsProgress;
    }

    public int GetCurrentStep() {
        return this.CurrentStep;
    }

    public void SetCurrentStep(int CurrentStep) {
        this.CurrentStep = CurrentStep;
    }

    public int GetTotalSteps() {
        return this.TotalSteps;
    }

    public void SetTotalSteps(int TotalSteps) {
        this.TotalSteps = TotalSteps;
    }

    public String GetMessage() {
        return this.Message;
    }

    public void SetMessage(String Message) {
        this.Message = Message;
    }

    public String GetExternalSender() {
        return this.ExternalSender;
    }

    public void SetExternalSender(String ExternalSender) {
        this.ExternalSender = ExternalSender;
    }

    @Override
    public ExecutionStateEvent.EventName GetEventName() {
        return ExecutionStateEvent.EventName.ExecutionExternalProgress;
    }

    @Override
    public long GetEmitTimestamp() {
        return this.EmitTimestamp;
    }

    @Override
    public void Decode(byte[] buf) throws ExecutionSerializationException {
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(buf);
            DataInputStream din = new DataInputStream(bin);
            this.EmitTimestamp = din.readLong();
            this.ReportsProgress = din.readBoolean();
            this.CurrentStep = din.readInt();
            this.TotalSteps = din.readInt();
            this.ID = din.readUTF();
            this.Message = din.readUTF();
            this.ExternalSender = din.readUTF();
            din.close();
            bin.close();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }

    @Override
    public byte[] Encode() throws ExecutionSerializationException {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeLong(this.EmitTimestamp);
            dout.writeBoolean(this.ReportsProgress);
            dout.writeInt(this.CurrentStep);
            dout.writeInt(this.TotalSteps);
            dout.writeUTF(this.ID == null ? "" : this.ID);
            dout.writeUTF(this.Message == null ? "" : this.Message);
            dout.writeUTF(this.ExternalSender == null ? "" : this.ExternalSender);
            dout.flush();
            dout.close();
            bout.close();
            return bout.toByteArray();
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not serialize event", ex);
        }
    }
}

