/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import gr.uoa.di.madgik.execution.plan.element.invocable.ExceptionExitCodeMaping;
import gr.uoa.di.madgik.execution.plan.element.invocable.simple.AttributedInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputOutputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IInputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IOutputParameter;
import gr.uoa.di.madgik.execution.plan.element.variable.IParameter;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import gr.uoa.di.madgik.execution.utils.EnvironmentKeyValue;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.ParameterUtils;
import gr.uoa.di.madgik.execution.utils.ThreadBufferedReader;
import gr.uoa.di.madgik.execution.utils.ThreadBufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ShellPlanElement
extends PlanElementBase {
    private static Logger logger = LoggerFactory.getLogger(ShellPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = ShellPlanElement.class.getSimpleName();
    public List<ContingencyTrigger> Triggers = new ArrayList<ContingencyTrigger>();
    public String Command = null;
    public List<AttributedInputParameter> ArgumentParameters = new ArrayList<AttributedInputParameter>();
    public IInputParameter StdInParameter = null;
    public boolean StdInIsFile = false;
    public IInputOutputParameter StdOutParameter = null;
    public boolean StdOutIsFile = false;
    public ParameterFilterBase StdOutOnlineFilter = null;
    public IInputOutputParameter StdErrParameter = null;
    public boolean StdErrIsFile = false;
    public ParameterFilterBase StdErrOnlineFilter = null;
    public IOutputParameter StdExitValueParameter = null;
    public List<ExceptionExitCodeMaping> ExitCodeErrors = new ArrayList<ExceptionExitCodeMaping>();
    public List<EnvironmentKeyValue> Environment = new ArrayList<EnvironmentKeyValue>();

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            Element onlinefilterelement;
            IParameter param;
            Element comelem;
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element cont = XMLUtils.GetChildElementWithName((Node)XML, (String)"triggers");
            this.Triggers.clear();
            if (cont != null) {
                List trigs = XMLUtils.GetChildElementsWithName((Node)cont, (String)"contingency");
                for (Element trig : trigs) {
                    ContingencyTrigger t = new ContingencyTrigger();
                    t.FromXML(trig);
                    this.Triggers.add(t);
                }
            }
            if ((comelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"command")) == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            this.Command = XMLUtils.GetChildText((Node)comelem);
            Element argselem = XMLUtils.GetChildElementWithName((Node)XML, (String)"arguments");
            if (argselem == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            List params = XMLUtils.GetChildElementsWithName((Node)argselem, (String)"attrParam");
            this.ArgumentParameters.clear();
            for (Element a : params) {
                AttributedInputParameter attrParam = new AttributedInputParameter();
                attrParam.FromXML(a);
                this.ArgumentParameters.add(attrParam);
            }
            Element elemstdtmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"stdIn");
            if (elemstdtmp == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            Element elemparamtmp = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"param");
            if (elemparamtmp == null) {
                this.StdInParameter = null;
            } else {
                if (!XMLUtils.AttributeExists((Element)elemstdtmp, (String)"isFile").booleanValue()) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdInIsFile = DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)elemstdtmp, (String)"isFile"));
                param = ParameterUtils.GetParameter(elemparamtmp);
                if (!(param instanceof IInputParameter)) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdInParameter = (IInputParameter)param;
            }
            elemstdtmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"stdOut");
            if (elemstdtmp == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            elemparamtmp = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"param");
            if (elemparamtmp == null) {
                this.StdOutParameter = null;
            } else {
                if (!XMLUtils.AttributeExists((Element)elemstdtmp, (String)"isFile").booleanValue()) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdOutIsFile = DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)elemstdtmp, (String)"isFile"));
                param = ParameterUtils.GetParameter(elemparamtmp);
                if (!(param instanceof IInputOutputParameter)) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdOutParameter = (IInputOutputParameter)param;
                onlinefilterelement = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"filter");
                this.StdOutOnlineFilter = onlinefilterelement != null ? ParameterUtils.GetParameterFilter(onlinefilterelement) : null;
            }
            elemstdtmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"stdErr");
            if (elemstdtmp == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            elemparamtmp = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"param");
            if (elemparamtmp == null) {
                this.StdErrParameter = null;
            } else {
                if (!XMLUtils.AttributeExists((Element)elemstdtmp, (String)"isFile").booleanValue()) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdErrIsFile = DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)elemstdtmp, (String)"isFile"));
                param = ParameterUtils.GetParameter(elemparamtmp);
                if (!(param instanceof IInputOutputParameter)) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdErrParameter = (IInputOutputParameter)param;
                onlinefilterelement = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"filter");
                this.StdErrOnlineFilter = onlinefilterelement != null ? ParameterUtils.GetParameterFilter(onlinefilterelement) : null;
            }
            elemstdtmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"stdExit");
            if (elemstdtmp == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            elemparamtmp = XMLUtils.GetChildElementWithName((Node)elemstdtmp, (String)"param");
            if (elemparamtmp == null) {
                this.StdExitValueParameter = null;
            } else {
                param = ParameterUtils.GetParameter(elemparamtmp);
                if (!(param instanceof IOutputParameter)) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.StdExitValueParameter = (IOutputParameter)param;
            }
            Element maps = XMLUtils.GetChildElementWithName((Node)XML, (String)"exitCodeErrors");
            if (maps == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            List errmaps = XMLUtils.GetChildElementsWithName((Node)maps, (String)"exitCodeError");
            this.ExitCodeErrors.clear();
            for (Element errmap : errmaps) {
                ExceptionExitCodeMaping em = new ExceptionExitCodeMaping();
                em.FromXML(errmap);
                this.ExitCodeErrors.add(em);
            }
            Element envs = XMLUtils.GetChildElementWithName((Node)XML, (String)"env");
            if (envs == null) {
                throw new ExecutionSerializationException("Not valid serialization of element");
            }
            List envlst = XMLUtils.GetChildElementsWithName((Node)envs, (String)"item");
            this.Environment.clear();
            for (Element envit : envlst) {
                if (!XMLUtils.AttributeExists((Element)envit, (String)"key").booleanValue()) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                String envitKey = XMLUtils.GetAttribute((Element)envit, (String)"key");
                String envitValue = XMLUtils.GetChildText((Node)envit);
                if (envitKey == null || envitKey.trim().length() == 0) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                if (envitValue == null || envitValue.trim().length() == 0) {
                    throw new ExecutionSerializationException("Not valid serialization of element");
                }
                this.Environment.add(new EnvironmentKeyValue(envitKey, envitValue));
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Shell;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        acts.add(this);
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<triggers>");
        for (ContingencyTrigger trig : this.Triggers) {
            buf.append(trig.ToXML());
        }
        buf.append("</triggers>");
        buf.append("<command>" + this.Command + "</command>");
        buf.append("<arguments>");
        for (AttributedInputParameter argvar : this.ArgumentParameters) {
            buf.append(argvar.ToXML());
        }
        buf.append("</arguments>");
        if (this.StdInParameter == null) {
            buf.append("<stdIn/>");
        } else {
            buf.append("<stdIn isFile=\"" + this.StdInIsFile + "\">");
            buf.append(this.StdInParameter.ToXML());
            buf.append("</stdIn>");
        }
        if (this.StdOutParameter == null) {
            buf.append("<stdOut/>");
        } else {
            buf.append("<stdOut isFile=\"" + this.StdOutIsFile + "\">");
            buf.append(this.StdOutParameter.ToXML());
            if (this.StdOutOnlineFilter != null) {
                buf.append(this.StdOutOnlineFilter.ToXML());
            }
            buf.append("</stdOut>");
        }
        if (this.StdErrParameter == null) {
            buf.append("<stdErr/>");
        } else {
            buf.append("<stdErr isFile=\"" + this.StdErrIsFile + "\">");
            buf.append(this.StdErrParameter.ToXML());
            if (this.StdErrOnlineFilter != null) {
                buf.append(this.StdErrOnlineFilter.ToXML());
            }
            buf.append("</stdErr>");
        }
        if (this.StdExitValueParameter == null) {
            buf.append("<stdExit/>");
        } else {
            buf.append("<stdExit>");
            buf.append(this.StdExitValueParameter.ToXML());
            buf.append("</stdExit>");
        }
        buf.append("<exitCodeErrors>");
        for (ExceptionExitCodeMaping map : this.ExitCodeErrors) {
            buf.append(map.ToXML());
        }
        buf.append("</exitCodeErrors>");
        buf.append("<env>");
        for (EnvironmentKeyValue envkv : this.Environment) {
            buf.append("<item key=\"" + envkv.Key + "\">" + envkv.Value + "</item>");
        }
        buf.append("</env>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Command == null) {
            throw new ExecutionValidationException("Command not set");
        }
        if (this.ArgumentParameters == null) {
            throw new ExecutionValidationException("Argument variable names list can be empty but not null");
        }
        for (AttributedInputParameter param : this.ArgumentParameters) {
            param.Validate();
        }
        if (this.StdErrParameter != null) {
            this.StdErrParameter.Validate();
        }
        if (this.StdExitValueParameter != null) {
            this.StdExitValueParameter.Validate();
        }
        if (this.StdInParameter != null) {
            this.StdInParameter.Validate();
        }
        if (this.StdOutParameter != null) {
            this.StdOutParameter.Validate();
        }
        for (ExceptionExitCodeMaping map : this.ExitCodeErrors) {
            map.Validate();
        }
        if (this.Environment == null) {
            throw new ExecutionValidationException("Environment key value list can be empty but not null");
        }
        for (EnvironmentKeyValue envkv : this.Environment) {
            if (envkv.Key != null && envkv.Key.trim().length() != 0 && envkv.Value != null && envkv.Value.trim().length() != 0) continue;
            throw new ExecutionValidationException("Environment key values must have non empty values");
        }
        if (this.StdOutOnlineFilter != null && !this.StdOutOnlineFilter.SupportsOnLineFiltering()) {
            throw new ExecutionValidationException("Filteres provided for std out filtering need to support online filtering");
        }
        if (this.StdErrOnlineFilter != null && !this.StdErrOnlineFilter.SupportsOnLineFiltering()) {
            throw new ExecutionValidationException("Filteres provided for std err filtering need to support online filtering");
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        Set<String> ModifiedHere = this.GetModifiedVariableNames();
        for (AttributedInputParameter param : this.ArgumentParameters) {
            param.ValidatePreExecution(Handle, ModifiedHere);
        }
        if (this.StdErrParameter != null) {
            this.StdErrParameter.ValidatePreExecution(Handle, ModifiedHere);
        }
        if (this.StdExitValueParameter != null) {
            this.StdExitValueParameter.ValidatePreExecution(Handle, ModifiedHere);
        }
        if (this.StdInParameter != null) {
            this.StdInParameter.ValidatePreExecution(Handle, ModifiedHere);
        }
        if (this.StdOutParameter != null) {
            this.StdOutParameter.ValidatePreExecution(Handle, ModifiedHere);
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[]{IContingencyReaction.ReactionType.None, IContingencyReaction.ReactionType.Retry};
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return true;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return this.Triggers;
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (AttributedInputParameter param : this.ArgumentParameters) {
            vars.addAll(param.GetModifiedVariableNames());
        }
        if (this.StdErrParameter != null) {
            vars.addAll(this.StdErrParameter.GetModifiedVariableNames());
        }
        if (this.StdExitValueParameter != null) {
            vars.addAll(this.StdExitValueParameter.GetModifiedVariableNames());
        }
        if (this.StdInParameter != null) {
            vars.addAll(this.StdInParameter.GetModifiedVariableNames());
        }
        if (this.StdOutParameter != null) {
            vars.addAll(this.StdOutParameter.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (AttributedInputParameter param : this.ArgumentParameters) {
            vars.addAll(param.GetNeededVariableNames());
        }
        if (this.StdErrParameter != null) {
            vars.addAll(this.StdErrParameter.GetNeededVariableNames());
        }
        if (this.StdExitValueParameter != null) {
            vars.addAll(this.StdExitValueParameter.GetNeededVariableNames());
        }
        if (this.StdInParameter != null) {
            vars.addAll(this.StdInParameter.GetNeededVariableNames());
        }
        if (this.StdOutParameter != null) {
            vars.addAll(this.StdOutParameter.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int port = -1;
        String hostname = "Unknown";
        try {
            if (Handle.getHostingNodeInfo() != null) {
                String[] params = Handle.getHostingNodeInfo().split(":");
                hostname = params[0];
                if (params[1].compareTo("null") != 0) {
                    port = Integer.parseInt(params[1]);
                }
            }
        }
        catch (Exception e) {
            logger.warn("Unexpected error occurred!", (Throwable)e);
        }
        try {
            this.RegisterToRunningActionElementsRestriction(Handle);
            logger.debug("Starting");
            this.CheckStatus(Handle);
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 3, "Starting Execution of " + this.Name, this.Name, hostname, port));
            }
            String[] commArray = this.GetCommandArray(Handle);
            StringBuilder bufComm = new StringBuilder();
            for (String comArrItem : commArray) {
                bufComm.append(comArrItem + " ");
            }
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 3, "Starting Execution " + bufComm.toString(), this.Name, hostname, port));
            }
            ProcessBuilder build = new ProcessBuilder(commArray);
            for (EnvironmentKeyValue envkv : this.Environment) {
                build.environment().put(envkv.Key, envkv.Value);
            }
            if (Handle.IsIsolationRequested()) {
                build = build.directory(Handle.GetIsolationInfo().GetBaseDirFile().getAbsoluteFile());
            }
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            Object lockstd = new Object();
            Process p = null;
            ThreadBufferedWriter twriterInput = null;
            ThreadBufferedReader treaderOutput = null;
            ThreadBufferedReader treaderError = null;
            String output = null;
            String error = null;
            Object object = lockstd;
            synchronized (object) {
                p = build.start();
                twriterInput = this.WriteProcessInput(p.getOutputStream(), this.StdInParameter, Handle, lockstd);
                treaderOutput = this.GetProcessResult(p.getInputStream(), this.StdOutIsFile, this.StdOutIsFile ? DataTypeUtils.GetValueAsString(this.StdOutParameter.GetParameterValue(Handle)) : null, Handle, lockstd, this.StdOutOnlineFilter);
                treaderError = this.GetProcessResult(p.getErrorStream(), this.StdErrIsFile, this.StdErrIsFile ? DataTypeUtils.GetValueAsString(this.StdErrParameter.GetParameterValue(Handle)) : null, Handle, lockstd, this.StdErrOnlineFilter);
                while (!(twriterInput.Done && treaderOutput.Done.booleanValue() && treaderError.Done.booleanValue())) {
                    try {
                        lockstd.wait();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    logger.debug("twriterInput.Done (" + twriterInput.Done + ") treaderOutput.Done (" + treaderOutput.Done + ") treaderError.Done (" + treaderError.Done + ")");
                }
            }
            logger.debug("Waiting");
            p.waitFor();
            output = treaderOutput.Output;
            error = treaderError.Output;
            logger.debug("Done Waiting");
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Retrieving return values of " + this.Name, this.Name, hostname, port));
            }
            this.StopClock(PlanElementBase.ClockType.Children);
            this.StartClock(PlanElementBase.ClockType.Finilization);
            int exitvalue = p.exitValue();
            if (this.StdOutParameter != null) {
                this.StdOutParameter.SetParameterValue(Handle, output);
            }
            if (this.StdErrParameter != null) {
                this.StdErrParameter.SetParameterValue(Handle, error);
            }
            if (this.StdExitValueParameter != null) {
                this.StdExitValueParameter.SetParameterValue(Handle, exitvalue);
            }
            this.MapExitCodeToError(exitvalue);
        }
        catch (IOException ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        catch (ExecutionValidationException ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        catch (InterruptedException ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        finally {
            this.UnregisterToRunningActionElementsRestriction(Handle);
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 3, 3, "Finishing Execution of " + this.Name, this.Name, hostname, port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private void MapExitCodeToError(int ExitCode) throws ExecutionRunTimeException {
        block4: for (ExceptionExitCodeMaping map : this.ExitCodeErrors) {
            switch (map.TypeOfMapping) {
                case Equal: {
                    if (map.ExitCode != ExitCode) continue block4;
                    ExceptionUtils.ThrowTransformedException(map.ErrorFullName, map.ErrorSimpleName, map.Message);
                    continue block4;
                }
                case NotEqual: {
                    if (map.ExitCode == ExitCode) continue block4;
                    ExceptionUtils.ThrowTransformedException(map.ErrorFullName, map.ErrorSimpleName, map.Message);
                    continue block4;
                }
            }
            throw new ExecutionRunTimeException("Unrecognized type of exit code mapping");
        }
    }

    private String[] GetCommandArray(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        String[] cmdarray = new String[this.ArgumentParameters.size() + 1];
        cmdarray[0] = Handle.GetIsolatedFile(new File(this.Command)).getAbsolutePath();
        for (int i = 0; i < this.ArgumentParameters.size(); ++i) {
            try {
                cmdarray[i + 1] = DataTypeUtils.GetValueAsString(this.ArgumentParameters.get((int)i).Parameter.GetParameterValue(Handle));
                if (!this.ArgumentParameters.get((int)i).IsFile) continue;
                cmdarray[i + 1] = Handle.GetIsolatedFile(new File(cmdarray[i + 1])).getAbsolutePath();
                continue;
            }
            catch (Exception ex) {
                ExceptionUtils.ThrowTransformedException(ex);
            }
        }
        return cmdarray;
    }

    private ThreadBufferedWriter WriteProcessInput(OutputStream stream, IInputParameter StdInParameter, ExecutionHandle Handle, Object lockstd) throws ExecutionValidationException, ExecutionRunTimeException, IOException {
        ThreadBufferedWriter w = new ThreadBufferedWriter(stream, StdInParameter, this.StdInIsFile, Handle, lockstd);
        w.Do();
        return w;
    }

    private ThreadBufferedReader GetProcessResult(InputStream stream, boolean IsFile, String FileName, ExecutionHandle Handle, Object lockstd, ParameterFilterBase Filter) throws IOException, ExecutionRunTimeException {
        ThreadBufferedReader r = new ThreadBufferedReader(stream, IsFile, FileName, Handle, lockstd, Filter);
        r.Do();
        return r;
    }
}

