/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.filter;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.datatype.NamedDataType;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.filter.ParameterFilterBase;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ParameterXsltFilter
extends ParameterFilterBase {
    private static Logger logger = LoggerFactory.getLogger(ParameterXsltFilter.class);
    public String FilteredVariableName = null;
    public String FilterExpressionVariableName = null;
    public boolean StoreOutput = false;
    public String StoreOutputVariableName = null;

    @Override
    public Set<String> GetInputVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.FilteredVariableName);
        vars.add(this.FilterExpressionVariableName);
        return vars;
    }

    @Override
    public Set<String> GetStoreOutputVariableName() {
        HashSet<String> vars = new HashSet<String>();
        vars.add(this.StoreOutputVariableName);
        return vars;
    }

    @Override
    public boolean StoreOutput() {
        return this.StoreOutput;
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.FilteredVariableName == null || this.FilteredVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected parameter name not provided");
        }
        if (this.FilterExpressionVariableName == null || this.FilterExpressionVariableName.trim().length() == 0) {
            throw new ExecutionValidationException("Expected filter expression not provided");
        }
        if (this.StoreOutput && (this.StoreOutputVariableName == null || this.StoreOutputVariableName.trim().length() == 0)) {
            throw new ExecutionValidationException("No output variable name defined to store output");
        }
        this.TokenMappingValidate();
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.Validate();
        if (!Handle.GetPlan().Variables.Contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilteredVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
        if (this.StoreOutput) {
            for (String storeVarName : this.GetStoreOutputVariableName()) {
                if (Handle.GetPlan().Variables.Contains(storeVarName)) continue;
                throw new ExecutionValidationException("Needed parameter to store output not present");
            }
        }
        if (!Handle.GetPlan().Variables.Contains(this.FilterExpressionVariableName)) {
            throw new ExecutionValidationException("Needed parameter not found");
        }
        ndt = Handle.GetPlan().Variables.Get(this.FilterExpressionVariableName);
        if (!ndt.IsAvailable.booleanValue() && !ExcludeAvailableConstraint.contains(this.FilterExpressionVariableName)) {
            throw new ExecutionValidationException("Needed variable not available");
        }
    }

    @Override
    public boolean SupportsOnLineFiltering() {
        return false;
    }

    @Override
    public void ValidateForOnlineFiltering() throws ExecutionValidationException {
        throw new ExecutionValidationException("On line filtering is not supported");
    }

    @Override
    public void ValidatePreExecutionForOnlineFiltering(ExecutionHandle Handle, Set<String> ExcludeAvailableConstraint) throws ExecutionValidationException {
        this.ValidateForOnlineFiltering();
    }

    @Override
    public Object Process(ExecutionHandle Handle) throws ExecutionRunTimeException {
        try {
            NamedDataType ndt = Handle.GetPlan().Variables.Get(this.FilteredVariableName);
            NamedDataType ndtx = Handle.GetPlan().Variables.Get(this.FilterExpressionVariableName);
            logger.debug("Xslt filtering on source : " + ndt.Value.GetStringValue());
            logger.debug("Applied xslt is : " + ndtx.Value.GetStringValue());
            return XMLUtils.Transform((String)ndt.Value.GetStringValue(), (String)ndtx.Value.GetStringValue());
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not extract value", ex);
        }
    }

    @Override
    public Object ProcessOnLine(Object OnLineFilteredValue, Set<NamedDataType> AdditionalValueProviders, ExecutionHandle Handle) throws ExecutionRunTimeException {
        throw new ExecutionRunTimeException("On line filtering is not supported");
    }

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            Element tmp;
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"order").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutput").booleanValue())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            if (!ParameterFilterBase.FilterType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetFilterType())) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.Order = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"order"));
            this.StoreOutput = Boolean.parseBoolean(XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutput"));
            if (this.StoreOutput) {
                if (!XMLUtils.AttributeExists((Element)((Element)XML), (String)"storeOutputName").booleanValue()) {
                    throw new ExecutionSerializationException("Provided serialization is not valid");
                }
                this.StoreOutputVariableName = XMLUtils.GetAttribute((Element)((Element)XML), (String)"storeOutputName");
            }
            if ((tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"filteredVariable")) == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilteredVariableName = XMLUtils.GetChildText((Node)tmp);
            tmp = XMLUtils.GetChildElementWithName((Node)XML, (String)"expressionVariable");
            if (tmp == null) {
                throw new ExecutionSerializationException("Provided serialization is not valid");
            }
            this.FilterExpressionVariableName = XMLUtils.GetChildText((Node)tmp);
            this.TokenMappingFromXML(XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        String outputvarString = "";
        if (this.StoreOutputVariableName != null) {
            outputvarString = "storeOutputName=\"" + this.StoreOutputVariableName + "\"";
        }
        buf.append("<filter type=\"" + this.GetFilterType().toString() + "\" order=\"" + this.GetOrder() + "\" storeOutput=\"" + Boolean.toString(this.StoreOutput) + "\" " + outputvarString + ">");
        buf.append("<filteredVariable>" + this.FilteredVariableName + "</filteredVariable>");
        buf.append("<expressionVariable>" + this.FilterExpressionVariableName + "</expressionVariable>");
        buf.append(this.TokenMappingToXML());
        buf.append("</filter>");
        return buf.toString();
    }

    @Override
    public ParameterFilterBase.FilterType GetFilterType() {
        return ParameterFilterBase.FilterType.Xslt;
    }
}

